"use strict";

var _interopRequire = function (obj) { return obj && obj.__esModule ? obj["default"] : obj; };

var _createClass = (function () { function defineProperties(target, props) { for (var key in props) { var prop = props[key]; prop.configurable = true; if (prop.value) prop.writable = true; } Object.defineProperties(target, props); } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

/*
  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

var WeakMap = _interopRequire(require("es6-weak-map"));

var _scope = require("./scope");

var Scope = _interopRequire(_scope);

var assert = _interopRequire(require("assert"));

var GlobalScope = _scope.GlobalScope;
var CatchScope = _scope.CatchScope;
var WithScope = _scope.WithScope;
var ModuleScope = _scope.ModuleScope;
var ClassScope = _scope.ClassScope;
var SwitchScope = _scope.SwitchScope;
var FunctionScope = _scope.FunctionScope;
var ForScope = _scope.ForScope;
var TDZScope = _scope.TDZScope;
var FunctionExpressionNameScope = _scope.FunctionExpressionNameScope;
var BlockScope = _scope.BlockScope;

/**
 * @class ScopeManager
 */

var ScopeManager = (function () {
    function ScopeManager(options) {
        _classCallCheck(this, ScopeManager);

        this.scopes = [];
        this.globalScope = null;
        this.__nodeToScope = new WeakMap();
        this.__currentScope = null;
        this.__options = options;
        this.__declaredVariables = new WeakMap();
    }

    _createClass(ScopeManager, {
        __useDirective: {
            value: function __useDirective() {
                return this.__options.directive;
            }
        },
        __isOptimistic: {
            value: function __isOptimistic() {
                return this.__options.optimistic;
            }
        },
        __ignoreEval: {
            value: function __ignoreEval() {
                return this.__options.ignoreEval;
            }
        },
        __isNodejsScope: {
            value: function __isNodejsScope() {
                return this.__options.nodejsScope;
            }
        },
        isModule: {
            value: function isModule() {
                return this.__options.sourceType === "module";
            }
        },
        __get: {

            // Returns appropliate scope for this node.

            value: function __get(node) {
                return this.__nodeToScope.get(node);
            }
        },
        getDeclaredVariables: {

            /**
             * Get variables that are declared by the node.
             *
             * "are declared by the node" means the node is same as `Variable.defs[].node` or `Variable.defs[].parent`.
             * If the node declares nothing, this method returns an empty array.
             * CAUTION: This API is experimental. See https://github.com/estools/escope/pull/69 for more details.
             *
             * @param {Esprima.Node} node - a node to get.
             * @returns {Variable[]} variables that declared by the node.
             */

            value: function getDeclaredVariables(node) {
                return this.__declaredVariables.get(node) || [];
            }
        },
        acquire: {

            /**
             * acquire scope from node.
             * @method ScopeManager#acquire
             * @param {Esprima.Node} node - node for the acquired scope.
             * @param {boolean=} inner - look up the most inner scope, default value is false.
             * @return {Scope?}
             */

            value: function acquire(node, inner) {
                var scopes, scope, i, iz;

                function predicate(scope) {
                    if (scope.type === "function" && scope.functionExpressionScope) {
                        return false;
                    }
                    if (scope.type === "TDZ") {
                        return false;
                    }
                    return true;
                }

                scopes = this.__get(node);
                if (!scopes || scopes.length === 0) {
                    return null;
                }

                // Heuristic selection from all scopes.
                // If you would like to get all scopes, please use ScopeManager#acquireAll.
                if (scopes.length === 1) {
                    return scopes[0];
                }

                if (inner) {
                    for (i = scopes.length - 1; i >= 0; --i) {
                        scope = scopes[i];
                        if (predicate(scope)) {
                            return scope;
                        }
                    }
                } else {
                    for (i = 0, iz = scopes.length; i < iz; ++i) {
                        scope = scopes[i];
                        if (predicate(scope)) {
                            return scope;
                        }
                    }
                }

                return null;
            }
        },
        acquireAll: {

            /**
             * acquire all scopes from node.
             * @method ScopeManager#acquireAll
             * @param {Esprima.Node} node - node for the acquired scope.
             * @return {Scope[]?}
             */

            value: function acquireAll(node) {
                return this.__get(node);
            }
        },
        release: {

            /**
             * release the node.
             * @method ScopeManager#release
             * @param {Esprima.Node} node - releasing node.
             * @param {boolean=} inner - look up the most inner scope, default value is false.
             * @return {Scope?} upper scope for the node.
             */

            value: function release(node, inner) {
                var scopes, scope;
                scopes = this.__get(node);
                if (scopes && scopes.length) {
                    scope = scopes[0].upper;
                    if (!scope) {
                        return null;
                    }
                    return this.acquire(scope.block, inner);
                }
                return null;
            }
        },
        attach: {
            value: function attach() {}
        },
        detach: {
            value: function detach() {}
        },
        __nestScope: {
            value: function __nestScope(scope) {
                if (scope instanceof GlobalScope) {
                    assert(this.__currentScope === null);
                    this.globalScope = scope;
                }
                this.__currentScope = scope;
                return scope;
            }
        },
        __nestGlobalScope: {
            value: function __nestGlobalScope(node) {
                return this.__nestScope(new GlobalScope(this, node));
            }
        },
        __nestBlockScope: {
            value: function __nestBlockScope(node, isMethodDefinition) {
                return this.__nestScope(new BlockScope(this, this.__currentScope, node));
            }
        },
        __nestFunctionScope: {
            value: function __nestFunctionScope(node, isMethodDefinition) {
                return this.__nestScope(new FunctionScope(this, this.__currentScope, node, isMethodDefinition));
            }
        },
        __nestForScope: {
            value: function __nestForScope(node) {
                return this.__nestScope(new ForScope(this, this.__currentScope, node));
            }
        },
        __nestCatchScope: {
            value: function __nestCatchScope(node) {
                return this.__nestScope(new CatchScope(this, this.__currentScope, node));
            }
        },
        __nestWithScope: {
            value: function __nestWithScope(node) {
                return this.__nestScope(new WithScope(this, this.__currentScope, node));
            }
        },
        __nestClassScope: {
            value: function __nestClassScope(node) {
                return this.__nestScope(new ClassScope(this, this.__currentScope, node));
            }
        },
        __nestSwitchScope: {
            value: function __nestSwitchScope(node) {
                return this.__nestScope(new SwitchScope(this, this.__currentScope, node));
            }
        },
        __nestModuleScope: {
            value: function __nestModuleScope(node) {
                return this.__nestScope(new ModuleScope(this, this.__currentScope, node));
            }
        },
        __nestTDZScope: {
            value: function __nestTDZScope(node) {
                return this.__nestScope(new TDZScope(this, this.__currentScope, node));
            }
        },
        __nestFunctionExpressionNameScope: {
            value: function __nestFunctionExpressionNameScope(node) {
                return this.__nestScope(new FunctionExpressionNameScope(this, this.__currentScope, node));
            }
        },
        __isES6: {
            value: function __isES6() {
                return this.__options.ecmaVersion >= 6;
            }
        }
    });

    return ScopeManager;
})();

module.exports = ScopeManager;

/* vim: set sw=4 ts=4 et tw=80 : */
//# sourceMappingURL=data:application/json;base64,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