'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _applyMiddleware = require('redux/lib/applyMiddleware');

var _applyMiddleware2 = _interopRequireDefault(_applyMiddleware);

var _delegant = require('delegant');

var _delegant2 = _interopRequireDefault(_delegant);

var _createStore = require('redux/lib/createStore');

var _createStore2 = _interopRequireDefault(_createStore);

var _virtexDom = require('virtex-dom');

var _virtexDom2 = _interopRequireDefault(_virtexDom);

var _isDomLoaded = require('@f/is-dom-loaded');

var _isDomLoaded2 = _interopRequireDefault(_isDomLoaded);

var _virtexLocal = require('virtex-local');

var _virtexLocal2 = _interopRequireDefault(_virtexLocal);

var _virtexComponent = require('virtex-component');

var _virtexComponent2 = _interopRequireDefault(_virtexComponent);

var _emptyElement = require('@f/empty-element');

var _emptyElement2 = _interopRequireDefault(_emptyElement);

var _isObject = require('@f/is-object');

var _isObject2 = _interopRequireDefault(_isObject);

var _queue = require('@f/queue');

var _queue2 = _interopRequireDefault(_queue);

var _debounce = require('@f/debounce');

var _debounce2 = _interopRequireDefault(_debounce);

var _foreach = require('@f/foreach');

var _foreach2 = _interopRequireDefault(_foreach);

var _reduxMulti = require('redux-multi');

var _reduxMulti2 = _interopRequireDefault(_reduxMulti);

var _reduxFalsy = require('redux-falsy');

var _reduxFalsy2 = _interopRequireDefault(_reduxFalsy);

var _reduxThunk = require('redux-thunk');

var _reduxThunk2 = _interopRequireDefault(_reduxThunk);

var _equal = require('@f/equal');

var _equal2 = _interopRequireDefault(_equal);

var _virtex2 = require('virtex');

var _virtex3 = _interopRequireDefault(_virtex2);

var _map = require('@f/map');

var _map2 = _interopRequireDefault(_map);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
                                                                                                                                                                                                     * Imports
                                                                                                                                                                                                     */

/**
 * vdux
 */

function vdux() {
  var opts = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
  var _opts$middleware = opts.middleware;
  var middleware = _opts$middleware === undefined ? [] : _opts$middleware;
  var _opts$reducer = opts.reducer;
  var reducer = _opts$reducer === undefined ? function (state) {
    return state;
  } : _opts$reducer;
  var _opts$initialState = opts.initialState;
  var initialState = _opts$initialState === undefined ? {} : _opts$initialState;
  var node = opts.node;
  var prerendered = opts.prerendered;

  /**
   * Create redux store
   */

  var prevTree = undefined;
  var context = {};
  var forceUpdate = false;
  var rendering = false;
  var delegated = false;
  var dirty = {};
  var components = {};
  var postRenderQueue = (0, _queue2.default)();
  var store = _applyMiddleware2.default.apply(undefined, [_reduxFalsy2.default, _reduxMulti2.default, _virtexDom2.default, (0, _virtexLocal2.default)('ui', dirty), (0, _virtexComponent2.default)({
    components: components,
    postRender: postRenderQueue.add,
    getContext: function getContext() {
      return context;
    },
    ignoreShouldUpdate: function ignoreShouldUpdate() {
      return forceUpdate;
    }
  }), _reduxThunk2.default].concat(_toConsumableArray(middleware)))(_createStore2.default)((0, _virtexLocal.mount)('ui', reducer), initialState);

  /**
   * Initialize virtex
   */

  var _virtex = (0, _virtex3.default)(store.dispatch);

  var create = _virtex.create;
  var update = _virtex.update;
  var updatePaths = _virtex.updatePaths;

  return {
    replaceReducer: function replaceReducer(_reducer) {
      reducer = _reducer;
      store.replaceReducer((0, _virtexLocal.mount)('ui', reducer));
    },
    dispatch: function dispatch(action) {
      store.dispatch(action);
    },
    getState: function getState() {
      return store.getState();
    },
    subscribe: function subscribe(fn) {
      if (!(0, _isDomLoaded2.default)()) {
        throw new Error('vdux: Please wait until the document (i.e. DOMContentLoaded) is ready before calling subscribe');
      }

      var debouncedFn = (0, _debounce2.default)(function () {
        rendering ? debouncedFn() : fn(store.getState());
      });

      /**
       * Create the Virtual DOM <-> Redux cycle
       */

      var stop = [];
      stop.push(store.subscribe(debouncedFn));

      if (!delegated) {
        stop.push((0, _delegant2.default)(document, store.dispatch));
        stop.push((0, _delegant.delegateGlobal)(window, store.dispatch));
        delegated = true;
      }

      /**
       * Initial render
       */

      debouncedFn();
      return function () {
        return stop.forEach(function (fn) {
          return fn();
        });
      };
    },
    render: function render(tree) {
      var _context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var force = arguments[2];

      // If there is a context update, we need
      // to do a forced full re-render
      if (!(0, _equal2.default)(context, _context)) {
        context = _context;
        force = true;
      }

      forceUpdate = force;
      rendering = true;

      prevTree ? updateDom(prevTree, tree) : createDom(tree);

      prevTree = tree;
      forceUpdate = false;

      // Run any pending afterRender lifecycle hooks
      var nextTicks = postRenderQueue.flush();

      // Give afterRender hooks a guaranteed way to execute some code
      // on the next tick but before the next render
      setTimeout(function () {
        (0, _foreach2.default)(function run(fn) {
          if ('function' === typeof fn) fn();
          if (Array.isArray(fn)) (0, _foreach2.default)(run, fn);
        }, nextTicks);

        rendering = false;
      });

      return node.firstChild;
    }
  };

  /**
   * Sync the virtual dom and the actual dom
   */

  function createDom(tree) {
    node = node || document.body;

    if (!prerendered) {
      (0, _emptyElement2.default)(node);
      node.appendChild(create(tree).element);
    } else {
      create(tree, 'a', node.firstChild);
    }

    return node.firstChild;
  }

  function updateDom(oldTree, newTree) {
    update(oldTree, newTree);
    updateDirty();
    return node.firstChild;
  }

  function updateDirty() {
    (0, _foreach2.default)(function (path) {
      // Check that it's still dirty, since the re-rendering of a higher component
      // may cause one of the lower ones to get re-rendered
      if (dirty[path]) {
        var _component = components[path];

        if (_component) {
          var prev = _extends({}, _component);

          // Clear cached vnodes/elements
          _component.vnode = null;
          update(prev, _component, path);
        }
      }

      // Sort by shortest dirty paths first, so that if possible
      // we get some of the higher re-renders cleaning up some
      // of the lower ones
    }, Object.keys(dirty).sort(function (a, b) {
      return a.length - b.length;
    }));
  }
}

/**
 * Exports
 */

exports.default = vdux;