'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _eventHandler = require('@f/event-handler');

var _eventHandler2 = _interopRequireDefault(_eventHandler);

var _virtexElement = require('virtex-element');

var _virtexElement2 = _interopRequireDefault(_virtexElement);

var _foreach = require('@f/foreach');

var _foreach2 = _interopRequireDefault(_foreach);

var _evStore = require('ev-store');

var _evStore2 = _interopRequireDefault(_evStore);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create a global listener component
 */

/**
 * Imports
 */

function globalListener() {
  var node = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

  var store = undefined;

  /**
   * onCreate
   */

  function onCreate(_ref) {
    var path = _ref.path;
    var props = _ref.props;

    // Allow node to be passed in as a function so that we can late-bind it, for
    // things like document.body, which are only created after the DOM is ready
    store = store || (0, _evStore2.default)('function' === typeof node ? node() : node);
    listen(path, props);
  }

  /**
   * Special window component
   */

  function render(_ref2) {
    var props = _ref2.props;
    var children = _ref2.children;
    var path = _ref2.path;

    if (children.length > 1) {
      throw new Error('Window component may have only 1 child');
    }

    return children[0] || (0, _virtexElement2.default)('span', { 'class': 'global-listener' });
  }

  /**
   * onUpdate - Clear and reset the handlers
   */

  function onUpdate(prev, next) {
    clear(prev.path);
    listen(next.path, next.props);
  }

  /**
   * onRemove - Clear all the handlers
   */

  function onRemove(_ref3) {
    var path = _ref3.path;

    clear(path);
  }

  /**
   * Helpers
   */

  function clear(path) {
    (0, _foreach2.default)(function (name) {
      delete store[name][path];
    }, store[path]);
    delete store[path];
  }

  function listen(path, props) {
    store[path] = [];
    (0, _foreach2.default)(function (fn, key) {
      var name = key.slice(2).toLowerCase(); // onResize -> resize
      store[path].push(name);
      store[name] = store[name] || {};
      store[name][path] = (0, _eventHandler2.default)(fn);
    }, props);
  }

  return {
    onCreate: onCreate,
    render: render,
    onUpdate: onUpdate,
    onRemove: onRemove
  };
}

/**
 * Exports
 */

exports.default = globalListener;