'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _redux = require('redux');

var _virtexLocal = require('virtex-local');

var _virtexLocal2 = _interopRequireDefault(_virtexLocal);

var _virtexComponent = require('virtex-component');

var _virtexComponent2 = _interopRequireDefault(_virtexComponent);

var _virtexString = require('virtex-string');

var _virtexString2 = _interopRequireDefault(_virtexString);

var _reduxMulti = require('redux-multi');

var _reduxMulti2 = _interopRequireDefault(_reduxMulti);

var _reduxFalsy = require('redux-falsy');

var _reduxFalsy2 = _interopRequireDefault(_reduxFalsy);

var _equal = require('@f/equal');

var _equal2 = _interopRequireDefault(_equal);

var _virtex2 = require('virtex');

var _virtex3 = _interopRequireDefault(_virtex2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
                                                                                                                                                                                                     * Imports
                                                                                                                                                                                                     */

/**
 * vdux
 */

function vdux() {
  var opts = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
  var _opts$middleware = opts.middleware;
  var middleware = _opts$middleware === undefined ? [] : _opts$middleware;
  var _opts$reducer = opts.reducer;
  var reducer = _opts$reducer === undefined ? function (state) {
    return state;
  } : _opts$reducer;
  var _opts$initialState = opts.initialState;
  var initialState = _opts$initialState === undefined ? {} : _opts$initialState;

  /**
   * Create redux store
   */

  var context = undefined;
  var forceUpdate = false;

  var componentOpts = {
    getContext: function getContext() {
      return context;
    },
    ignoreShouldUpdate: function ignoreShouldUpdate() {
      return forceUpdate;
    }
  };

  var store = _redux.applyMiddleware.apply(undefined, [_reduxFalsy2.default, _reduxMulti2.default, _virtexString2.default, (0, _virtexLocal2.default)('ui'), (0, _virtexComponent2.default)(componentOpts)].concat(_toConsumableArray(middleware)))(_redux.createStore)((0, _virtexLocal.mount)('ui', reducer), initialState);

  /**
   * Initialize virtex
   */

  var _virtex = (0, _virtex3.default)(store.dispatch);

  var create = _virtex.create;
  var update = _virtex.update;

  /**
   * Create the Virtual DOM <-> Redux cycle
   */

  var prev = undefined;

  return {
    subscribe: function subscribe(fn) {
      var deferred = function deferred() {
        return setTimeout(function () {
          return fn(store.getState());
        });
      };
      var stop = store.subscribe(deferred);
      deferred();
      return stop;
    },
    render: function render(tree, _context) {
      if (!(0, _equal2.default)(context, _context)) {
        context = _context;
        forceUpdate = true;
      }

      var html = (prev ? update(prev, tree) : create(tree)).element;
      prev = tree;
      forceUpdate = false;

      return html;
    }
  };
}

/**
 * Exports
 */

exports.default = vdux;