'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _virtex = require('virtex');

var _foreach = require('@f/foreach');

var _foreach2 = _interopRequireDefault(_foreach);

var _svg = require('./svg');

var _svg2 = _interopRequireDefault(_svg);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Constants
 */

var setAttribute = _virtex.actions.setAttribute; /**
                                                  * Imports
                                                  */

var cache = {};

/**
 * Create a DOM element
 */

function createElement(doc, dispatch, vnode) {
  if (vnode.type === '#text') {
    return doc.createTextNode(vnode.props.nodeValue);
  }

  var type = vnode.type;
  var props = vnode.props;
  var children = vnode.children;

  var cached = cache[type];

  if (typeof cached === 'undefined') {
    cached = cache[type] = _svg2.default.isElement(type) ? doc.createElementNS(_svg2.default.namespace, type) : doc.createElement(type);
  }

  var node = cached.cloneNode(false);

  if (props !== null) {
    for (var key in props) {
      var val = props[key];
      if (val !== null && val !== undefined) {
        dispatch(setAttribute(node, key, val));
      }
    }
  }

  for (var i = 0, len = children.length; i < len; ++i) {
    node.appendChild(children[i].el);
  }

  return node;
}

/**
 * Exports
 */

exports.default = createElement;