'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _virtex = require('virtex');

var _setAttribute = require('./setAttribute');

var _setAttribute2 = _interopRequireDefault(_setAttribute);

var _removeAttribute = require('./removeAttribute');

var _removeAttribute2 = _interopRequireDefault(_removeAttribute);

var _createElement = require('./createElement');

var _createElement2 = _interopRequireDefault(_createElement);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Constants
 */

/**
 * Imports
 */

var _actions$types = _virtex.actions.types;
var CREATE_ELEMENT = _actions$types.CREATE_ELEMENT;
var SET_ATTRIBUTE = _actions$types.SET_ATTRIBUTE;
var REMOVE_ATTRIBUTE = _actions$types.REMOVE_ATTRIBUTE;
var APPEND_CHILD = _actions$types.APPEND_CHILD;
var REPLACE_NODE = _actions$types.REPLACE_NODE;
var INSERT_BEFORE = _actions$types.INSERT_BEFORE;
var REMOVE_NODE = _actions$types.REMOVE_NODE;

/**
 * Virtex DOM effects driver
 */

function dom(doc) {
  return function (_ref) {
    var dispatch = _ref.dispatch;
    return function (next) {
      return function (action) {
        switch (action.type) {
          case CREATE_ELEMENT:
            return (0, _createElement2.default)(doc, dispatch, action.vnode);
          case SET_ATTRIBUTE:
            return (0, _setAttribute2.default)(dispatch, action.node, action.name, action.value);
          case REMOVE_ATTRIBUTE:
            return (0, _removeAttribute2.default)(action.node, action.name);
          case APPEND_CHILD:
            return action.node.appendChild(action.newNode);
          case REMOVE_NODE:
            {
              var node = action.node;

              return node.parentNode.removeChild(node);
            }
          case REPLACE_NODE:
            {
              var node = action.node;
              var newNode = action.newNode;

              return node.parentNode.replaceChild(newNode, node);
            }
          case INSERT_BEFORE:
            {
              var node = action.node;
              var newNode = action.newNode;
              var pos = action.pos;

              return node.insertBefore(newNode, node.childNodes[pos] || null);
            }
        }

        return next(action);
      };
    };
  };
}

/**
 * Exports
 */

exports.default = dom;