'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _eventHandler = require('@f/event-handler');

var _eventHandler2 = _interopRequireDefault(_eventHandler);

var _virtex = require('virtex');

var _capitalize = require('@f/capitalize');

var _capitalize2 = _interopRequireDefault(_capitalize);

var _focusElement = require('@f/focus-element');

var _focusElement2 = _interopRequireDefault(_focusElement);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _isObject = require('@f/is-object');

var _isObject2 = _interopRequireDefault(_isObject);

var _keychord = require('@f/keychord');

var _keychord2 = _interopRequireDefault(_keychord);

var _domEvents = require('@f/dom-events');

var _domEvents2 = _interopRequireDefault(_domEvents);

var _evStore = require('ev-store');

var _evStore2 = _interopRequireDefault(_evStore);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Constants
 */

var eventRegex = new RegExp('^on(?:' + _domEvents2.default.join('|') + ')$', 'i');

/**
 * virtex-element
 */

/**
 * Imports
 */

function element(tag, attrs) {
  // Only apply sugar to native elements
  if (typeof tag === 'string' && attrs) {
    for (var key in attrs) {
      attrs[key] = sugar(attrs[key], key);
    }
  }

  return _virtex.element.apply(null, arguments);
}

function sugar(value, name) {
  switch (name) {
    case 'class':
      return (0, _classnames2.default)(value);
    case 'focused':
      return value && function (node) {
        return setTimeout(function () {
          return (0, _focusElement2.default)(node);
        });
      };
    default:
      return eventRegex.test(name) ? bindEvent(name.slice(2).toLowerCase(), value) : value;
  }
}

function bindEvent(name, fn) {
  return function (node) {
    return (0, _evStore2.default)(node)[name] = (0, _eventHandler2.default)(fn);
  };
}

/**
 * Exports
 */

exports.default = element;