'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _isUndefined = require('@f/is-undefined');

var _isUndefined2 = _interopRequireDefault(_isUndefined);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { return obj && typeof Symbol !== "undefined" && obj.constructor === Symbol ? "symbol" : typeof obj; } /**
                                                                                                                              * Imports
                                                                                                                              */

/**
 * Vnode creator
 */

function element(type, props) {
  var len = arguments.length;
  var children = [];

  for (var i = 2, j = 0; i < len; ++i) {
    j += filterFlatten(arguments[i], children, j);
  }

  var key = undefined;
  if (props && !(0, _isUndefined2.default)(props.key)) {
    key = props.key;
    if (Object.keys(props).length === 1) {
      props = undefined;
    } else {
      props.key = undefined;
    }
  }

  return {
    key: key,
    type: type,
    props: props,
    children: children
  };
}

/**
 * Very fast in-place, single-pass filter/flatten
 * algorithm
 */

function filterFlatten(item, arr, arrStart) {
  var added = 0;

  switch (type(item)) {
    case 'array':
      var len = item.length;
      for (var i = 0; i < len; ++i) {
        added += filterFlatten(item[i], arr, arrStart + added);
      }
      return added;
    case 'null':
    case 'undefined':
      return 0;
    case 'string':
    case 'number':
      arr[arrStart] = element('#text', { nodeValue: item });
      break;
    default:
      arr[arrStart] = item;
      break;
  }

  return 1;
}

function type(val) {
  if (Array.isArray(val)) return 'array';
  if (val === null) return 'null';
  return typeof val === 'undefined' ? 'undefined' : _typeof(val);
}

/**
 * Exports
 */

exports.default = element;