/**
 * Imports
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _shallowEquals = require('shallow-equals');

var _shallowEquals2 = _interopRequireDefault(_shallowEquals);

var _getUid = require('get-uid');

var _getUid2 = _interopRequireDefault(_getUid);

/**
 * Action event name
 */

var ActionEvent = 'virtual-component-action';

/**
 * Virtual component
 */

function factory(component, props, children) {
  if (!props) props = {};

  var _render = component.render || component;

  props.children = children;

  if (component.transformProps) {
    props = component.transformProps(props);
  }

  return {
    props: props,
    type: 'Thunk',
    component: component,
    render: function render(prev) {
      var vnode = undefined;

      if (!prev || !isSameThunk(prev, this)) {
        this.hookKey = (0, _getUid2['default'])();
        execHook(component.beforeMount, props);
        return applyHook(chainThunks(_render(props), this), this.hookKey, createComponentHook(component, props));
      } else if (shouldUpdate(component, prev.props, props)) {
        execHook(component.beforeUpdate, prev.props, props);
        setTimeout(function () {
          return execHook(component.afterUpdate, prev.props, props);
        });

        vnode = chainThunks(_render(props), this);
        this.hookKey = prev.hookKey;
        vnode.properties[this.hookKey] = prev.vnode.properties[this.hookKey];
        vnode.properties[this.hookKey].props = this.props;
        return vnode;
      } else {
        this.hookKey = prev.hookKey;
        prev.vnode.properties[this.hookKey].props = this.props;
        return prev.vnode;
      }
    }
  };
}

function chainThunks(thunk, prev) {
  if (!isThunk(thunk)) return thunk;

  var prevThunk = prev.nextThunk;
  prev.nextThunk = thunk;
  thunk.vnode = thunk.render(prevThunk);

  return thunk.vnode;
}

function isThunk(t) {
  return t && t.type === 'Thunk';
}

function applyHook(vnode, key, hook) {
  vnode.hooks = vnode.hooks || {};
  vnode.properties = vnode.properties || {};
  vnode.hooks[key] = vnode.properties[key] = hook;

  return vnode;
}

function isSameThunk(prev, cur) {
  return isThunk(prev) && prev.component === cur.component;
}

function createComponentHook(component, props) {
  return Object.create({
    hook: function hook() {
      return setTimeout(function () {
        return execHook(component.afterMount, props);
      });
    },
    unhook: function unhook() {
      return execHook(component.beforeUnmount, props);
    }
  });
}

function shouldUpdate(component, prevProps, nextProps) {
  if (prevProps && nextProps && (0, _shallowEquals2['default'])(prevProps.children, nextProps.children)) {
    nextProps.children = prevProps.children;
  }

  return component.shouldUpdate ? component.shouldUpdate(prevProps, nextProps) : !(0, _shallowEquals2['default'])(prevProps, nextProps);
}

function execHook(fn) {
  if (fn) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    var action = fn.apply(undefined, args);
    action && dispatch(action);
    return action;
  }
}

function dispatch(action) {
  var ev = new CustomEvent(ActionEvent, { detail: action });
  // XXX This is a temporary solution until we settle on a better way of
  // accomplishing this.  dispatchEvent is imperative and not universal.
  setTimeout(function () {
    return window.dispatchEvent(ev);
  });
}

function listen(fn) {
  window.addEventListener(ActionEvent, listener, true);
  return function () {
    return window.removeEventListener(ActionEvent, listener, true);
  };

  function listener(e) {
    fn(e.detail);
  }
}

/**
 * Exports
 */

exports['default'] = factory;
exports.listen = listen;