'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _element = require('vdux/element');

var _element2 = _interopRequireDefault(_element);

var _merge = require('../utils/merge');

var _merge2 = _interopRequireDefault(_merge);

var _isArray = require('@f/is-array');

var _isArray2 = _interopRequireDefault(_isArray);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var getStyles = function getStyles() {
  return {
    container: {
      padding: '20px 25px',
      backgroundColor: 'white',
      boxShadow: '0 0 5px 0 rgba(0,0,0,0.2)',
      marginBottom: '10px'
    },
    title: {
      fontSize: '18px',
      margin: '5px 0',
      fontWeight: 'bold'
    },
    action: {
      marginBottom: '5px',
      fontStyle: 'italic'
    },
    paragraph: {
      whiteSpace: 'pre'
    }
  };
};

function render(_ref) {
  var props = _ref.props;
  var action = props.action;
  var item = props.item;

  var styles = getStyles();
  return (0, _element2.default)(
    'div',
    { style: styles.container },
    action && (0, _element2.default)(
      'div',
      { style: styles.action },
      ' > ',
      action,
      ' '
    ),
    (0, _element2.default)(
      'div',
      { style: styles.paragraph },
      (0, _isArray2.default)(item) ? item.map(function (child) {
        return (0, _element2.default)(
          'div',
          null,
          child
        );
      }) : item
    )
  );
}

exports.default = {
  render: render
};