import baseSortedIndex from './_baseSortedIndex';

/**
 * Uses a binary search to determine the lowest index at which `value` should
 * be inserted into `array` in order to maintain its sort order.
 *
 * @static
 * @memberOf _
 * @category Array
 * @param {Array} array The sorted array to inspect.
 * @param {*} value The value to evaluate.
 * @returns {number} Returns the index at which `value` should be inserted into `array`.
 * @example
 *
 * _.sortedIndex([30, 50], 40);
 * // => 1
 *
 * _.sortedIndex([4, 5], 4);
 * // => 0
 */
function sortedIndex(array, value) {
  return baseSortedIndex(array, value);
}

export default sortedIndex;
