/**
 * Imports
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _virtualDomH = require('virtual-dom/h');

var _virtualDomH2 = _interopRequireDefault(_virtualDomH);

var _virtualDomVirtualHyperscriptHooksFocusHook = require('virtual-dom/virtual-hyperscript/hooks/focus-hook');

var _virtualDomVirtualHyperscriptHooksFocusHook2 = _interopRequireDefault(_virtualDomVirtualHyperscriptHooksFocusHook);

var _virtualComponent = require('virtual-component');

var _virtualComponent2 = _interopRequireDefault(_virtualComponent);

/**
 * Property map
 */

var propertyMap = {
  // transformed name
  'class': 'className',
  'for': 'htmlFor',
  'http-equiv': 'httpEquiv',
  // case specificity
  'accesskey': 'accessKey',
  'autocomplete': 'autoComplete',
  'autoplay': 'autoPlay',
  'colspan': 'colSpan',
  'contenteditable': 'contentEditable',
  'contextmenu': 'contextMenu',
  'enctype': 'encType',
  'formnovalidate': 'formNoValidate',
  'hreflang': 'hrefLang',
  'novalidate': 'noValidate',
  'readonly': 'readOnly',
  'rowspan': 'rowSpan',
  'spellcheck ': 'spellCheck',
  'srcdoc': 'srcDoc',
  'srcset': 'srcSet',
  'tabindex': 'tabIndex'
};

/**
 * Element
 */

function element(tag, attrs) {
  for (var _len = arguments.length, children = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    children[_key - 2] = arguments[_key];
  }

  // Flatten children and strip most falsy elements (notably not '0', and 0)
  children = children.filter(function (child) {
    return !(child === undefined || child === null || child === false || child === '');
  });

  if (typeof tag !== 'string') {
    return (0, _virtualComponent2['default'])(tag, attrs, children);
  }

  return (0, _virtualDomH2['default'])(tag, normalizeAttrs(attrs), children);
}

/**
 * Normalize attributes (e.g. class -> className) so that
 * we can use standard HTML names for things
 *
 * Note: This function is mutative for performance.  I think that is probably always ok because of the way attrs
 * are passed around?  But if it ever gets to be a problem it should be changed.
 */

function normalizeAttrs(attrs) {
  if (!attrs) return attrs;

  for (var key in attrs) {
    if (attrs.hasOwnProperty(key) && propertyMap[key]) {
      attrs[propertyMap[key]] = attrs[key];
      delete attrs[key];
    }
  }

  if (attrs.className) {
    attrs.className = classSugar(attrs.className);
  }

  if (attrs.focused) {
    attrs.focused = new _virtualDomVirtualHyperscriptHooksFocusHook2['default']();
  }

  return attrs;
}

/**
 * Accept arrays of class names or objects mapping boolean
 * values to class names: e.g. {complete: true}
 */

function classSugar(cls) {
  if (isPlainObject(cls)) {
    cls = Object.keys(cls).filter(function (key) {
      return cls[key];
    });
  }

  return Array.isArray(cls) ? cls.join(' ') : cls;
}

/**
 * Check if something is a plain object
 */

function isPlainObject(o) {
  return Object.prototype.toString.call(o) === '[object Object]';
}

/**
 * Exports
 */

exports['default'] = element;
module.exports = exports['default'];