/**
 * Imports
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _reduxEphemeral = require('redux-ephemeral');

var _composeFunction = require('compose-function');

var _composeFunction2 = _interopRequireDefault(_composeFunction);

/**
 * Vdux local
 */

function localize(component) {
  if (typeof component === 'function') {
    component = { render: component };
  }

  var _component = component;
  var _component$beforeUpdate = _component.beforeUpdate;

  var _beforeUpdate = _component$beforeUpdate === undefined ? noop : _component$beforeUpdate;

  var _component$afterUpdate = _component.afterUpdate;

  var _afterUpdate = _component$afterUpdate === undefined ? noop : _component$afterUpdate;

  return _extends({}, component, {
    transformProps: (0, _composeFunction2['default'])(transformProps(component.initialState), component.transformProps || identity),
    beforeMount: composeActions(beforeMount(component.reducer), component.beforeMount),
    beforeUnmount: composeActions(beforeUnmount, component.beforeUnmount),
    render: function render(props) {
      return component.render(props, childState(props.key, props.state));
    },
    beforeUpdate: function beforeUpdate(prevProps, nextProps) {
      return _beforeUpdate(prevProps, nextProps, prevProps.state, nextProps.state);
    },
    afterUpdate: function afterUpdate(prevProps, nextProps) {
      return _afterUpdate(prevProps, nextProps, prevProps.state, nextProps.state);
    }
  });
}

/**
 * Local action-creator creator
 */

function localAction(type) {
  return function (key, payload, meta) {
    return (0, _reduxEphemeral.updateEphemeral)(key, {
      type: type,
      payload: payload,
      meta: meta
    });
  };
}

/**
 * Child state helper
 */

function childState(key, parentState) {
  return function () {
    for (var _len = arguments.length, path = Array(_len), _key = 0; _key < _len; _key++) {
      path[_key] = arguments[_key];
    }

    return {
      state: getPath(parentState, path),
      key: key + '.' + path.join('.')
    };
  };
}

/**
 * Hooks
 */

function transformProps() {
  var initialState = arguments.length <= 0 || arguments[0] === undefined ? function () {
    return {};
  } : arguments[0];

  return function (props) {
    props.state = props.state || initialState(props);
    return props;
  };
}

function beforeMount() {
  var reducer = arguments.length <= 0 || arguments[0] === undefined ? function (state) {
    return state;
  } : arguments[0];

  return function (props) {
    if (!props.key) {
      throw new Error('You cannot create a local component without a props.key');
    }

    return (0, _reduxEphemeral.createEphemeral)(props.key, reducer, props.state);
  };
}

function beforeUnmount(props) {
  return (0, _reduxEphemeral.destroyEphemeral)(props.key);
}

/**
 * Action creator composition utility
 */

function composeActions(a, b) {
  return function () {
    return b ? [].concat(b.apply(undefined, arguments), a.apply(undefined, arguments)).filter(Boolean) : a.apply(undefined, arguments);
  };
}

/**
 * Get a property path from an object
 */

function getPath(obj, path) {
  var p = obj;

  for (var i = 0; p && i < path.length; i++) {
    p = p[path[i]];
  }

  return p;
}

function noop() {}
function identity(a) {
  return a;
}

/**
 * Exports
 */

exports['default'] = localize;
exports.localAction = localAction;