'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _redux = require('redux');

var _combineReducers = require('@f/combine-reducers');

var _combineReducers2 = _interopRequireDefault(_combineReducers);

var _composeReducers = require('@f/compose-reducers');

var _composeReducers2 = _interopRequireDefault(_composeReducers);

var _virtexComponent = require('virtex-component');

var _virtexComponent2 = _interopRequireDefault(_virtexComponent);

var _reduxEphemeral = require('redux-ephemeral');

var _reduxEphemeral2 = _interopRequireDefault(_reduxEphemeral);

var _virtexLocal = require('virtex-local');

var _virtexLocal2 = _interopRequireDefault(_virtexLocal);

var _reduxMulti = require('redux-multi');

var _reduxMulti2 = _interopRequireDefault(_reduxMulti);

var _virtexDom = require('virtex-dom');

var _virtexDom2 = _interopRequireDefault(_virtexDom);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Default middleware
 */

/**
 * Imports
 */

var defaults = [(0, _virtexLocal2.default)('app'), _virtexComponent2.default, (0, _virtexDom2.default)(document), _reduxMulti2.default];

/**
 * vdux-preset-client
 */

function client() {
  for (var _len = arguments.length, middleware = Array(_len), _key = 0; _key < _len; _key++) {
    middleware[_key] = arguments[_key];
  }

  var configStore = _redux.applyMiddleware.apply(undefined, defaults.concat(middleware))(_redux.createStore);

  return function (reducer) {
    var initialState = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    var finalReducer = (0, _composeReducers2.default)(reducer, (0, _combineReducers2.default)({
      app: _reduxEphemeral2.default
    }));

    initialState.app = initialState.app || {};
    return configStore(finalReducer, initialState);
  };
}

/**
 * Exports
 */

exports.default = client;