'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getUid = require('get-uid');

var _getUid2 = _interopRequireDefault(_getUid);

var _virtex = require('virtex');

var _defaults = require('@f/defaults');

var _defaults2 = _interopRequireDefault(_defaults);

var _arrayEqual = require('@f/array-equal');

var _arrayEqual2 = _interopRequireDefault(_arrayEqual);

var _objectEqual = require('@f/object-equal');

var _objectEqual2 = _interopRequireDefault(_objectEqual);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Constants
 */

var _actions$types = _virtex.actions.types; /**
                                             * Imports
                                             */

var CREATE_THUNK = _actions$types.CREATE_THUNK;
var UPDATE_THUNK = _actions$types.UPDATE_THUNK;
var DESTROY_THUNK = _actions$types.DESTROY_THUNK;

/**
 * virtex-component
 */

function middleware(_ref) {
  var dispatch = _ref.dispatch;

  var maybeDispatch = function maybeDispatch(action) {
    return action && dispatch(action);
  };

  return function (next) {
    return function (action) {
      switch (action.type) {
        case CREATE_THUNK:
          return create(maybeDispatch, action.vnode);
        case UPDATE_THUNK:
          return update(maybeDispatch, action.vnode, action.prev);
        case DESTROY_THUNK:
          return destroy(maybeDispatch, action.vnode);
        default:
          return next(action);
      }
    };
  };
}

function create(dispatch, thunk) {
  var component = thunk.type;
  var beforeMount = component.beforeMount;
  var afterMount = component.afterMount;

  thunk.props = thunk.props || {};

  // Setup the default immutable shouldUpdate if this component
  // hasn't exported one
  component.shouldUpdate = component.shouldUpdate || shouldUpdate;

  beforeMount && dispatch(beforeMount(thunk));

  var vnode = thunk.vnode = render(component, thunk);

  if (afterMount) {
    vnode.props = vnode.props || {};
    vnode.props[(0, _getUid2.default)() + ':afterMount'] = function () {
      dispatch(afterMount(thunk));
    };
  }

  return vnode;
}

function update(dispatch, thunk, prev) {
  if (thunk.vnode) return thunk.vnode;

  var component = thunk.type;
  var beforeUpdate = component.beforeUpdate;
  var afterUpdate = component.afterUpdate;
  var shouldUpdate = component.shouldUpdate;

  thunk.props = thunk.props || {};
  (0, _defaults2.default)(thunk, prev);

  if (shouldUpdate(prev, thunk)) {
    beforeUpdate && dispatch(beforeUpdate(prev, thunk));
    thunk.vnode = render(component, thunk);
    afterUpdate && dispatch(afterUpdate(prev, thunk));

    return thunk.vnode;
  }

  return thunk.vnode = prev.vnode;
}

function destroy(dispatch, thunk) {
  var beforeUnmount = thunk.type.beforeUnmount;

  beforeUnmount && dispatch(beforeUnmount(thunk));
}

function render(component, thunk) {
  return typeof component === 'function' ? component(thunk) : component.render(thunk);
}

function shouldUpdate(prev, next) {
  return !(0, _arrayEqual2.default)(prev.children, next.children) || !(0, _objectEqual2.default)(prev.props, next.props);
}

/**
 * Exports
 */

exports.default = middleware;