'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _setValue = require('./setValue');

var _setValue2 = _interopRequireDefault(_setValue);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Remove an attribute from an element
 */

function removeAttribute(node, name) {
  switch (name) {
    case 'checked':
    case 'disabled':
    case 'selected':
      node[name] = false;
      break;
    case 'innerHTML':
      node.innerHTML = '';
      break;
    case 'value':
      (0, _setValue2.default)(node, null);
      break;
    default:
      node.removeAttribute(name);
      break;
  }
}

/**
 * Exports
 */

/**
 * Imports
 */

exports.default = removeAttribute;