'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _virtex = require('virtex');

var _setValue = require('./setValue');

var _setValue2 = _interopRequireDefault(_setValue);

var _svg = require('./svg');

var _svg2 = _interopRequireDefault(_svg);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { return obj && typeof Symbol !== "undefined" && obj.constructor === Symbol ? "symbol" : typeof obj; } /**
                                                                                                                              * Imports
                                                                                                                              */

/**
 * Constants
 */

var removeAttribute = _virtex.actions.removeAttribute;

/**
 * Set an attribute on an element
 */

function setAttribute(dispatch, node, name, value) {
  if (typeof value === 'function') {
    value = value(node, name);
  }

  if (isValidAttr(value)) {
    switch (name) {
      case 'nodeValue':
      case 'checked':
      case 'disabled':
      case 'selected':
      case 'innerHTML':
      case 'textContent':
        node[name] = value;
        break;
      case 'value':
        (0, _setValue2.default)(node, value);
        break;
      default:
        var attrNamespace = _svg2.default.getNamespaceOfAttribute(name);
        if (attrNamespace !== null) {
          node.setAttributeNS(attrNamespace, name, value);
        } else {
          node.setAttribute(name, value);
        }
        break;
    }
  } else {
    dispatch(removeAttribute(node, name));
  }
}

function isValidAttr(val) {
  switch (typeof val === 'undefined' ? 'undefined' : _typeof(val)) {
    case 'string':
    case 'number':
      return true;
    case 'boolean':
      return val;
    default:
      return false;
  }
}

/**
 * Exports
 */

exports.default = setAttribute;