'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _virtex = require('virtex');

function _typeof(obj) { return obj && typeof Symbol !== "undefined" && obj.constructor === Symbol ? "symbol" : typeof obj; } /**
                                                                                                                              * Imports
                                                                                                                              */

/**
 * Actions
 */

var CREATE_ELEMENT = _virtex.actions.types.CREATE_ELEMENT;

/**
 * Virtex string
 */

function string(_ref) {
  var dispatch = _ref.dispatch;

  return function (next) {
    return function (action) {
      if (action.type === CREATE_ELEMENT) {
        var _action$vnode = action.vnode;
        var type = _action$vnode.type;
        var props = _action$vnode.props;
        var children = _action$vnode.children;

        return type === '#text' ? props.nodeValue : '<' + type + renderAttrs(props) + '>' + children.map(function (c) {
          return c.el;
        }).join('') + '</' + type + '>';
      }

      return next(action);
    };
  };

  function renderAttrs(attrs) {
    if (!attrs) return '';

    var str = '';

    for (var key in attrs) {
      var val = attrs[key];

      if (isValidAttr(val)) {
        str += ' ' + key + '="' + val + '"';
      }
    }

    return str;
  }

  function isValidAttr(val) {
    switch (typeof val === 'undefined' ? 'undefined' : _typeof(val)) {
      case 'string':
      case 'number':
        return true;
      case 'boolean':
        return val;
      default:
        return false;
    }
  }
}

/**
 * Exports
 */

exports.default = string;