'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _isString = require('@f/is-string');

var _isString2 = _interopRequireDefault(_isString);

var _actions = require('./actions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Create the initial document fragment
 */

/**
 * Imports
 */

function create(effect) {
  return function (vnode) {
    var path = arguments.length <= 1 || arguments[1] === undefined ? '0' : arguments[1];
    var idx = arguments.length <= 2 || arguments[2] === undefined ? 0 : arguments[2];
    return createRecursive(vnode, path, idx);
  };

  function createRecursive(vnode, path, idx) {
    while (!(0, _isString2.default)(vnode.type)) {
      vnode.path = path = path + '.' + (vnode.key || idx);
      vnode = effect((0, _actions.createThunk)(vnode));
    }

    var vchildren = vnode.children;

    for (var i = 0, len = vchildren.length; i < len; ++i) {
      var child = vchildren[i];
      child.el = createRecursive(child, path, i);
    }

    return vnode.el = effect((0, _actions.createElement)(vnode));
  }
}

/**
 * Exports
 */

exports.default = create;