'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _isString = require('@f/is-string');

var _isString2 = _interopRequireDefault(_isString);

var _isUndefined = require('@f/is-undefined');

var _isUndefined2 = _interopRequireDefault(_isUndefined);

var _foreach = require('@f/foreach');

var _foreach2 = _interopRequireDefault(_foreach);

var _create2 = require('./create');

var _create3 = _interopRequireDefault(_create2);

var _actions = require('./actions');

var _dift = require('dift');

var _dift2 = _interopRequireDefault(_dift);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Diff and render two vnode trees
 */

/**
 * Imports
 */

function update(effect) {
  var create = (0, _create3.default)(effect);
  return function (prev, next) {
    return updateRecursive(prev, next, '0', 0);
  };

  function updateRecursive(prev, next, path, idx) {
    var ptype = prev.type;
    var ntype = next.type;
    var pattrs = prev.props;
    var nattrs = next.props;
    var node = next.el = prev.el;

    if (ptype !== ntype) {
      if (!(0, _isString2.default)(ptype)) {
        prev = unrenderThunks(prev);
      }

      var oldNode = prev.el;
      var newNode = next.el = create(next);
      effect((0, _actions.replaceNode)(oldNode, newNode));
      return newNode;
    } else if (ntype === '#text') {
      if (nattrs.nodeValue !== pattrs.nodeValue) {
        effect((0, _actions.setAttribute)(node, 'nodeValue', nattrs.nodeValue));
      }

      return node;
    } else if (!(0, _isString2.default)(ntype)) {
      next.path = path = path + '.' + (next.key || idx);
      next = effect((0, _actions.updateThunk)(next, prev));
      prev = prev.vnode;

      return prev === next ? next.el = prev.el : updateRecursive(prev, next, path, 0);
    } else {
      /**
       * Diff attributes
       */

      (0, _foreach2.default)(function (val, key) {
        if (!nattrs || (0, _isUndefined2.default)(nattrs[key])) {
          effect((0, _actions.removeAttribute)(node, key));
        }
      }, pattrs);

      (0, _foreach2.default)(function (val, key) {
        if (!pattrs || val !== pattrs[key]) {
          effect((0, _actions.setAttribute)(node, key, val));
        }
      }, nattrs);

      /**
       * Diff children
       */

      (0, _dift2.default)(prev.children, next.children, function (type, pItem, nItem, pos) {
        switch (type) {
          case _dift.UPDATE:
            return updateRecursive(pItem, nItem, path, pos);
          case _dift.CREATE:
            return effect((0, _actions.insertBefore)(node, create(nItem, path, pos), pos));
          case _dift.MOVE:
            return effect((0, _actions.insertBefore)(node, updateRecursive(pItem, nItem, path, pos), pos));
          case _dift.REMOVE:
            unrenderThunks(pItem);
            return effect((0, _actions.removeNode)(nativeElement(pItem)));
        }
      }, key);

      return node;
    }
  }

  function key(vnode) {
    return vnode.key;
  }

  function nativeElement(vnode) {
    while (vnode.vnode) vnode = vnode.vnode;
    return vnode.el;
  }

  function unrenderThunks(vnode) {
    while (vnode.vnode) {
      effect((0, _actions.destroyThunk)(vnode));
      vnode = vnode.vnode;
    }

    unrenderChildren(vnode);
    return vnode;
  }

  function unrenderChildren(vnode) {
    var children = vnode.children;

    for (var i = 0, len = children.length; i < len; ++i) {
      unrenderThunks(children[i]);
    }
  }
}

/**
 * Exports
 */

exports.default = update;