'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

var _element = require('vdux/element');

var _element2 = _interopRequireDefault(_element);

var _reducer = require('./reducer');

var _reducer2 = _interopRequireDefault(_reducer);

var _dom = require('vdux/dom');

var _dom2 = _interopRequireDefault(_dom);

var _app = require('./app');

var _app2 = _interopRequireDefault(_app);

var _reduce = require('@f/reduce');

var _reduce2 = _interopRequireDefault(_reduce);

var _domready = require('domready');

var _domready2 = _interopRequireDefault(_domready);

var _reduxFlo = require('redux-flo');

var _reduxFlo2 = _interopRequireDefault(_reduxFlo);

var _handleSubmit = require('./middleware/handleSubmit');

var _handleSubmit2 = _interopRequireDefault(_handleSubmit);

var _actions = require('./actions');

var _isArray = require('@f/is-array');

var _isArray2 = _interopRequireDefault(_isArray);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var defaultView = function defaultView(output) {
  if ((typeof output === 'undefined' ? 'undefined' : _typeof(output)) !== 'object' || output.props) {
    return output;
  } else if ((0, _isArray2.default)(output)) {
    output.join('\n');
  } else {
    return (0, _reduce2.default)(function (arr, item, key) {
      arr.push(key + ': ' + item);
      return arr;
    }, [], output).join('\n');
  }
};

var defaultOpts = {
  view: defaultView,
  initialState: {},
  middleware: [],
  welcome: ''
};

var cycleShell = function cycleShell(userUpdate) {
  var opts = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

  var _defaultOpts$opts = _extends({}, defaultOpts, opts);

  var view = _defaultOpts$opts.view;
  var initialState = _defaultOpts$opts.initialState;
  var middleware = _defaultOpts$opts.middleware;
  var welcome = _defaultOpts$opts.welcome;


  var initState = { welcome: welcome, log: {}, user: initialState };

  var _vdux = (0, _dom2.default)({
    reducer: _reducer2.default,
    initialState: initState,
    middleware: [(0, _reduxFlo2.default)(), (0, _handleSubmit2.default)(userUpdate)].concat(_toConsumableArray(middleware))
  });

  var subscribe = _vdux.subscribe;
  var render = _vdux.render;

  (0, _domready2.default)(function () {
    subscribe(function (state) {
      render((0, _element2.default)(_app2.default, { log: state.log, view: view, user: state.user, welcome: state.welcome }));
    });
  });
};

module.exports = cycleShell;
cycleShell.out = _actions.out;