/**
 * Modules
 */

var slice = require('@f/slice')
var setProto = require('@f/set-proto')
var isFunction = require('@f/is-function')
var Generator = require('@f/generator')
var isGenerator = require('@f/is-generator')

/**
 * Vars
 */

var bind = Function.prototype.bind

/**
 * Expose toGenerator
 */

module.exports = toGenerator['default'] = toGenerator

/**
 * Make constructor look like a generator
 * @param  {Function} fn [description]
 * @return {Function}
 */

function toGenerator (fn) {
  if (isGenerator(fn)) return fn
  if (!isFunction(fn)) throw new TypeError('`fn` must be a function, got: ' + String(fn))

  function Gen () {
    var args = slice(arguments)
    if (!(this instanceof Gen)) {
      return new (bind.apply(Gen, [null].concat(args)))
    }
    return fn.apply(this, args)
  }

  setProto(Generator.FunctionPrototype, Gen)
  Gen.prototype = Object.create(Generator.Object.prototype)

  return Gen
}
