'use strict';

// limit amount of consecutive white spaces and line breaks adjacent to a given
// token.

var _br = require('rocambole-linebreak');
var _ws = require('rocambole-whitespace');

exports.before = limitBefore;
function limitBefore(token, typeOrValue) {
  _br.limitBefore(token, typeOrValue);
  _ws.limitBefore(token, typeOrValue);
}


exports.after = limitAfter;
function limitAfter(token, typeOrValue) {
  _br.limitAfter(token, typeOrValue);
  _ws.limitAfter(token, typeOrValue);
}


exports.around = limitAround;
function limitAround(token, typeOrValue) {
  _br.limit(token, typeOrValue);
  _ws.limit(token, typeOrValue);
}
