'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _toPromise = require('@f/to-promise');

var _toPromise2 = _interopRequireDefault(_toPromise);

var _map = require('@f/map');

var _map2 = _interopRequireDefault(_map);

var _identity = require('@f/identity');

var _identity2 = _interopRequireDefault(_identity);

var _isIterator = require('@f/is-iterator');

var _isIterator2 = _interopRequireDefault(_isIterator);

var _isGenerator = require('@f/is-generator');

var _isGenerator2 = _interopRequireDefault(_isGenerator);

var _isPromise = require('@f/is-promise');

var _isPromise2 = _interopRequireDefault(_isPromise);

var _isFunctor = require('@f/is-functor');

var _isFunctor2 = _interopRequireDefault(_isFunctor);

var _isFunction = require('@f/is-function');

var _isFunction2 = _interopRequireDefault(_isFunction);

var _logError = require('@f/log-error');

var _logError2 = _interopRequireDefault(_logError);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FLO = 'FLO';

/**
 * Flo middleWare
 * @param  {Function} errorHandler=defaultErrorHandler
 * @param  {Function} successHandler=identity
 * @return {Function} Redux middleware
 */

/**
 * Import
 */

function flow() {
  var errorHandler = arguments.length <= 0 || arguments[0] === undefined ? _logError2.default : arguments[0];
  var successHandler = arguments.length <= 1 || arguments[1] === undefined ? _identity2.default : arguments[1];

  return function (_ref) {
    var dispatch = _ref.dispatch;
    return function (next) {
      return function (action) {
        var promise = void 0;
        if ((0, _isFunctor2.default)(action) || (0, _isGenerator2.default)(action) || (0, _isIterator2.default)(action)) {
          promise = (0, _toPromise2.default)((0, _map2.default)(function (action) {
            return action && dispatch(action);
          }, action));
        } else if ((0, _isPromise2.default)(action) || (0, _isFunction2.default)(action)) {
          promise = (0, _toPromise2.default)(action);
        } else {
          return next(action);
        }
        return promise.then(successHandler, errorHandler);
      };
    };
  };
}

exports.default = flow;