'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _reduxEphemeral = require('redux-ephemeral');

var _objectEqual = require('@f/object-equal');

var _objectEqual2 = _interopRequireDefault(_objectEqual);

var _arrayEqual = require('@f/array-equal');

var _arrayEqual2 = _interopRequireDefault(_arrayEqual);

var _getProp = require('@f/get-prop');

var _getProp2 = _interopRequireDefault(_getProp);

var _virtex = require('virtex');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Constants
 */

var _actions$types = _virtex.actions.types; /**
                                             * Imports
                                             */

var CREATE_THUNK = _actions$types.CREATE_THUNK;
var UPDATE_THUNK = _actions$types.UPDATE_THUNK;
var DESTROY_THUNK = _actions$types.DESTROY_THUNK;

/**
 * Provide local state to virtex components
 */

function local() {
  var prop = arguments.length <= 0 || arguments[0] === undefined ? '' : arguments[0];

  return function (_ref) {
    var getState = _ref.getState;
    var dispatch = _ref.dispatch;

    var state = function state() {
      return (0, _getProp2.default)(prop, getState());
    };

    return function (next) {
      return function (action) {
        switch (action.type) {
          case CREATE_THUNK:
            create(dispatch, action.vnode);
            break;
          case UPDATE_THUNK:
            update(state, action.vnode, action.prev);
            break;
          case DESTROY_THUNK:
            destroy(dispatch, action.vnode);
            break;
        }

        return next(action);
      };
    };
  };
}

function create(dispatch, thunk) {
  var component = thunk.type;
  var _component$initialSta = component.initialState;
  var initialState = _component$initialSta === undefined ? function () {
    return {};
  } : _component$initialSta;

  prepare(thunk, initialState(thunk.props));

  // If a component does not have a reducer, it does not
  // get any local state
  if (component.reducer) {
    component.shouldUpdate = component.shouldUpdate || shouldUpdate;
    dispatch((0, _reduxEphemeral.createEphemeral)(thunk.path, thunk.state));
  }
}

function update(getState, thunk, prev) {
  prepare(thunk, (0, _getProp2.default)(thunk.path, getState()));
}

function destroy(dispatch, thunk) {
  thunk.type.reducer && dispatch((0, _reduxEphemeral.destroyEphemeral)(thunk.path));
}

function shouldUpdate(prev, next) {
  return !(0, _arrayEqual2.default)(prev.children, next.children) || !(0, _objectEqual2.default)(prev.props, next.props) || prev.state !== next.state;
}

function ref(refs) {
  return function (name) {
    return function (local) {
      return refs[name] = local;
    };
  };
}

function prepare(thunk, state) {
  thunk.state = state;
  thunk.local = function (fn) {
    for (var _len = arguments.length, outerArgs = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      outerArgs[_key - 1] = arguments[_key];
    }

    return function () {
      for (var _len2 = arguments.length, innerArgs = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        innerArgs[_key2] = arguments[_key2];
      }

      return (0, _reduxEphemeral.toEphemeral)(thunk.path, thunk.type.reducer, fn.apply(thunk, outerArgs.concat(innerArgs)));
    };
  };

  var refs = {};

  thunk.ref = {
    as: ref(refs),
    to: function to(name, fn) {
      for (var _len3 = arguments.length, outerArgs = Array(_len3 > 2 ? _len3 - 2 : 0), _key3 = 2; _key3 < _len3; _key3++) {
        outerArgs[_key3 - 2] = arguments[_key3];
      }

      return function () {
        return refs[name].apply(refs, [fn].concat(outerArgs)).apply(undefined, arguments);
      };
    }
  };

  if (thunk.props && thunk.props.ref) {
    thunk.props.ref(thunk.local);
  }
}

/**
 * Exports
 */

exports.default = local;