'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
/**
 * Action types
 */

var types = {
  CREATE_ELEMENT: 'CREATE_ELEMENT',
  SET_ATTRIBUTE: 'SET_ATTRIBUTE',
  REMOVE_ATTRIBUTE: 'REMOVE_ATTRIBUTE',
  APPEND_CHILD: 'APPEND_CHILD',
  REPLACE_NODE: 'REPLACE_NODE',
  REMOVE_NODE: 'REMOVE_NODE',
  INSERT_BEFORE: 'INSERT_BEFORE',
  CREATE_THUNK: 'CREATE_THUNK',
  UPDATE_THUNK: 'UPDATE_THUNK',
  DESTROY_THUNK: 'DESTROY_THUNK'
};

/**
 * Action creators for effectful things
 */

function vnodeAction(type) {
  return function (vnode, prev) {
    return {
      type: type,
      vnode: vnode,
      prev: prev
    };
  };
}

var createElement = vnodeAction(types.CREATE_ELEMENT);
var createThunk = vnodeAction(types.CREATE_THUNK);
var updateThunk = vnodeAction(types.UPDATE_THUNK);
var destroyThunk = vnodeAction(types.DESTROY_THUNK);

function attrAction(type) {
  return function (node, name, value) {
    return {
      type: type,
      node: node,
      name: name,
      value: value
    };
  };
}

var setAttribute = attrAction(types.SET_ATTRIBUTE);
var removeAttribute = attrAction(types.REMOVE_ATTRIBUTE);

function nodeAction(type) {
  return function (node, newNode, oldNode) {
    return {
      type: type,
      node: node,
      newNode: newNode,
      oldNode: oldNode
    };
  };
}

var appendChild = nodeAction(types.APPEND_CHILD);
var replaceNode = nodeAction(types.REPLACE_NODE);
var removeNode = nodeAction(types.REMOVE_NODE);

function insertBefore(node, newNode, pos) {
  return {
    type: types.INSERT_BEFORE,
    node: node,
    newNode: newNode,
    pos: pos
  };
}

/**
 * Exports
 */

exports.createElement = createElement;
exports.setAttribute = setAttribute;
exports.removeAttribute = removeAttribute;
exports.appendChild = appendChild;
exports.replaceNode = replaceNode;
exports.removeNode = removeNode;
exports.insertBefore = insertBefore;
exports.createThunk = createThunk;
exports.updateThunk = updateThunk;
exports.destroyThunk = destroyThunk;
exports.types = types;