'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.map = undefined;

var _reduxFlo = require('redux-flo');

var _reduxFlo2 = _interopRequireDefault(_reduxFlo);

var _bindMiddleware = require('@f/bind-middleware');

var _bindMiddleware2 = _interopRequireDefault(_bindMiddleware);

var _isArray = require('@f/is-array');

var _isArray2 = _interopRequireDefault(_isArray);

var _toMiddleware = require('@f/to-middleware');

var _toMiddleware2 = _interopRequireDefault(_toMiddleware);

var _mapArray = require('@f/map-array');

var _mapArray2 = _interopRequireDefault(_mapArray);

var _logError = require('@f/log-error');

var _logError2 = _interopRequireDefault(_logError);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
                                                                                                                                                                                                     * Imports
                                                                                                                                                                                                     */

/**
 * yoco
 * @param  {Array} mw redux style middleware
 * @return {Function} dispatch function to middleware
 */

function yoco(mw) {
  if (!(0, _isArray2.default)(mw)) mw = [mw];
  var dispatch = (0, _bindMiddleware2.default)([(0, _reduxFlo2.default)(errorHandler)].concat(_toConsumableArray(mw)));
  dispatch.wrap = wrap;
  dispatch.onError = _logError2.default;
  return dispatch;

  function errorHandler(err) {
    return dispatch.onError(err);
  }

  function wrap(fn) {
    return function () {
      var args = new Array(arguments.length);
      for (var i = 0; i < arguments.length; ++i) {
        args[i] = arguments[i];
      }
      return dispatch(fn.apply(this, args));
    };
  }
}

/**
 * crate a co from functions
 * @param {Array} fns mapping functions
 * @returm {Function}
 */

function map(fns) {
  if (!(0, _isArray2.default)(fns)) fns = [fns];
  return yoco((0, _mapArray2.default)(_toMiddleware2.default, fns));
}

/**
 * Exports
 */

exports.default = yoco;
exports.map = map;