'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _element = require('vdux/element');

var _element2 = _interopRequireDefault(_element);

var _merge = require('../utils/merge');

var _merge2 = _interopRequireDefault(_merge);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getStyles() {
  return {
    header: {
      height: '64px',
      display: 'flex',
      alignItems: 'center',
      backgroundColor: 'white',
      boxShadow: '0 0 5px 2px rgba(0,0,0,0.2)',
      color: '#333'
    },
    title: {
      fontSize: '20px'
    },
    children: {
      flex: 1
    },
    inner: {
      width: '80%',
      margin: '0 auto',
      display: 'flex',
      alignItems: 'center',
      minWidth: '600px'
    }
  };
}

function render(_ref) {
  var props = _ref.props;
  var children = _ref.children;
  var title = props.title;
  var score = props.score;
  var style = props.style;
  var innerWidth = props.innerWidth;

  var styles = getStyles();

  return (0, _element2.default)(
    'div',
    { style: (0, _merge2.default)(style, styles.header) },
    (0, _element2.default)(
      'div',
      { style: (0, _merge2.default)({ width: innerWidth }, styles.inner) },
      (0, _element2.default)(
        'div',
        { style: styles.title },
        ' ',
        title && title,
        ' '
      ),
      (0, _element2.default)(
        'div',
        { style: styles.children },
        children && children.map(function (child) {
          return (0, _element2.default)(
            'div',
            null,
            child
          );
        })
      ),
      isNaN(score) ? null : (0, _element2.default)(
        'div',
        { style: styles.score },
        ' score: ',
        score,
        ' '
      )
    )
  );
}

var initialState = function initialState() {};
var reducer = function reducer(state) {
  return state;
};

exports.default = {
  initialState: initialState,
  render: render,
  reducer: reducer
};