'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _lodash = require('lodash');

var _lodash2 = _interopRequireDefault(_lodash);

var _actions = require('./actions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function reducer(state, action) {
  switch (action.type) {
    case _actions.INIT_PROCESS:
      var newLog = _lodash2.default.clone(state.log);
      newLog[action.payload.id] = { action: action.payload.argv, output: [] };
      return _extends({}, state, {
        log: newLog
      });
    case _actions.LOG_PROCESS:
      var newLog = _lodash2.default.clone(state.log);
      var processId = action.payload.id;
      var process = newLog[processId] || {};
      process.output.push(action.payload.output);
      return _extends({}, state, {
        log: newLog
      });
  }
  return state;
}

exports.default = reducer;