/**
 * Note: This code copied from: https://github.com/Raynos/dom-delegator/blob/master/proxy-event.js
 */

"use strict";

var inherits = require("inherits");

var ALL_PROPS = ["altKey", "bubbles", "cancelable", "ctrlKey", "eventPhase", "metaKey", "relatedTarget", "shiftKey", "target", "timeStamp", "type", "view", "which"];
var KEY_PROPS = ["char", "charCode", "key", "keyCode"];
var MOUSE_PROPS = ["button", "buttons", "clientX", "clientY", "layerX", "layerY", "offsetX", "offsetY", "pageX", "pageY", "screenX", "screenY", "toElement"];

var rkeyEvent = /^key|input/;
var rmouseEvent = /^(?:mouse|pointer|contextmenu)|click/;

module.exports = ProxyEvent;

function ProxyEvent(ev) {
    if (!(this instanceof ProxyEvent)) {
        return new ProxyEvent(ev);
    }

    if (rkeyEvent.test(ev.type)) {
        return new KeyEvent(ev);
    } else if (rmouseEvent.test(ev.type)) {
        return new MouseEvent(ev);
    }

    for (var i = 0; i < ALL_PROPS.length; i++) {
        var propKey = ALL_PROPS[i];
        this[propKey] = ev[propKey];
    }

    this._rawEvent = ev;
    this._bubbles = false;
}

ProxyEvent.prototype.preventDefault = function () {
    this._rawEvent.preventDefault();
};

ProxyEvent.prototype.startPropagation = function () {
    this._bubbles = true;
};

ProxyEvent.prototype.stopPropagation = function () {
    this._stopPropagation = true;
};

ProxyEvent.prototype.stopImmediatePropagation = function () {
    this._stopImmediatePropagation = true;
};

function MouseEvent(ev) {
    for (var i = 0; i < ALL_PROPS.length; i++) {
        var propKey = ALL_PROPS[i];
        this[propKey] = ev[propKey];
    }

    for (var j = 0; j < MOUSE_PROPS.length; j++) {
        var mousePropKey = MOUSE_PROPS[j];
        this[mousePropKey] = ev[mousePropKey];
    }

    this._rawEvent = ev;
}

inherits(MouseEvent, ProxyEvent);

function KeyEvent(ev) {
    for (var i = 0; i < ALL_PROPS.length; i++) {
        var propKey = ALL_PROPS[i];
        this[propKey] = ev[propKey];
    }

    for (var j = 0; j < KEY_PROPS.length; j++) {
        var keyPropKey = KEY_PROPS[j];
        this[keyPropKey] = ev[keyPropKey];
    }

    this._rawEvent = ev;
}

inherits(KeyEvent, ProxyEvent);