import apply from './_apply';
import arrayMap from './_arrayMap';
import baseFlatten from './_baseFlatten';
import baseIteratee from './_baseIteratee';
import rest from './rest';

/**
 * Creates a function like `_.over`.
 *
 * @private
 * @param {Function} arrayFunc The function to iterate over iteratees.
 * @returns {Function} Returns the new invoker function.
 */
function createOver(arrayFunc) {
  return rest(function(iteratees) {
    iteratees = arrayMap(baseFlatten(iteratees, 1), baseIteratee);
    return rest(function(args) {
      var thisArg = this;
      return arrayFunc(iteratees, function(iteratee) {
        return apply(iteratee, thisArg, args);
      });
    });
  });
}

export default createOver;
