'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _canSelectText = require('./canSelectText');

var _canSelectText2 = _interopRequireDefault(_canSelectText);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Set an element's value
 */

function setValue(node, value) {
  if (node.ownerDocument.activeElement === node && (0, _canSelectText2.default)(node)) {
    var start = node.selectionStart;
    var end = node.selectionEnd;
    node.value = value;
    node.setSelectionRange(start, end);
  } else {
    node.value = value;
  }
}

/**
 * Exports
 */

/**
 * Imports
 */

exports.default = setValue;