'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INIT_PROCESS = exports.LOG_PROCESS = exports.SUBMIT = exports.OUT = exports.out = exports.initProcess = exports.logProcess = exports.submit = undefined;

var _shellQuote = require('shell-quote');

var INIT_PROCESS = 'INIT_PROCESS';
var LOG_PROCESS = 'LOG_PROCESS';
var SUBMIT = 'SUBMIT';
var OUT = 'OUT';

function submit() {
  return function (e) {
    var value = e.target.value;
    var split = (0, _shellQuote.parse)(value).map(function (item) {
      return isNaN(item) ? item : parseFloat(item);
    });
    return {
      type: SUBMIT,
      payload: split
    };
  };
}

function logProcess(id, output) {
  return {
    type: LOG_PROCESS,
    payload: {
      id: id,
      output: output
    }
  };
}

function initProcess(id, argv) {
  return {
    type: INIT_PROCESS,
    payload: {
      id: id,
      argv: argv
    }
  };
}

function out(msg) {
  return {
    type: OUT,
    payload: msg
  };
}

exports.submit = submit;
exports.logProcess = logProcess;
exports.initProcess = initProcess;
exports.out = out;
exports.OUT = OUT;
exports.SUBMIT = SUBMIT;
exports.LOG_PROCESS = LOG_PROCESS;
exports.INIT_PROCESS = INIT_PROCESS;