'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _merge = require('./utils/merge');

var _merge2 = _interopRequireDefault(_merge);

var _element = require('vdux/element');

var _element2 = _interopRequireDefault(_element);

var _header = require('./components/header');

var _header2 = _interopRequireDefault(_header);

var _feedUpdate = require('./components/feedUpdate');

var _feedUpdate2 = _interopRequireDefault(_feedUpdate);

var _log = require('./components/log');

var _log2 = _interopRequireDefault(_log);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var styles = {
  app: {
    fontFamily: 'Roboto, sans-serif',
    backgroundColor: '#f5f5f5',
    minHeight: '100vh',
    height: '100%'
  },
  feed: {
    margin: '20px auto',
    width: '40%',
    minWidth: '600px'
  }
};

function render(_ref) {
  var props = _ref.props;
  var welcome = props.welcome;
  var user = props.user;
  var view = props.view;
  var log = props.log;
  var headerColor = user.headerColor;
  var headerTextColor = user.headerTextColor;


  return (0, _element2.default)(
    'div',
    { style: styles.app },
    (0, _element2.default)(
      _header2.default,
      {
        title: user.title || 'Cycle',
        innerWidth: '40%',
        style: (0, _merge2.default)({
          backgroundColor: headerColor,
          color: headerTextColor
        }, styles.header) },
      (0, _element2.default)(_feedUpdate2.default, null)
    ),
    (0, _element2.default)(_log2.default, { log: log, view: view, welcome: welcome })
  );
}

exports.default = {
  render: render
};