'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _element = require('vdux/element');

var _element2 = _interopRequireDefault(_element);

var _createAction = require('@f/create-action');

var _createAction2 = _interopRequireDefault(_createAction);

var _actions = require('../actions');

var _merge = require('../utils/merge');

var _merge2 = _interopRequireDefault(_merge);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var SET_TEXT = 'SET_TEXT';
var SET_FOCUS = 'SET_FOCUS';
var REMOVE_FOCUS = 'REMOVE_FOCUS';
var CLEAR_TEXT = 'CLEAR_TEXT';
var setText = (0, _createAction2.default)(SET_TEXT, function (e) {
  return e.target.value;
});
var setFocus = (0, _createAction2.default)(SET_FOCUS);
var clearText = (0, _createAction2.default)(CLEAR_TEXT);
var removeFocus = (0, _createAction2.default)(REMOVE_FOCUS);

var getStyles = function getStyles() {
  return {
    container: {
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center',
      padding: '15px'
    },
    input: {
      padding: '10px',
      width: '80%',
      fontSize: '16px',
      borderRadius: '10px',
      border: '1px solid rgba(51,51,51,0.2)',
      textIndent: '25px',
      transition: 'border .3s ease-in-out',
      outline: 'none'
    },
    caret: {
      transition: 'color .3s ease-in-out',
      position: 'relative',
      color: 'rgba(51,51,51,0.2)',
      left: '25px'
    },
    focusedInput: {
      border: '1px solid rgba(51,51,51,0.7)'
    },
    focusedCaret: {
      color: 'rgba(51,51,51,0.7)'
    }
  };
};

function initialState() {
  return {
    text: '',
    focus: true
  };
}

function render(_ref) {
  var props = _ref.props;
  var state = _ref.state;
  var local = _ref.local;
  var text = state.text;
  var focus = state.focus;

  var styles = getStyles();
  var submitText = [(0, _actions.submit)(text), local(clearText)];

  return (0, _element2.default)(
    'div',
    { style: styles.container },
    (0, _element2.default)(
      'div',
      { style: focus ? (0, _merge2.default)(styles.focusedCaret, styles.caret) : styles.caret },
      ' > '
    ),
    (0, _element2.default)('input', {
      autofocus: true,
      style: focus ? (0, _merge2.default)(styles.focusedInput, styles.input) : styles.input,
      type: 'text',
      value: text,
      onFocus: local(setFocus),
      onBlur: local(removeFocus),
      onInput: local(setText),
      onKeyUp: { enter: text && submitText } })
  );
}

function reducer(state, action) {
  switch (action.type) {
    case SET_TEXT:
      return _extends({}, state, {
        text: action.payload
      });
    case SET_FOCUS:
      return _extends({}, state, {
        focus: true
      });
    case REMOVE_FOCUS:
      return _extends({}, state, {
        focus: false
      });
    case CLEAR_TEXT:
      return _extends({}, state, {
        text: ''
      });
  }
  return state;
}

exports.default = {
  initialState: initialState,
  render: render,
  reducer: reducer
};