'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _element = require('vdux/element');

var _element2 = _interopRequireDefault(_element);

var _card = require('./card');

var _card2 = _interopRequireDefault(_card);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var styles = {
  feed: {
    margin: '20px auto',
    width: '40%',
    minWidth: '600px'
  }
};

function render(_ref) {
  var props = _ref.props;
  var log = props.log;
  var view = props.view;
  var welcome = props.welcome;

  var fixedLog = Object.keys(log).reverse();
  return (0, _element2.default)(
    'div',
    null,
    (0, _element2.default)(
      'div',
      { style: styles.feed },
      fixedLog.map(function (key, i) {
        var process = log[key];
        if (process) {
          return (0, _element2.default)(_card2.default, {
            key: 'item' + i,
            action: process.action,
            item: process.output.map(view),
            color: process.color });
        }
      }),
      welcome && (0, _element2.default)(_card2.default, {
        key: 0,
        item: view(welcome) })
    )
  );
}

exports.default = render;