define(function(require, exports, module) {
FirminCSSMatrix=function(c){this.m11=this.m22=this.m33=this.m44=1;this.m12=this.m13=this.m14=this.m21=this.m23=this.m24=this.m31=this.m32=this.m34=this.m41=this.m42=this.m43=0;if(typeof c=="string"){this.setMatrixValue(c)}};FirminCSSMatrix.displayName="FirminCSSMatrix";FirminCSSMatrix.degreesToRadians=function(c){return c*Math.PI/180};FirminCSSMatrix.determinant2x2=function(c,b,a,d){return c*d-b*a};FirminCSSMatrix.determinant3x3=function(c,b,a,d,e,j,f,g,h){var i=FirminCSSMatrix.determinant2x2;return c*i(e,j,g,h)-d*i(b,a,g,h)+f*i(b,a,e,j)};FirminCSSMatrix.determinant4x4=function(c){var b=FirminCSSMatrix.determinant3x3,a=c.m11,d=c.m21,e=c.m31,j=c.m41,f=c.m12,g=c.m22,h=c.m32,i=c.m42,k=c.m13,l=c.m23,m=c.m33,n=c.m43,o=c.m14,p=c.m24,q=c.m34,r=c.m44;return a*b(g,l,p,h,m,q,i,n,r)-d*b(f,k,o,h,m,q,i,n,r)+e*b(f,k,o,g,l,p,i,n,r)-j*b(f,k,o,g,l,p,h,m,q)};[["m11","a"],["m12","b"],["m21","c"],["m22","d"],["m41","e"],["m42","f"]].forEach(function(b){var a=b[0],d=b[1];Object.defineProperty(FirminCSSMatrix.prototype,d,{set:function(c){this[a]=c},get:function(){return this[a]}})});FirminCSSMatrix.prototype.isAffine=function(){return this.m13===0&&this.m14===0&&this.m23===0&&this.m24===0&&this.m31===0&&this.m32===0&&this.m33===1&&this.m34===0&&this.m43===0&&this.m44===1};FirminCSSMatrix.prototype.multiply=function(c){var b=this,a=c,d=new FirminCSSMatrix();d.m11=b.m11*a.m11+b.m12*a.m21+b.m13*a.m31+b.m14*a.m41;d.m12=b.m11*a.m12+b.m12*a.m22+b.m13*a.m32+b.m14*a.m42;d.m13=b.m11*a.m13+b.m12*a.m23+b.m13*a.m33+b.m14*a.m43;d.m14=b.m11*a.m14+b.m12*a.m24+b.m13*a.m34+b.m14*a.m44;d.m21=b.m21*a.m11+b.m22*a.m21+b.m23*a.m31+b.m24*a.m41;d.m22=b.m21*a.m12+b.m22*a.m22+b.m23*a.m32+b.m24*a.m42;d.m23=b.m21*a.m13+b.m22*a.m23+b.m23*a.m33+b.m24*a.m43;d.m24=b.m21*a.m14+b.m22*a.m24+b.m23*a.m34+b.m24*a.m44;d.m31=b.m31*a.m11+b.m32*a.m21+b.m33*a.m31+b.m34*a.m41;d.m32=b.m31*a.m12+b.m32*a.m22+b.m33*a.m32+b.m34*a.m42;d.m33=b.m31*a.m13+b.m32*a.m23+b.m33*a.m33+b.m34*a.m43;d.m34=b.m31*a.m14+b.m32*a.m24+b.m33*a.m34+b.m34*a.m44;d.m41=b.m41*a.m11+b.m42*a.m21+b.m43*a.m31+b.m44*a.m41;d.m42=b.m41*a.m12+b.m42*a.m22+b.m43*a.m32+b.m44*a.m42;d.m43=b.m41*a.m13+b.m42*a.m23+b.m43*a.m33+b.m44*a.m43;d.m44=b.m41*a.m14+b.m42*a.m24+b.m43*a.m34+b.m44*a.m44;return d};FirminCSSMatrix.prototype.isIdentityOrTranslation=function(){var c=this;return c.m11===1&&c.m12===0&&c.m13===0&&c.m14===0&&c.m21===0&&c.m22===1&&c.m23===0&&c.m24===0&&c.m31===0&&c.m31===0&&c.m33===1&&c.m34===0&&c.m44===1};FirminCSSMatrix.prototype.adjoint=function(){var c=new FirminCSSMatrix(),b=this,a=FirminCSSMatrix.determinant3x3,d=b.m11,e=b.m12,j=b.m13,f=b.m14,g=b.m21,h=b.m22,i=b.m23,k=b.m24,l=b.m31,m=b.m32,n=b.m33,o=b.m34,p=b.m41,q=b.m42,r=b.m43,s=b.m44;c.m11=a(h,m,q,i,n,r,k,o,s);c.m21=-a(g,l,p,i,n,r,k,o,s);c.m31=a(g,l,p,h,m,q,k,o,s);c.m41=-a(g,l,p,h,m,q,i,n,r);c.m12=-a(e,m,q,j,n,r,f,o,s);c.m22=a(d,l,p,j,n,r,f,o,s);c.m32=-a(d,l,p,e,m,q,f,o,s);c.m42=a(d,l,p,e,m,q,j,n,r);c.m13=a(e,h,q,j,i,r,f,k,s);c.m23=-a(d,g,p,j,i,r,f,k,s);c.m33=a(d,g,p,e,h,q,f,k,s);c.m43=-a(d,g,p,e,h,q,j,i,r);c.m14=-a(e,h,m,j,i,n,f,k,o);c.m24=a(d,g,l,j,i,n,f,k,o);c.m34=-a(d,g,l,e,h,m,f,k,o);c.m44=a(d,g,l,e,h,m,j,i,n);return c};FirminCSSMatrix.prototype.inverse=function(){var c,b,a,d,e;if(this.isIdentityOrTranslation()){c=new FirminCSSMatrix();if(!(this.m41===0&&this.m42===0&&this.m43===0)){c.m41=-this.m41;c.m42=-this.m42;c.m43=-this.m43}return c}a=this.adjoint();b=FirminCSSMatrix.determinant4x4(this);if(Math.abs(b)<1e-8)return null;for(d=1;d<5;d++){for(e=1;e<5;e++){a[("m"+d)+e]/=b}}return a};FirminCSSMatrix.prototype.rotate=function(c,b,a){var d=FirminCSSMatrix.degreesToRadians;if(typeof c!="number"||isNaN(c))c=0;if((typeof b!="number"||isNaN(b))&&(typeof a!="number"||isNaN(a))){a=c;c=0;b=0}if(typeof b!="number"||isNaN(b))b=0;if(typeof a!="number"||isNaN(a))a=0;c=d(c);b=d(b);a=d(a);var e=new FirminCSSMatrix(),j=new FirminCSSMatrix(),f=new FirminCSSMatrix(),g,h,i;a/=2;g=Math.sin(a);h=Math.cos(a);i=g*g;f.m11=f.m22=1-2*i;f.m12=f.m21=2*g*h;f.m21*=-1;b/=2;g=Math.sin(b);h=Math.cos(b);i=g*g;j.m11=j.m33=1-2*i;j.m13=j.m31=2*g*h;j.m13*=-1;c/=2;g=Math.sin(c);h=Math.cos(c);i=g*g;e.m22=e.m33=1-2*i;e.m23=e.m32=2*g*h;e.m32*=-1;return f.multiply(j).multiply(e).multiply(this)};FirminCSSMatrix.prototype.rotateAxisAngle=function(c,b,a,d){if(typeof c!="number"||isNaN(c))c=0;if(typeof b!="number"||isNaN(b))b=0;if(typeof a!="number"||isNaN(a))a=0;if(typeof d!="number"||isNaN(d))d=0;if(c===0&&b===0&&a===0)a=1;var e=new FirminCSSMatrix(),j=Math.sqrt(c*c+b*b+a*a),f,g,h,i,k,l,m;d=(FirminCSSMatrix.degreesToRadians(d)||0)/2;f=Math.cos(d);g=Math.sin(d);h=g*g;if(j===0){c=0;b=0;a=1}else if(j!==1){c/=j;b/=j;a/=j}if(c===1&&b===0&&a===0){e.m22=e.m33=1-2*h;e.m23=e.m32=2*f*g;e.m32*=-1}else if(c===0&&b===1&&a===0){e.m11=e.m33=1-2*h;e.m13=e.m31=2*f*g;e.m13*=-1}else if(c===0&&b===0&&a===1){e.m11=e.m22=1-2*h;e.m12=e.m21=2*f*g;e.m21*=-1}else{i=g*f;k=c*c;l=b*b;m=a*a;e.m11=1-2*(l+m)*h;e.m12=2*(c*b*h+a*i);e.m13=2*(c*a*h-b*i);e.m21=2*(b*c*h-a*i);e.m22=1-2*(m+k)*h;e.m23=2*(b*a*h+c*i);e.m31=2*(a*c*h+b*i);e.m32=2*(a*b*h-c*i);e.m33=1-2*(k+l)*h}return this.multiply(e)};FirminCSSMatrix.prototype.scale=function(c,b,a){var d=new FirminCSSMatrix();if(typeof c!="number"||isNaN(c))c=1;if(typeof b!="number"||isNaN(b))b=c;if(typeof a!="number"||isNaN(a))a=1;d.m11=c;d.m22=b;d.m33=a;return this.multiply(d)};FirminCSSMatrix.prototype.translate=function(c,b,a){var d=new FirminCSSMatrix();if(typeof c!="number"||isNaN(c))c=0;if(typeof b!="number"||isNaN(b))b=0;if(typeof a!="number"||isNaN(a))a=0;d.m41=c;d.m42=b;d.m43=a;return this.multiply(d)};FirminCSSMatrix.prototype.setMatrixValue=function(c){c=c.trim();var b=c.match(/^matrix(3d)?\(\s*(.+)\s*\)$/),a,d,e,j,f,g;if(!b)return;a=!!b[1];d=b[2].split(/\s*,\s*/);e=d.length;j=new Array(e);if((a&&e!==16)||!(a||e===6))return;for(f=0;f<e;f++){g=d[f];if(g.match(/^-?\d+(\.\d+)?$/)){j[f]=parseFloat(g)}else return}for(f=0;f<e;f++){point=a?("m"+(Math.floor(f/4)+1))+(f%4+1):String.fromCharCode(f+97);this[point]=j[f]}};FirminCSSMatrix.prototype.toString=function(){var b=this,a,d;if(this.isAffine()){d="matrix(";a=["a","b","c","d","e","f"]}else{d="matrix3d(";a=["m11","m12","m13","m14","m21","m22","m23","m24","m31","m32","m33","m34","m41","m42","m43","m44"]}return d+a.map(function(c){return b[c].toFixed(6)}).join(", ")+")"};
Firmin=(typeof Firmin=='undefined')?{}:Firmin;Firmin.CSSMatrix=(typeof WebKitCSSMatrix=='object')?WebKitCSSMatrix:FirminCSSMatrix;Firmin.prefix=(function(){var a=document.createElement("div"),b=["webkit","Moz","O"],c=3,d;while(c--){d=b[c];a.style.cssText="-"+d.toLowerCase()+"-transition-property:opacity;";if(typeof a.style[d+"TransitionProperty"]!="undefined")return d}return d})();Firmin.matrixToString=function(d){if(Firmin.prefix!="Moz")return d.toString();var e="matrix(",f=["a","b","c","d","e","f"];return e+f.map(function(a,b){var c=d[a].toFixed(6);if(b>3)c+="px";return c}).join(", ")+")"};Firmin.angleToRadians=function(a,b){var c;switch(a){case"rad":return b;case"deg":c=Math.PI/180;break;case"grad":c=Math.PI/200;break;case"turn":c=Math.PI*2;break}return c*b};Firmin.pointToVector=function(a){if(!a)return null;return a instanceof Array?a:[a.x,a.y,a.z]};Firmin.NUMBER_PATTERN=/^-?\d+(\.\d+)?/;Firmin.parseNumeric=function(e,f){return function(b){var c,d;if(typeof b=="number"){return[f,b]}else if(typeof b!="string"){return null}d=(b.match(Firmin.NUMBER_PATTERN)||[""])[0];if(d.length===b.length){c=f}else{c=e.filter(function(a){return b.substr(d.length)===a})[0]}return c&&d?[c,parseFloat(d)]:null}};Firmin.parseAngle=Firmin.parseNumeric(["deg","grad","rad","turn"],"deg");Firmin.parseTime=Firmin.parseNumeric(["s","ms"],"s");Firmin.Transform=function(a,b){this.ctm=a||new Firmin.CSSMatrix();this.centre=Firmin.pointToVector(b)||["50%","50%",0]};Firmin.Transform.methods=["translate","translate3d","translateX","translateY","translateZ","scale","scale3d","scaleX","scaleY","scaleZ","rotate","rotate3d","rotateX","rotateY","rotateZ","skew","skewX","skewY","matrix","matrix3d"];Firmin.Transform.parse=function(a,b){var c=Firmin.Transform.methods,d={},e=null,f,g;if(typeof b==="object"&&b.transform){f=b.transform.ctm;g=b.transform.centre;e=new Firmin.Transform(f,g)}for(property in a){if(c.indexOf(property)!==-1){e=e||new Firmin.Transform();e[property](a[property])}else if(property==="origin"){e=e||new Firmin.Transform();e[property](a[property])}else{d[property]=a[property]}}return{result:e,remainder:d}};Firmin.Transform.prototype.build=function(a){var b=this.centre;if(Firmin.prefix=="O"){b=b.slice(0,2)}a=a||{};a[Firmin.prefix+"Transform"]=Firmin.matrixToString(this.ctm);a[Firmin.prefix+"TransformOrigin"]=b.join(" ");return a};Firmin.Transform.prototype.matrix=Firmin.Transform.prototype.matrix3d=function(a){var b=new Firmin.CSSMatrix();if(a.length===6){b.a=a[0];b.b=a[1];b.c=a[2];b.d=a[3];b.e=a[4];b.f=a[5]}else{b.m11=a[0];b.m12=a[1];b.m13=a[2];b.m14=a[3];b.m21=a[4];b.m22=a[5];b.m23=a[6];b.m24=a[7];b.m31=a[8];b.m32=a[9];b.m33=a[10];b.m34=a[11];b.m41=a[12];b.m42=a[13];b.m43=a[14];b.m44=a[15]}this.ctm=this.ctm.multiply(b)};Firmin.Transform.prototype.translate=Firmin.Transform.prototype.translate3d=function(a){var b,c,d,e;if(typeof a=="number"||typeof a=="string"){c=d=parseInt(a,10)||0;e=0}else{b=Firmin.pointToVector(a);c=b[0];d=b[1];e=b[2];if(typeof c!="number")c=parseInt(c,10)||0;if(typeof d!="number")d=parseInt(d,10)||0;if(typeof e!="number")e=parseInt(e,10)||0}this.ctm=this.ctm.translate(c,d,e)};Firmin.Transform.prototype.translateX=function(a){this.translate([a,0])};Firmin.Transform.prototype.translateY=function(a){this.translate([0,a])};Firmin.Transform.prototype.translateZ=function(a){this.translate3d([0,0,a])};Firmin.Transform.prototype.scale=Firmin.Transform.prototype.scale3d=function(a){var b,c,d,e;if(typeof a=="number"){c=d=a;e=1}else{b=Firmin.pointToVector(a);c=b[0];d=b[1];e=b[2]}this.ctm=this.ctm.scale(c,d,e)};Firmin.Transform.prototype.scaleX=function(a){this.scale3d([a,1,1])};Firmin.Transform.prototype.scaleY=function(a){this.scale3d([1,a,1])};Firmin.Transform.prototype.scaleZ=function(a){this.scale3d([1,1,a])};Firmin.Transform.prototype.skew=function(a){var b=Firmin.parseAngle,c=Firmin.angleToRadians,d,e;if(typeof a=="number"||typeof a=="string"){d=e=c.apply(null,b(a))||0}else{a=Firmin.pointToVector(a);d=c.apply(null,b(a[0]))||0;e=c.apply(null,b(a[1]))||0}this.matrix([1,Math.tan(e),Math.tan(d),1,0,0])};Firmin.Transform.prototype.skewX=function(a){this.skew([a,0])};Firmin.Transform.prototype.skewY=function(a){this.skew([0,a])};Firmin.Transform.prototype.rotate=function(a){a=Firmin.angleToRadians.apply(null,Firmin.parseAngle(a))*(180/Math.PI);this.ctm=this.ctm.rotate(0,0,a)};Firmin.Transform.prototype.rotate3d=function(a){var b=a.x,c=a.y,d=a.z,e=a.angle;if(typeof b!="number")b=0;if(typeof c!="number")c=0;if(typeof d!="number")d=0;e=Firmin.angleToRadians.apply(null,Firmin.parseAngle(e))*(180/Math.PI);this.ctm=this.ctm.rotateAxisAngle(b,c,d,e)};Firmin.Transform.prototype.rotateX=function(a){this.rotate3d({x:1,angle:a})};Firmin.Transform.prototype.rotateY=function(a){this.rotate3d({y:1,angle:a})};Firmin.Transform.prototype.rotateZ=function(a){this.rotate3d({z:1,angle:a})};Firmin.Transform.prototype.origin=function(a){var b=Firmin.pointToVector(a),c,d,e;if((v0=b[0]))this.centre[0]=v0;if((c=b[1]))this.centre[1]=c;if((d=b[2]))this.centre[2]=d};Firmin.Transition=function(){this.properties=["all"];this.duration=["ms",0];this.delay=["ms",0];this.timingFunction="ease"};Firmin.Transition.methods=["properties","timingFunction","duration","delay"];Firmin.Transition.parse=function(a,b){var c=Firmin.Transition.methods,d={},e=new Firmin.Transition(),f,g;for(p in a){if(c.indexOf(p)!==-1){if(p==="properties"&&typeof p=="string"){e[p]=[a[p]]}else if(p==="timingFunction"&&typeof a[p]!="string"){e[p]="cubic-bezier("+a[p].join(",")+")"}else if(p==="duration"){f=Firmin.parseTime(a[p]);if(f){e[p]=f}}else if(p==="delay"){g=Firmin.parseTime(a[p]);if(g){e[p]=g}}else{e[p]=a[p]}}else{d[p]=a[p]}}return{result:e,remainder:d}};Firmin.Transition.prototype.hasDuration=function(){return this.duration[1]!==0};Firmin.Transition.prototype.getDuration=function(){var a=this.duration;return a[0]==="s"?a[1]*1000:a[1]};Firmin.Transition.prototype.hasDelay=function(){return this.delay[1]!==0};Firmin.Transition.prototype.getDelay=function(){var a=this.delay;return a[0]==="s"?a[1]*1000:a[1]};Firmin.Transition.prototype.build=function(a){a=a||{};if(typeof this.properties=="string"){a[Firmin.prefix+"TransitionProperty"]=this.properties}else{a[Firmin.prefix+"TransitionProperty"]=this.properties.join(", ")}a[Firmin.prefix+"TransitionDuration"]=this.duration[1]+this.duration[0];a[Firmin.prefix+"TransitionDelay"]=this.delay[1]+this.delay[0];if(this.timingFunction){a[Firmin.prefix+"TransitionTimingFunction"]=this.timingFunction}return a};Firmin.Animation=function(a,b){var c,d;if(typeof a.callback=="function"){this.callback=a.callback}delete a.callback;c=Firmin.Transition.parse(a,b);this.transition=c.result;d=Firmin.Transform.parse(c.remainder,b);this.transform=d.result;this.style=d.remainder};Firmin.Animation.prototype.hasDuration=function(){return this.transition&&this.transition.hasDuration()};Firmin.Animation.prototype.getTotalDuration=function(){return this.transition?this.transition.getDuration()+this.transition.getDelay():0};Firmin.Animation.prototype.exec=function(a){var b=this.style,c;if(this.transition)b=this.transition.build(b);if(this.transform)b=this.transform.build(b);for(c in b){a.style[c]=b[c]}};Firmin.Animated=function(a){var b=this;this.element=a;this.operations=[];this.callback=null};Firmin.Animated.prototype.run=function(){var a=this.operations.shift(),b=this;if(!a){this.fired=true;return this}setTimeout(function(){a.exec(b.element)},10);setTimeout(function(){b.fireCallback();b.run()},a.getTotalDuration()||10);this.callback=a.callback;return this};Firmin.Animated.prototype.fireCallback=function(){var a=this.callback;if(typeof a==="function"){a.call(null,this.element)}};Firmin.Animated.prototype.__animate__=function(a){this.operations.push(a);this.__lastAnim=a;if(this.fired){this.fired=false;this.run()}return this};Firmin.Animated.prototype.animate=function(a,b,c){a.duration=b;a.callback=c;return this.__animate__(new Firmin.Animation(a))};Firmin.Animated.prototype.animateR=function(a,b,c){a.duration=b;a.callback=c;return this.__animate__(new Firmin.Animation(a,this.__lastAnim))};Firmin.animate=function(a,b,c,d){var e=new Firmin.Animated(a);e.animate(b,c,d);return e.run()};Firmin.animateR=function(a,b,c,d){var e=new Firmin.Animated(a),f=new Firmin.Animation({}),g=new Firmin.Transform(),h=new Firmin.CSSMatrix(),i=a.style[Firmin.prefix+"Transform"];h.setMatrixValue(i);g.ctm=h;f.transform=g;e.__lastAnim=f;e.animateR(b,c,d);return e.run()};Firmin.Transform.methods.forEach(function(f){var g=f+"R";Firmin[f]=function(a,b,c,d){var e={};e[f]=b;return Firmin.animate(a,e,c,d)};Firmin[g]=function(a,b,c,d){var e={};e[f]=b;return Firmin.animateR(a,e,c,d)};Firmin.Animated.prototype[f]=function(a,b,c){var d={};d[f]=a;return this.animate(d,b,c)};Firmin.Animated.prototype[g]=function(a,b,c){var d={};d[f]=a;return this.animateR(d,b,c)}});
});