{"ts":1349262061207,"silentsave":true,"restoring":false,"patch":[[{"diffs":[[1,"/**\n * Revisions Server module for Cloud9 IDE\n *\n * @author Sergi Mansilla <sergi@c9.io>\n * @copyright 2012, Ajax.org B.V.\n */\n\nrequire(\"amd-loader\");\nvar Plugin = require(\"../cloud9.core/plugin\");\nvar Diff_Match_Patch = require(\"./diff_match_patch\");\nvar Path = require(\"path\");\nvar PathUtils = require(\"./path_utils.js\");\nvar Async = require(\"async\");\nvar fsnode = require(\"vfs-nodefs-adapter\");\n\n/**\n *  FILE_SUFFIX = \"c9save\"\n *\n *  Suffix (extension) for revision files.\n **/\nvar FILE_SUFFIX = \"c9save\";\n\n/**\n * REV_FOLDER_NAME = \".c9revisions\"\n *\n * Folder to save revisions into\n */\nvar REV_FOLDER_NAME = \".c9revisions\";\n\nvar Diff = new Diff_Match_Patch();\nvar name = \"revisions\";\n\nmodule.exports = function setup(options, imports, register) {\n    var fs;\n    \n    imports.sandbox.getProjectDir(function(err, projectDir) {\n        if (err) return register(err);\n\n        fs = fsnode(imports.vfs, projectDir);\n        imports.ide.register(name, RevisionsPlugin, register);\n    });\n\n    function RevisionsPlugin(ide, workspace) {\n        Plugin.call(this, ide, workspace);\n        var self = this;\n        this.hooks = [\"command\"];\n        this.name = name;\n    \n        // This queue makes sure that changes are saved asynchronously but orderly\n        this.savingQueue = Async.queue(function(data, callback) {\n            self.saveSingleRevision(data.path, data.revision, function(err, revisionInfo) {\n                callback(err, revisionInfo);\n            });\n        }, 1);\n    }\n    \n    require(\"util\").inherits(RevisionsPlugin, Plugin);\n    \n    (function() {\n        this.command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\") {\n                return false;\n            }\n    \n            var self = this;\n            if (message.subCommand) {\n                var _error = function(msg) {\n                    self.broadcastError(message.subCommand, msg, user);\n                };\n    \n                switch (message.subCommand) {\n                    // Directly save a revision. The revision has been precomputed\n                    // on the client as is merely passed to the server in order to\n                    // save it.\n                    case \"saveRevision\":\n                        if (!message.path) {\n                            return _error(\"No path sent for the file to save\");\n                        }\n    \n                        this.savingQueue.push({\n                            path: message.path,\n                            revision: message.revision\n                        }, function(err, revisionInfo) {\n                            if (err) {\n                                return _error(err.toString());\n                            }\n    \n                            self.broadcastConfirmSave(message.path, revisionInfo.revision);\n                            if (message.forceRevisionListResponse === true) {\n                                self.getAllRevisions(revisionInfo.absPath, function(_err, revObj) {\n                                    if (_err) {\n                                        return _error(\"Error retrieving revisions for file \" + revisionInfo.absPath);\n                                    }\n    \n                                    self.broadcastRevisions.call(self, revObj, user, {\n                                        path: message.path\n                                    });\n                                });\n                            }\n                        });\n                        break;\n    \n                    // The client requests the history of revisions for a particular\n                    // document (indicated by `path`). The client might also want the\n                    // original contents of that file (the ones where diffs are applied\n                    // in order to get the current file).\n                    case \"getRevisionHistory\":\n                        if (!message.path) {\n                            return _error(\"No path sent for the file\");\n                        }\n    \n                        this.getRevisions(message.path, function(err, revObj) {\n                            if (err) {\n                                return _error(\"There was a problem retrieving the revisions\" +\n                                    \" for the file \" + message.path + \":\\n\" + err);\n                            }\n    \n                            self.broadcastRevisions.call(self, revObj, user, {\n                                id: message.id || null,\n                                nextAction: message.nextAction,\n                                path: message.path\n                            });\n                        });\n                        break;\n    \n                    case \"getRealFileContents\":\n                        fs.readFile(message.path, \"utf8\", function (err, data) {\n                            if (err) {\n                                return _error(\"There was a problem reading the contents for the file \" +\n                                        message.path + \":\\n\" + err);\n    \n                              }\n    \n                              user.broadcast(JSON.stringify({\n                                  type: \"revision\",\n                                  subtype: \"getRealFileContents\",\n                                  path: message.path,\n                                  nextAction: message.nextAction,\n                                  contents: data\n                              }));\n                        });\n                        break;\n    \n                    case \"closeFile\":\n                        if (!message.path) {\n                            _error(\"No path sent for the file to be closed\");\n                        }\n                        break;\n    \n                    case \"removeRevision\":\n                        if (!message.path) {\n                            return _error(\"No path sent for the file to be removed\");\n                        }\n    \n                        var path = this.getRevisionsPath(message.path);\n                        if (message.isFolder === true) {\n                            fs.rmdir(path, { recursive: true }, function() {});\n                        }\n                        else {\n                            fs.unlink(path + \".\" + FILE_SUFFIX);\n                        }\n                        break;\n    \n                    case \"moveRevision\":\n                        if (!message.path || !message.newPath) {\n                            return _error(\"Not enough paths sent for the file to be moved\");\n                        }\n    \n                        var fromPath = this.getRevisionsPath(message.path);\n                        var toPath = this.getRevisionsPath(message.newPath);\n                        if (message.isFolder !== true) {\n                            fromPath += \".\" + FILE_SUFFIX;\n                            toPath += \".\" + FILE_SUFFIX;\n                        }\n    \n                        fs.exists(fromPath, function(fromPathExists) {\n                            if (!fromPathExists) {\n                                return;\n                            }\n                            fs.exists(Path.dirname(toPath), function(toPathExists) {\n                                var renameFn = function() {\n                                    fs.rename(fromPath, toPath, function(err) {\n                                        if (err) {\n                                            _error(\"There was an error moving \" + fromPath + \" to \" + toPath);\n                                        }\n                                    });\n                                };\n    \n                                if (toPathExists) {\n                                    renameFn();\n                                }\n                                else {\n                                    fs.mkdirP(Path.dirname(toPath), function(err) {\n                                        if (!err) {\n                                            renameFn();\n                                        }\n                                    });\n                                }\n                            });\n                        });\n                        break;\n                }\n            }\n            return true;\n        };\n    \n        /**\n         * RevisionsPlugin#createEmptyStack(path) -> Object\n         * - path (String): relative path of the file to create revisions for\n         *\n         * Creates an empty revisions object. This function is usually called when\n         * a backup file is not found for the file in the `path`.\n         **/\n        this.createEmptyStack = function() {\n            return { \"revisions\": {} };\n        };\n    \n        this.getAllRevisions = function(absPath, callback) {\n            var revObj = {};\n            fs.readFile(absPath, \"utf8\", function(err, data) {\n                if (err) {\n                    return callback(err);\n                }\n    \n                var error;\n                var lineCount = 0;\n                var lines = data.toString().split(\"\\n\");\n                if (lines.length) {\n                    Async.whilst(\n                        function () {\n                            return lineCount < lines.length && !error;\n                        },\n                        function (next) {\n                            var line = lines[lineCount];\n                            if (line) {\n                                try {\n                                    var revision = JSON.parse(line);\n                                    revObj[revision.ts] = revision;\n                                }\n                                catch(e) {\n                                    error = e;\n                                }\n                            }\n                            lineCount++;\n                            next();\n                        },\n                        function (e) {\n                            callback(error, revObj);\n                        }\n                    );\n                }\n            });\n        };\n    \n        /**\n         * RevisionsPlugin#getRevisionsPath(filePath)\n         * - filePath (String): relative path of the actual file\n         *\n         * Creates the path to a relevant revisions file for a given file\n         **/\n        this.getRevisionsPath = function(filePath) {\n            return Path.join(REV_FOLDER_NAME, filePath);\n        };\n    \n        /**\n         * RevisionsPlugin#getRevisions(filePath, callback)\n         * - filePath (String): relative path of the file to get revisions for\n         * - callback (Function): callback to be called with the revisions object,\n         * or error\n         *\n         * Retrieves the revisions object for a particular file. If it doesn't exist,\n         * it will create one and return that. If there is any problem, it will call\n         * the `callback` function with the error as the first argument.\n         **/\n        this.getRevisions = function(filePath, callback) {\n            // Physical location of the workspace\n            if (!this.ide.workspaceDir) {\n                return callback(new Error(\n                    \"Can't retrieve the path to the user's workspace\\n\" + this.workspace));\n            }\n    \n            // Path of the final backup file inside the workspace\n            var absPath = this.getRevisionsPath(filePath + \".\" + FILE_SUFFIX);\n    \n            var self = this;\n            // does the revisions file exists?\n            fs.exists(absPath, function (exists) {\n                if (exists) {\n                    self.getAllRevisions(absPath, callback);\n                }\n                else {\n                    // create new file\n                    self.saveSingleRevision(filePath, null, callback);\n                }\n            });\n        };\n    \n        /**\n         * RevisionsPlugin#retrieveRevisionContent(revObj[, upperTSBound], callback)\n         * - revObj (Object): Object containing all the revisions in the document.\n         * - upperTSBound (Number): Timestamp of the revision to retrieve. Optional.\n         * - currentDoc (Function): Callback to pass the results to.\n         *\n         * Asynchronoulsy calculates the content of the document at a particular\n         * revision, or defaults to the current content of the document according to\n         * the last revision.\n         **/\n        this.retrieveRevisionContent = function(revObj, upperTSBound, callback) {\n            var timestamps = Object.keys(revObj.revisions).sort(function(a, b) {\n                return a - b;\n            });\n    \n            if (timestamps.length === 0) {\n                return callback(new Error(\"No revisions in the revisions Object\"));\n            }\n    \n            if (upperTSBound) {\n                var index = timestamps.indexOf(upperTSBound);\n                if (index > -1) {\n                    timestamps = timestamps.slice(0, index + 1);\n                }\n            }\n    \n            var content = \"\";\n            Async.list(timestamps)\n                .each(function(ts, next) {\n                    var revision = revObj.revisions[ts];\n                    content = Diff.patch_apply(revision.patch[0], content)[0];\n                    next();\n                })\n                .delay(0)\n                .end(function() {\n                    callback(null, content);\n                });\n        };\n    \n        /**\n         * RevisionsPlugin#getPreviousRevisionContent(path, callback)\n         * - path (String): Relative path for the file to retrieve contents from\n         * - callback (Function): Function that will be called with the previous contents\n         * of that file.\n         *\n         * Retrieves the previous contents of the given file.\n         **/\n        this.getPreviousRevisionContent = function(path, callback) {\n            var self = this;\n            this.getRevisions(path, function(err, revObj) {\n                if (err) {\n                    return callback(err);\n                }\n    \n                self.retrieveRevisionContent(revObj, null, function(err, content) {\n                    if (err)\n                        return callback(err);\n    \n                    callback(null, content);\n                });\n            });\n        };\n    \n        /**\n         * RevisionsPlugin#getCurrentDoc(path, message) -> String\n         * - path (String): Relative path for the file to get the document from\n         * - message (Object): Object with metadata of the document being retrieved.\n         *\n         * Retrieves the current document. In case the `message` object contains a\n         * non-empty `content` property, it will just use that, understanding that\n         * we are not in collaborative mode. Otherwise it will retrieve the document\n         * from the Concorde session object.\n         **/\n        this.getCurrentDoc = function(path, message) {\n            if (message && message.content) {\n                // Means that the client has detected we are NOT in concorde mode,\n                // in which case we can't retrieve the current contents of the\n                // document, so the client sends them along. There is no risk of\n                // syncing problems since the client is only one.\n                return message.content;\n            }\n    \n            path = PathUtils.getSessionStylePath.call(this, path);\n    \n            var sessions = this.workspace.plugins.concorde.server.getSessions();\n            var docSession = sessions[path];\n            if (docSession && docSession.getDocument) {\n                return (docSession.getDocument() || \"\").toString();\n            }\n        };\n    \n        /**\n         * RevisionsPlugin#broadcastRevisions(revObj[, user])\n         * - obj (Object): Object to be broadcasted.\n         * - user (Object): Optional. Particular user to whom we want to broadcast\n         * - options (Object): Optional. Properties to attach to the `data` object.\n         *\n         * Broadcast the given revision to all workspace clients.\n         **/\n        this.broadcastRevisions = function(revObj, user, options) {\n            var receiver = user || this.ide;\n            var data = {\n                type: \"revision\",\n                subtype: \"getRevisionHistory\",\n                body: { revisions: revObj }\n            };\n    \n            if (options) {\n                Object.keys(options).forEach(function(key) {\n                    data[key] = options[key];\n                });\n            }\n    \n            receiver.broadcast(JSON.stringify(data));\n        };\n    \n        this.broadcastConfirmSave = function(path, ts) {\n            this.ide.broadcast(JSON.stringify({\n                type: \"revision\",\n                subtype: \"confirmSave\",\n                path: path,\n                ts: ts\n            }));\n        };\n    \n        this.broadcastError = function(fromMethod, msg, user) {\n            var receiver = user || this.ide;\n            var data = {\n                type: \"revision\",\n                subtype: \"serverError\",\n                body: {\n                    fromMethod: fromMethod,\n                    msg: msg\n                }\n            };\n    \n            receiver.broadcast(JSON.stringify(data));\n        };\n    \n        this.saveSingleRevision = function(path, revision, callback) {\n            if (!path) {\n                return callback(new Error(\"Missing or wrong parameters (path, revision):\", path, revision));\n            }\n    \n            var absPath = this.getRevisionsPath(path + \".\" + FILE_SUFFIX);\n            var revObj;\n            fs.exists(absPath, function(exists) {\n                if (!exists) {\n                    fs.readFile(path, \"utf8\", function(err, data) {\n                        if (err)\n                            return console.error(err);\n    \n                        // We just created the revisions file. Since we\n                        // don't have a previous revision, our first revision will\n                        // consist of the previous contents of the file.\n                        var ts = Date.now();\n                        var firstRevision = {\n                            ts: ts,\n                            silentsave: true,\n                            restoring: false,\n                            patch: [Diff.patch_make(\"\", data)],\n                            length: data.length\n                        };\n                        var revisionString = JSON.stringify(firstRevision);\n                        revObj = {};\n                        revObj[ts] = firstRevision;\n    \n                        create(revisionString + \"\\n\");\n                    });\n                }\n                else if (revision) {\n                    fs.readFile(absPath, \"utf8\", write);\n                } else {\n                     callback(new Error(\"Missing or wrong parameters (path, revision):\", path, revision));\n                }\n            });\n    \n            function write(err, content) {\n                if (err)\n                    return callback(err);\n    \n                // broadcast first revision\n                var returnValue;\n                if (revObj) {\n                    returnValue = revObj;\n                }\n                else {\n                    content += JSON.stringify(revision) + \"\\n\";\n                    returnValue = {\n                        absPath: absPath,\n                        path: path,\n                        revision: revision.ts\n                    };\n                }\n    \n                fs.writeFile(absPath, content, \"utf8\", function(err) {\n                    callback(err, returnValue);\n                });\n            }\n    \n            function create(data) {\n                fs.mkdirP(Path.dirname(absPath), function(err) {\n                    if (!err)\n                        write(null, data);\n                });\n            }\n        };\n    }).call(RevisionsPlugin.prototype);\n};\n"]],"start1":0,"start2":0,"length1":0,"length2":19958}]],"length":19958}
{"contributors":[],"silentsave":false,"ts":1349265766134,"patch":[[{"diffs":[[0,"var fs;\n"],[-1,"    "],[0,""],[1,""],[0,"\n    imp"]],"start1":755,"start2":755,"length1":20,"length2":16},{"diffs":[[0,"= name;\n"],[-1,"    "],[0,""],[1,""],[0,"\n       "]],"start1":1151,"start2":1151,"length1":20,"length2":16},{"diffs":[[0,"1);\n"],[1,"\n"],[0,"    "],[-1,"}\n    \n    require(\"util\").inherits(RevisionsPlugin, Plugin);\n    \n    (function() {"],[1,"    this.onSaveRevision = function(user, message, client, _error) {\n            if (!message.path) {\n                return _error(\"No path sent for the file to save\");\n            }\n\n            this.savingQueue.push({\n                path: message.path,\n                revision: message.revision\n            }, function(err, revisionInfo) {\n                if (err) {\n                    return _error(err.toString());\n                }\n\n                self.broadcastConfirmSave(message.path, revisionInfo.revision);\n                if (message.forceRevisionListResponse === true) {\n                    self.getAllRevisions(revisionInfo.absPath, function(_err, revObj) {\n                        if (_err) {\n                            return _error(\"Error retrieving revisions for file \" + revisionInfo.absPath);\n                        }\n\n                        self.broadcastRevisions.call(self, revObj, user, {\n                            path: message.path\n                        });\n                    });\n                }\n            });\n        };\n\n        this.onGetRevisionHistory = function(user, message, client, _error) {\n            if (!message.path) {\n                return _error(\"No path sent for the file\");\n            }\n\n            this.getRevisions(message.path, function(err, revObj) {\n                if (err) {\n                    return _error(\"There was a problem retrieving the revisions\" +\n                        \" for the file \" + message.path + \":\\n\" + err);\n                }\n\n                self.broadcastRevisions.call(self, revObj, user, {\n                    id: message.id || null,\n                    nextAction: message.nextAction,\n                    path: message.path\n                });\n            });\n        };\n\n        this.onGetRealFileContents = function(user, message, client, _error) {\n            fs.readFile(message.path, \"utf8\", function (err, data) {\n                if (err) {\n                    return _error(\"There was a problem reading the contents for the file \" +\n                            message.path + \":\\n\" + err);\n\n                  }\n\n                  user.broadcast(JSON.stringify({\n                      type: \"revision\",\n                      subtype: \"getRealFileContents\",\n                      path: message.path,\n                      nextAction: message.nextAction,\n                      contents: data\n                  }));\n            });\n        };\n"],[0,"\n   "]],"start1":1473,"start2":1473,"length1":96,"length2":2456},{"diffs":[[0,"visions\""],[1," || !message.subCommand"],[0,") {\n    "]],"start1":4042,"start2":4042,"length1":16,"length2":39},{"diffs":[[0,";\n            }\n"],[-1,"    "],[0,""],[1,""],[0,"\n            var"]],"start1":4105,"start2":4105,"length1":36,"length2":32},{"diffs":[[0,"is;\n"],[-1,"            if (message.subCommand) {\n    "],[0,"    "]],"start1":4147,"start2":4147,"length1":50,"length2":8},{"diffs":[[0,"tion(msg) {\n"],[-1,"    "],[0,"            "]],"start1":4180,"start2":4180,"length1":28,"length2":24},{"diffs":[[0,"        "],[-1," "],[-1,"   };\n    \n    "],[1,"};\n\n"],[0,"        "]],"start1":4264,"start2":4264,"length1":32,"length2":20},{"diffs":[[0,"        "],[-1," "],[-1,"   "],[0,"// Direc"]],"start1":4326,"start2":4326,"length1":20,"length2":16},{"diffs":[[0,"omputed\n"],[-1,"    "],[0,"        "]],"start1":4389,"start2":4389,"length1":20,"length2":16},{"diffs":[[0,"            "],[-1,"    "],[0,"// save it.\n"]],"start1":4480,"start2":4480,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"case \"saveRe"]],"start1":4508,"start2":4508,"length1":28,"length2":24},{"diffs":[[0,"    "],[-1,"    if (!message.path) {\n                            return _error(\"No path sent for the file to save\");\n                        }\n    \n                        this.savingQueue.push({\n                            path: message.path,\n                            revision: message.revision\n                        }, function(err, revisionInfo) {\n                            if (err) {\n                                return _error(err.toString());\n                            }\n    \n                            self.broadcastConfirmSave(message.path, revisionInfo.revision);\n                            if (message.forceRevisionListResponse === true) {\n                                self.getAllRevisions(revisionInfo.absPath, function(_err, revObj) {\n                                    if (_err) {\n                                        return _error(\"Error retrieving revisions for file \" + revisionInfo.absPath);\n                                    }\n    \n                                    self.broadcastRevisions.call(self, revObj, user, {\n                                        path: message.path\n                                    });\n                                });\n                            }\n                        });\n                        break;\n    \n   "],[1,"self.onSaveRevision.call(self, user, message, client);\n                    break;\n\n"],[0,"    "]],"start1":4557,"start2":4557,"length1":1287,"length2":91},{"diffs":[[0,"            "],[-1," "],[0,"// The clien"]],"start1":4648,"start2":4648,"length1":25,"length2":24},{"diffs":[[0," particular\n"],[-1,"    "],[0,"            "]],"start1":4713,"start2":4713,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"// original "]],"start1":4811,"start2":4811,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"   "],[-1," "],[0,"// in order "]],"start1":4895,"start2":4895,"length1":28,"length2":24},{"diffs":[[0," file).\n"],[-1,"    "],[0,"        "]],"start1":4937,"start2":4937,"length1":20,"length2":16},{"diffs":[[0,"    "],[-1,"    if (!message.path) {\n                            return _error(\"No path sent for the file\");\n                        }\n    \n                        this.getRevisions(message.path, function(err, revObj) {\n                            if (err) {\n                                return _error(\"There was a problem retrieving the revisions\" +\n                                    \" for the file \" + message.path + \":\\n\" + err);\n                            }\n    \n                            self.broadcastRevisions.call(self, revObj, user, {\n                                id: message.id || null,\n                                nextAction: message.nextAction,\n                                path: message.path\n                            });\n                        });\n                        break;\n    \n                    case \"getRealFileContents\":\n                        fs.readFile(message.path, \"utf8\", function (err, data) {\n                            if (err) {\n                                return _error(\"There was a problem reading the contents for the file \" +\n                                        message.path + \":\\n\" + err);\n    \n                              }\n    \n                              user.broadcast(JSON.stringify({\n                                  type: \"revision\",\n                                  subtype: \"getRealFileContents\",\n                                  path: message.path,\n                                  nextAction: message.nextAction,\n                                  contents: data\n                              }));\n                        });\n                        break;\n    \n    "],[1,"self.onGetRevisionHistory.call(self, user, message, client);\n                    break;\n\n                case \"getRealFileContents\":\n                    self.onGetRealFileContents.call(self, user, message, client);\n                    break;\n\n"],[0,"    "]],"start1":5004,"start2":5004,"length1":1651,"length2":251},{"diffs":[[0,"                "],[-1,"   "],[-1," "],[0,"if (!message.pat"]],"start1":5289,"start2":5289,"length1":36,"length2":32},{"diffs":[[0,"message.path) {\n"],[-1,"    "],[0,"                "]],"start1":5310,"start2":5310,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n  "],[1,"}\n"],[0,"            "]],"start1":5408,"start2":5408,"length1":32,"length2":26},{"diffs":[[0,"        "],[-1,"  "],[0,"break;\n"],[-1,"    \n    "],[1,"\n"],[0,"        "]],"start1":5434,"start2":5434,"length1":34,"length2":24},{"diffs":[[0,"                "],[-1,"  "],[-1,"  "],[0,"if (!message.pat"]],"start1":5493,"start2":5493,"length1":36,"length2":32},{"diffs":[[0,"message.path) {\n"],[-1,"    "],[0,"                "]],"start1":5514,"start2":5514,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n    \n    "],[1,"}\n\n"],[0,"            "]],"start1":5620,"start2":5620,"length1":39,"length2":27},{"diffs":[[0,"                "],[-1,"    "],[0,"if (message.isFo"]],"start1":5707,"start2":5707,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"fs.rmdir(pat"]],"start1":5768,"start2":5768,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":5840,"start2":5840,"length1":34,"length2":26},{"diffs":[[0,"        "],[-1,"    "],[0,"fs.unlin"]],"start1":5897,"start2":5897,"length1":20,"length2":16},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":5950,"start2":5950,"length1":34,"length2":26},{"diffs":[[0," break;\n"],[-1,"    \n    "],[1,"\n"],[0,"        "]],"start1":5983,"start2":5983,"length1":25,"length2":17},{"diffs":[[0,"\"moveRevision\":\n"],[-1,"    "],[0,"                "]],"start1":6013,"start2":6013,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"return _error(\"N"]],"start1":6098,"start2":6098,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"\n           "]],"start1":6187,"start2":6187,"length1":34,"length2":26},{"diffs":[[0,"            "],[-1,"    "],[0,"var fromPath"]],"start1":6210,"start2":6210,"length1":28,"length2":24},{"diffs":[[0,"(message.path);\n"],[-1,"    "],[0,"                "]],"start1":6258,"start2":6258,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"   "],[-1," "],[0,"if (message.isFo"]],"start1":6351,"start2":6351,"length1":36,"length2":32},{"diffs":[[0,"der !== true) {\n"],[-1,"    "],[0,"                "]],"start1":6384,"start2":6384,"length1":36,"length2":32},{"diffs":[[0,"        "],[-1,"    "],[0,"toPath +"]],"start1":6471,"start2":6471,"length1":20,"length2":16},{"diffs":[[0,"            "],[-1,"   "],[-1," "],[0,"}\n"],[-1,"    \n    "],[1,"\n"],[0,"            "]],"start1":6516,"start2":6516,"length1":39,"length2":27},{"diffs":[[0,"            "],[-1,"  "],[-1,"  "],[0,"if (!fromPat"]],"start1":6610,"start2":6610,"length1":28,"length2":24},{"diffs":[[0,"omPathExists) {\n"],[-1,"    "],[0,"                "]],"start1":6629,"start2":6629,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n  "],[1,"}\n"],[0,"            "]],"start1":6693,"start2":6693,"length1":32,"length2":26},{"diffs":[[0,"                "],[-1,"  "],[0,"fs.exists(Path.d"]],"start1":6715,"start2":6715,"length1":34,"length2":32},{"diffs":[[0,"toPathExists) {\n"],[-1,"    "],[0,"                "]],"start1":6772,"start2":6772,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    "],[0,"fs.rename(fr"]],"start1":6864,"start2":6864,"length1":28,"length2":24},{"diffs":[[0,"                "],[-1," "],[-1,"   "],[0,"if (err) {\n     "]],"start1":6940,"start2":6940,"length1":36,"length2":32},{"diffs":[[0,"     if (err) {\n"],[-1,"    "],[0,"                "]],"start1":6951,"start2":6951,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":7098,"start2":7098,"length1":34,"length2":26},{"diffs":[[0,"            "],[-1,"    };\n    \n "],[1,"};\n\n"],[0,"            "]],"start1":7164,"start2":7164,"length1":37,"length2":28},{"diffs":[[0,"            "],[-1,"   "],[0,"if (toPathEx"]],"start1":7196,"start2":7196,"length1":27,"length2":24},{"diffs":[[0,"toPathExists) {\n"],[-1,"    "],[0,"                "]],"start1":7212,"start2":7212,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"}\n              "]],"start1":7284,"start2":7284,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"else {\n"],[-1,"    "],[0,"            "]],"start1":7318,"start2":7318,"length1":39,"length2":31},{"diffs":[[0,"function(err) {\n"],[-1,"    "],[0,"                "]],"start1":7401,"start2":7401,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"renameFn();\n    "]],"start1":7489,"start2":7489,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":7541,"start2":7541,"length1":34,"length2":26},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":7607,"start2":7607,"length1":34,"length2":26},{"diffs":[[0,"            "],[-1,"   "],[-1," "],[0,"});\n"],[-1,"    "],[0,"            "]],"start1":7657,"start2":7657,"length1":36,"length2":28},{"diffs":[[0," break;\n"],[-1,"                }\n"],[0,"        "]],"start1":7692,"start2":7692,"length1":34,"length2":16},{"diffs":[[0,"rue;\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        /**\n   "]],"start1":7734,"start2":7734,"length1":36,"length2":32},{"diffs":[[0,"} };\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        this.ge"]],"start1":8154,"start2":8154,"length1":36,"length2":32},{"diffs":[[0,"              }\n"],[-1,"    "],[0,""],[1,""],[0,"\n               "]],"start1":8395,"start2":8395,"length1":36,"length2":32},{"diffs":[[0," });\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        /**\n   "]],"start1":9513,"start2":9513,"length1":36,"length2":32},{"diffs":[[0,"th);\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        /**\n   "]],"start1":9864,"start2":9864,"length1":36,"length2":32},{"diffs":[[0,";\n            }\n"],[-1,"    "],[0,""],[1,""],[0,"\n            // "]],"start1":10687,"start2":10687,"length1":36,"length2":32},{"diffs":[[0,"UFFIX);\n"],[-1,"    "],[0,""],[1,""],[0,"\n       "]],"start1":10841,"start2":10841,"length1":20,"length2":16},{"diffs":[[0," });\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        /**\n   "]],"start1":11248,"start2":11248,"length1":36,"length2":32},{"diffs":[[0,"            });\n"],[-1,"    "],[0,""],[1,""],[0,"\n            if "]],"start1":12012,"start2":12012,"length1":36,"length2":32},{"diffs":[[0,";\n            }\n"],[-1,"    "],[0,""],[1,""],[0,"\n            if "]],"start1":12154,"start2":12154,"length1":36,"length2":32},{"diffs":[[0,"}\n            }\n"],[-1,"    "],[0,""],[1,""],[0,"\n            var"]],"start1":12380,"start2":12380,"length1":36,"length2":32},{"diffs":[[0," });\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        /**\n   "]],"start1":12808,"start2":12808,"length1":36,"length2":32},{"diffs":[[0,"              }\n"],[-1,"    "],[0,""],[1,""],[0,"\n               "]],"start1":13418,"start2":13418,"length1":36,"length2":32},{"diffs":[[0," callback(err);\n"],[-1,"    "],[0,""],[1,""],[0,"\n               "]],"start1":13578,"start2":13578,"length1":36,"length2":32},{"diffs":[[0," });\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        /**\n   "]],"start1":13671,"start2":13671,"length1":36,"length2":32},{"diffs":[[0,";\n            }\n"],[-1,"    "],[0,""],[1,""],[0,"\n            pat"]],"start1":14699,"start2":14699,"length1":36,"length2":32},{"diffs":[[0," path);\n"],[-1,"    "],[0,""],[1,""],[0,"\n       "]],"start1":14775,"start2":14775,"length1":20,"length2":16},{"diffs":[[0,"   }\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        /**\n   "]],"start1":15043,"start2":15043,"length1":36,"length2":32},{"diffs":[[0,"\n            };\n"],[-1,"    "],[0,""],[1,""],[0,"\n            if "]],"start1":15706,"start2":15706,"length1":36,"length2":32},{"diffs":[[0,";\n            }\n"],[-1,"    "],[0,""],[1,""],[0,"\n            rec"]],"start1":15875,"start2":15875,"length1":36,"length2":32},{"diffs":[[0,"a));\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        this.br"]],"start1":15941,"start2":15941,"length1":36,"length2":32},{"diffs":[[0,"}));\n        };\n"],[-1,"    "],[0,""],[1,""],[0,"\n        this.br"]],"start1":16200,"start2":16200,"length1":36,"length2":32},{"diffs":[[0,"\n            };\n"],[-1,"    "],[0,""],[1,""],[0,"\n            rec"]],"start1":16539,"start2":16539,"length1":36,"length2":32},{"diffs":[[0,"     };\n"],[-1,"    "],[0,""],[1,""],[0,"\n       "]],"start1":16613,"start2":16613,"length1":20,"length2":16},{"diffs":[[0,";\n            }\n"],[-1,"    "],[0,""],[1,""],[0,"\n            var"]],"start1":16825,"start2":16825,"length1":36,"length2":32},{"diffs":[[0,"error(err);\n"],[-1,"    "],[0,""],[1,""],[0,"\n           "]],"start1":17166,"start2":17166,"length1":28,"length2":24},{"diffs":[[0,"vision;\n"],[-1,"    "],[0,""],[1,""],[0,"\n       "]],"start1":17922,"start2":17922,"length1":20,"length2":16},{"diffs":[[0,"    });\n"],[-1,"    "],[0,""],[1,""],[0,"\n       "]],"start1":18280,"start2":18280,"length1":20,"length2":16},{"diffs":[[0,"k(err);\n"],[-1,"    "],[0,""],[1,""],[0,"\n       "]],"start1":18391,"start2":18391,"length1":20,"length2":16},{"diffs":[[0,"              }\n"],[-1,"    "],[0,""],[1,""],[0,"\n               "]],"start1":18839,"start2":18839,"length1":36,"length2":32},{"diffs":[[0,"      }\n"],[-1,"    "],[0,""],[1,""],[0,"\n       "]],"start1":19001,"start2":19001,"length1":20,"length2":16},{"diffs":[[0,"   }"],[-1,").call"],[1,"\n    require(\"util\").inherits"],[0,"(Rev"]],"start1":19230,"start2":19230,"length1":14,"length2":37},{"diffs":[[0,"ugin"],[-1,".prototype"],[1,", Plugin"],[0,");\n}"]],"start1":19275,"start2":19275,"length1":18,"length2":16}]],"length":19293,"saved":false}
{"ts":1349265901806,"patch":[[{"diffs":[[0,"1);\n"],[-1,"\n        this.onSaveRevision = function(user, message, client, _error) {\n"],[1,"    }\n\n    require(\"util\").inherits(RevisionsPlugin, Plugin);\n\n    (function() {\n        this.command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\") {\n                return false;\n            }\n\n            var self = this;\n            if (message.subCommand) {\n                var _error = function(msg) {\n                    self.broadcastError(message.subCommand, msg, user);\n                };\n\n                switch (message.subCommand) {\n                    // Directly save a revision. The revision has been precomputed\n                    // on the client as is merely passed to the server in order to\n                    // save it.\n                    case \"saveRevision\":\n            "],[0,"    "]],"start1":1473,"start2":1473,"length1":81,"length2":763},{"diffs":[[0,"message.path) {\n"],[1,"            "],[0,"                "]],"start1":2249,"start2":2249,"length1":32,"length2":44},{"diffs":[[0,"\");\n            "],[1,"    "],[-1,"}\n\n"],[1,"        }\n\n            "],[0,"            this"]],"start1":2341,"start2":2341,"length1":35,"length2":59},{"diffs":[[0,"                "],[1,"    "],[1,"        "],[0,"path: message.pa"]],"start1":2420,"start2":2420,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"     "],[1,"       "],[0,"revision: messag"]],"start1":2468,"start2":2468,"length1":32,"length2":44},{"diffs":[[0,"        "],[1,"     "],[1,"       "],[0,"}, funct"]],"start1":2527,"start2":2527,"length1":16,"length2":28},{"diffs":[[0,"                "],[1,"            "],[0,"if (err) {\n     "]],"start1":2580,"start2":2580,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"     "],[1,"       "],[0,"return _error(er"]],"start1":2623,"start2":2623,"length1":32,"length2":44},{"diffs":[[0,"                "],[-1,"}\n\n"],[1,"            }\n\n      "],[0,"                "]],"start1":2682,"start2":2682,"length1":35,"length2":53},{"diffs":[[0,"                "],[1,"      "],[0,"self.broadcastCo"]],"start1":2719,"start2":2719,"length1":32,"length2":38},{"diffs":[[0,"                "],[1,"            "],[0,"if (message.forc"]],"start1":2805,"start2":2805,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"       "],[1,"     "],[0,"self.getAllRevis"]],"start1":2887,"start2":2887,"length1":32,"length2":44},{"diffs":[[0,"            "],[1,"            "],[0,"if (_err) {\n"]],"start1":2995,"start2":2995,"length1":24,"length2":36},{"diffs":[[0,"                "],[1,"        "],[1,"    "],[0,"return _error(\"E"]],"start1":3043,"start2":3043,"length1":32,"length2":44},{"diffs":[[0,"                "],[-1,"}\n\n"],[1,"            }\n\n        "],[0,"                "]],"start1":3157,"start2":3157,"length1":35,"length2":55},{"diffs":[[0,"                "],[1,"    "],[0,"self.broadcastRe"]],"start1":3204,"start2":3204,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"            "],[0,"path: message.pa"]],"start1":3287,"start2":3287,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"         "],[1,"   "],[0,"});\n            "]],"start1":3342,"start2":3342,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"         "],[1,"   "],[0,"});\n            "]],"start1":3378,"start2":3378,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"         "],[-1,"}\n"],[1,"   }\n          "],[0,"            });\n"]],"start1":3410,"start2":3410,"length1":34,"length2":56},{"diffs":[[0,"                "],[1,"  "],[0,"});\n        };\n\n"]],"start1":3446,"start2":3446,"length1":32,"length2":34},{"diffs":[[0,"    "],[-1,"};\n\n        this.onGetRevisionHistory = function(user, message, client, _error) {\n"],[1,"                break;\n\n                    // The client requests the history of revisions for a particular\n                    // document (indicated by `path`). The client might also want the\n                    // original contents of that file (the ones where diffs are applied\n                    // in order to get the current file).\n                    case \"getRevisionHistory\":\n            "],[0,"    "]],"start1":3472,"start2":3472,"length1":90,"length2":408},{"diffs":[[0,"                "],[1,"         "],[1,"   "],[0,"return _error(\"N"]],"start1":3909,"start2":3909,"length1":32,"length2":44},{"diffs":[[0,"\");\n            "],[-1,"}\n\n"],[1,"            }\n\n          "],[0,"            this"]],"start1":3977,"start2":3977,"length1":35,"length2":57},{"diffs":[[0,"                "],[1,"  "],[0,"this.getRevision"]],"start1":4014,"start2":4014,"length1":32,"length2":34},{"diffs":[[0,"                "],[1,"            "],[0,"if (err) {\n     "]],"start1":4088,"start2":4088,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"          "],[1,"  "],[0,"return _error(\"T"]],"start1":4131,"start2":4131,"length1":32,"length2":44},{"diffs":[[0,"        "],[1,"            "],[0,"\" for th"]],"start1":4238,"start2":4238,"length1":16,"length2":28},{"diffs":[[0,"                "],[1,"           "],[1," "],[0,"}\n\n"],[1,"            "],[0,"                "]],"start1":4306,"start2":4306,"length1":35,"length2":59},{"diffs":[[0,"        "],[1,"           "],[1," "],[0,"id: mess"]],"start1":4428,"start2":4428,"length1":16,"length2":28},{"diffs":[[0,"| null,\n"],[1,"            "],[0,"        "]],"start1":4464,"start2":4464,"length1":16,"length2":28},{"diffs":[[0,"age.nextAction,\n"],[1,"            "],[0,"                "]],"start1":4520,"start2":4520,"length1":32,"length2":44},{"diffs":[[0,"    "],[-1,"});\n            });\n        };\n\n        this.onGetRealFileContents = function(user, message, client, _error) {\n"],[1,"            });\n                        });\n                        break;\n\n                    case \"getRealFileContents\":\n            "],[0,"    "]],"start1":4599,"start2":4599,"length1":119,"length2":144},{"diffs":[[0,"                "],[1,"   "],[1,"         "],[0,"if (err) {\n     "]],"start1":4808,"start2":4808,"length1":32,"length2":44},{"diffs":[[0,"     if (err) {\n"],[1,"            "],[0,"                "]],"start1":4831,"start2":4831,"length1":32,"length2":44},{"diffs":[[0,"        "],[1,"            "],[0,"message."]],"start1":4972,"start2":4972,"length1":16,"length2":28},{"diffs":[[0,"                "],[-1,"}\n\n"],[1,"            }\n\n     "],[0,"                "]],"start1":5024,"start2":5024,"length1":35,"length2":52},{"diffs":[[0,"        "],[1,"       "],[0,"user.bro"]],"start1":5070,"start2":5070,"length1":16,"length2":23},{"diffs":[[0,"    "],[-1,"type: \"revision\",\n                      subtype: \"getRealFileContents\",\n                      path: message.path,\n                      nextAction: message.nextAction,\n                      contents: data\n                  }));\n            });\n        };\n\n        this.command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\" || !message.subCommand) {\n                return false;\n            }\n\n            var self = this;\n            var _error = function(msg) {\n                self.broadcastError(message.subCommand, msg, user);\n            };\n\n            switch (message.subCommand) {\n                // Directly save a revision. The revision has been precomputed\n                // on the client as is merely passed to the server in order to\n                // save it.\n                case \"saveRevision\":\n                    self.onSaveRevision.call(self, user, message, client);\n                    break;\n\n                // The client requests the history of revisions for a particular\n                // document (indicated by `path`). The client might also want the\n                // original contents of that file (the ones where diffs are applied\n                // in order to get the current file).\n                case \"getRevisionHistory\":\n"],[1,"            type: \"revision\",\n                                  subtype: \"getRealFileContents\",\n                                  path: message.path,\n                                  nextAction: message.nextAction,\n                                  contents: data\n                              }));\n                 "],[0,"       "],[1,"});\n"],[0,"    "]],"start1":5135,"start2":5135,"length1":1333,"length2":336},{"diffs":[[0,"    "],[-1,"self.onGetRevisionHistory.call(self, user, message, client);\n                    break;\n\n                case \"getRealFileContents\":\n                    self.onGetRealFileContents.call(self, user, message, client);\n         "],[0,"    "]],"start1":5476,"start2":5476,"length1":232,"length2":8},{"diffs":[[0,"        break;\n\n"],[1,"    "],[0,"                "]],"start1":5483,"start2":5483,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"  "],[1,"  "],[0,"if (!message.pat"]],"start1":5541,"start2":5541,"length1":32,"length2":36},{"diffs":[[0,"message.path) {\n"],[1,"    "],[0,"                "]],"start1":5566,"start2":5566,"length1":32,"length2":36},{"diffs":[[0,"                "],[-1,"}\n"],[1,"    }\n  "],[0,"                "]],"start1":5664,"start2":5664,"length1":34,"length2":40},{"diffs":[[0,"            "],[1,"  "],[0,"break;\n\n"],[1,"    "],[0,"            "]],"start1":5696,"start2":5696,"length1":32,"length2":38},{"diffs":[[0,"                "],[1,"    "],[0,"if (!message.pat"]],"start1":5765,"start2":5765,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"  "],[1,"  "],[0,"return _error(\"N"]],"start1":5814,"start2":5814,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"    "],[0,"}\n\n             "]],"start1":5896,"start2":5896,"length1":32,"length2":36},{"diffs":[[0,"            "],[1," "],[1,"   "],[0,"var path = t"]],"start1":5927,"start2":5927,"length1":24,"length2":28},{"diffs":[[0,"                "],[1,"   "],[1," "],[0,"if (message.isFo"]],"start1":5995,"start2":5995,"length1":32,"length2":36},{"diffs":[[0,"der === true) {\n"],[1,"    "],[0,"                "]],"start1":6032,"start2":6032,"length1":32,"length2":36},{"diffs":[[0,"                "],[-1,"}\n"],[1,"    }\n   "],[0,"                "]],"start1":6132,"start2":6132,"length1":34,"length2":41},{"diffs":[[0,"                "],[1," "],[0,"else {\n"],[1,"    "],[0,"                "]],"start1":6161,"start2":6161,"length1":39,"length2":44},{"diffs":[[0,"                "],[-1,"}\n"],[1,"    }\n   "],[0,"                "]],"start1":6254,"start2":6254,"length1":34,"length2":41},{"diffs":[[0,"            "],[1," "],[0,"break;\n\n"],[1,"    "],[0,"            "]],"start1":6287,"start2":6287,"length1":32,"length2":37},{"diffs":[[0,"\"moveRevision\":\n"],[1,"    "],[0,"                "]],"start1":6333,"start2":6333,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"   "],[1," "],[0,"return _error(\"N"]],"start1":6422,"start2":6422,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"    "],[0,"}\n\n             "]],"start1":6511,"start2":6511,"length1":32,"length2":36},{"diffs":[[0,"            "],[1,"  "],[1,"  "],[0,"var fromPath"]],"start1":6542,"start2":6542,"length1":24,"length2":28},{"diffs":[[0,"(message.path);\n"],[1,"    "],[0,"                "]],"start1":6594,"start2":6594,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"    "],[0,"if (message.isFo"]],"start1":6691,"start2":6691,"length1":32,"length2":36},{"diffs":[[0,"            "],[1,"    "],[0,"fromPath += "]],"start1":6756,"start2":6756,"length1":24,"length2":28},{"diffs":[[0," + FILE_SUFFIX;\n"],[1,"    "],[0,"                "]],"start1":6787,"start2":6787,"length1":32,"length2":36},{"diffs":[[0,"                "],[-1,"}\n\n"],[1,"    }\n\n    "],[0,"                "]],"start1":6864,"start2":6864,"length1":35,"length2":43},{"diffs":[[0,"omPathExists) {\n"],[1,"    "],[0,"                "]],"start1":6942,"start2":6942,"length1":32,"length2":36},{"diffs":[[0,"            "],[1,"    "],[0,"return;\n    "]],"start1":7025,"start2":7025,"length1":24,"length2":28},{"diffs":[[0,"                "],[-1,"}\n"],[1,"    }\n    "],[0,"                "]],"start1":7057,"start2":7057,"length1":34,"length2":42},{"diffs":[[0,"            "],[1,"    "],[0,"var renameFn"]],"start1":7180,"start2":7180,"length1":24,"length2":28},{"diffs":[[0," = function() {\n"],[1,"    "],[0,"                "]],"start1":7208,"start2":7208,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"    "],[0,"if (err) {\n     "]],"start1":7324,"start2":7324,"length1":32,"length2":36},{"diffs":[[0,"                "],[1," "],[1,"   "],[0,"_error(\"There wa"]],"start1":7379,"start2":7379,"length1":32,"length2":36},{"diffs":[[0,"                "],[-1,"}\n"],[1,"    }\n    "],[0,"                "]],"start1":7486,"start2":7486,"length1":34,"length2":42},{"diffs":[[0,"                "],[1," "],[1,"   "],[0,"};\n\n"],[1,"    "],[0,"                "]],"start1":7560,"start2":7560,"length1":36,"length2":44},{"diffs":[[0,"                "],[1,"    "],[0,"renameFn();\n    "]],"start1":7652,"start2":7652,"length1":32,"length2":36},{"diffs":[[0,"                "],[1," "],[-1,"}\n"],[1,"   }\n    "],[0,"                "]],"start1":7696,"start2":7696,"length1":34,"length2":42},{"diffs":[[0,"         else {\n"],[1,"    "],[0,"                "]],"start1":7741,"start2":7741,"length1":32,"length2":36},{"diffs":[[0,"                "],[1," "],[1,"   "],[0,"if (!err) {\n    "]],"start1":7861,"start2":7861,"length1":32,"length2":36},{"diffs":[[0,"if (!err) {\n"],[1,"    "],[0,"            "]],"start1":7881,"start2":7881,"length1":24,"length2":28},{"diffs":[[0,"                "],[-1,"}\n"],[1,"    }\n  "],[0,"                "]],"start1":7969,"start2":7969,"length1":34,"length2":40},{"diffs":[[0,"                "],[1,"  "],[0,"});\n"],[1,"    "],[0,"                "]],"start1":8009,"start2":8009,"length1":36,"length2":42},{"diffs":[[0,"                "],[1,"    "],[0,"});\n            "]],"start1":8073,"start2":8073,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"  "],[1,"  "],[0,"});\n"],[1,"    "],[0,"                "]],"start1":8101,"start2":8101,"length1":36,"length2":44},{"diffs":[[0," break;\n"],[1,"                }\n"],[0,"        "]],"start1":8148,"start2":8148,"length1":16,"length2":34},{"diffs":[[0,"   }"],[-1,"\n    require(\"util\").inherits"],[1,").call"],[0,"(Rev"]],"start1":19704,"start2":19704,"length1":37,"length2":14},{"diffs":[[0,"nsPlugin"],[-1,", Plugin"],[1,".prototype"],[0,");\n};\n"]],"start1":19722,"start2":19722,"length1":22,"length2":24}]],"length":19746,"saved":false}
{"ts":1349265957598,"patch":[[{"diffs":[[0,"1);\n"],[-1,"    }\n\n    require(\"util\").inherits(RevisionsPlugin, Plugin);\n\n    (function() {"],[0,"\n   "]],"start1":1473,"start2":1473,"length1":88,"length2":8},{"diffs":[[0,"   }"],[-1,").call"],[1,"\n    require(\"util\").inherits"],[0,"(Rev"]],"start1":19624,"start2":19624,"length1":14,"length2":37},{"diffs":[[0,"ugin"],[-1,".prototype"],[1,", Plugin"],[0,");\n}"]],"start1":19669,"start2":19669,"length1":18,"length2":16}]],"length":19687,"saved":false}
{"ts":1349266177226,"patch":[[{"diffs":[[0,"visions\""],[-1,""],[0,""],[1," || !message.subCommand"],[0,") {\n    "]],"start1":1594,"start2":1594,"length1":16,"length2":39},{"diffs":[[0,"is;\n"],[-1,"            if (message.subCommand) {\n    "],[0,"    "]],"start1":1699,"start2":1699,"length1":50,"length2":8},{"diffs":[[0,"tion(msg) {\n"],[-1,"    "],[0,"            "]],"start1":1732,"start2":1732,"length1":28,"length2":24},{"diffs":[[0,"msg, user);\n"],[-1,"    "],[0,"            "]],"start1":1800,"start2":1800,"length1":28,"length2":24},{"diffs":[[0,"        "],[-1,"    "],[0,"switch ("]],"start1":1832,"start2":1832,"length1":20,"length2":16},{"diffs":[[0,"e.subCommand) {\n"],[-1,"    "],[0,"                "]],"start1":1854,"start2":1854,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    "],[0,"// on the cl"]],"start1":1953,"start2":1953,"length1":28,"length2":24},{"diffs":[[0,"in order to\n"],[-1,"    "],[0,"            "]],"start1":2016,"start2":2016,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"    "],[0,"case \"saveRe"]],"start1":2060,"start2":2060,"length1":28,"length2":24},{"diffs":[[0,"\"saveRevision\":\n"],[-1,"    "],[0,"                "]],"start1":2077,"start2":2077,"length1":36,"length2":32},{"diffs":[[0,"message.path) {\n"],[-1,"    "],[0,"                "]],"start1":2118,"start2":2118,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"}\n\n             "]],"start1":2214,"start2":2214,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"this.savingQ"]],"start1":2241,"start2":2241,"length1":28,"length2":24},{"diffs":[[0,"                "],[-1,"    "],[0,"path: message.pa"]],"start1":2285,"start2":2285,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1," "],[-1,"   "],[0,"revision: messag"]],"start1":2329,"start2":2329,"length1":36,"length2":32},{"diffs":[[0,"essage.revision\n"],[-1,"    "],[0,"                "]],"start1":2356,"start2":2356,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1," "],[-1,"   "],[0,"if (err) {\n     "]],"start1":2433,"start2":2433,"length1":36,"length2":32},{"diffs":[[0,"     if (err) {\n"],[-1,"    "],[0,"                "]],"start1":2444,"start2":2444,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"  "],[-1,"  "],[0,"}\n\n"],[-1,"    "],[0,"            "]],"start1":2531,"start2":2531,"length1":35,"length2":27},{"diffs":[[0,"                "],[-1,"  "],[-1,"  "],[0,"if (message.forc"]],"start1":2642,"start2":2642,"length1":36,"length2":32},{"diffs":[[0,"nse === true) {\n"],[-1,"    "],[0,"                "]],"start1":2692,"start2":2692,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"  "],[-1,"  "],[0,"if (_err) {\n"]],"start1":2824,"start2":2824,"length1":28,"length2":24},{"diffs":[[0,"if (_err) {\n"],[-1,"    "],[0,"            "]],"start1":2836,"start2":2836,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"  "],[-1,"  "],[0,"}\n\n"],[-1,"    "],[0,"            "]],"start1":2982,"start2":2982,"length1":35,"length2":27},{"diffs":[[0,"                "],[-1,"    "],[0,"path: message.pa"]],"start1":3100,"start2":3100,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"});\n            "]],"start1":3151,"start2":3151,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"   "],[-1," "],[0,"});\n            "]],"start1":3183,"start2":3183,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n   "],[1,"}\n"],[0,"            "]],"start1":3215,"start2":3215,"length1":33,"length2":26},{"diffs":[[0,"            "],[-1," "],[0,"});\n"],[-1,"    "],[0,"            "]],"start1":3237,"start2":3237,"length1":33,"length2":28},{"diffs":[[0,"            "],[-1,"   "],[-1," "],[0,"// The clien"]],"start1":3285,"start2":3285,"length1":28,"length2":24},{"diffs":[[0," particular\n"],[-1,"    "],[0,"            "]],"start1":3350,"start2":3350,"length1":28,"length2":24},{"diffs":[[0,"so want the\n"],[-1,"    "],[0,"            "]],"start1":3432,"start2":3432,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"    "],[0,"// in order "]],"start1":3532,"start2":3532,"length1":28,"length2":24},{"diffs":[[0," file).\n"],[-1,"    "],[0,"        "]],"start1":3574,"start2":3574,"length1":20,"length2":16},{"diffs":[[0,"                "],[-1,"    "],[0,"if (!message.pat"]],"start1":3629,"start2":3629,"length1":36,"length2":32},{"diffs":[[0,"message.path) {\n"],[-1,"    "],[0,"                "]],"start1":3650,"start2":3650,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n\n    "],[1,"}\n\n"],[0,"            "]],"start1":3742,"start2":3742,"length1":35,"length2":27},{"diffs":[[0,"                "],[-1,"    "],[0,"if (err) {\n     "]],"start1":3841,"start2":3841,"length1":36,"length2":32},{"diffs":[[0,"     if (err) {\n"],[-1,"    "],[0,"                "]],"start1":3852,"start2":3852,"length1":36,"length2":32},{"diffs":[[0,"        "],[-1,"    "],[0,"\" for th"]],"start1":3983,"start2":3983,"length1":20,"length2":16},{"diffs":[[0,"                "],[-1,"    "],[0,"}\n\n             "]],"start1":4047,"start2":4047,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1," "],[-1,"   "],[0,"self.broadcastRe"]],"start1":4074,"start2":4074,"length1":36,"length2":32},{"diffs":[[0,"        "],[-1,"    "],[0,"id: mess"]],"start1":4161,"start2":4161,"length1":20,"length2":16},{"diffs":[[0,"                "],[-1," "],[-1,"   "],[0,"nextAction: mess"]],"start1":4205,"start2":4205,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"path: message.pa"]],"start1":4265,"start2":4265,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"});\n"],[-1,"    "],[0,"            "]],"start1":4312,"start2":4312,"length1":36,"length2":28},{"diffs":[[0,"        "],[-1,"  "],[-1,"  "],[0,"break;\n\n"],[-1,"    "],[0,"        "]],"start1":4364,"start2":4364,"length1":32,"length2":24},{"diffs":[[0,"                "],[-1,"  "],[-1,"  "],[0,"fs.readFile(mess"]],"start1":4428,"start2":4428,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"if (err) {\n     "]],"start1":4509,"start2":4509,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"  "],[-1,"  "],[0,"return _error(\"T"]],"start1":4548,"start2":4548,"length1":36,"length2":32},{"diffs":[[0,"        "],[-1,"    "],[0,"message."]],"start1":4665,"start2":4665,"length1":20,"length2":16},{"diffs":[[0,"            "],[-1,"  "],[-1,"  "],[0,"}\n\n"],[-1,"    "],[0,"            "]],"start1":4717,"start2":4717,"length1":35,"length2":27},{"diffs":[[0,"                "],[-1,"   "],[-1," "],[0,"type: \"revision\""]],"start1":4804,"start2":4804,"length1":36,"length2":32},{"diffs":[[0,"pe: \"revision\",\n"],[-1,"    "],[0,"                "]],"start1":4822,"start2":4822,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"   "],[-1," "],[0,"path: message.pa"]],"start1":4914,"start2":4914,"length1":36,"length2":32},{"diffs":[[0,": message.path,\n"],[-1,"    "],[0,"                "]],"start1":4934,"start2":4934,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    "],[0,"contents: da"]],"start1":5030,"start2":5030,"length1":28,"length2":24},{"diffs":[[0,"                "],[-1,"    "],[0,"}));\n           "]],"start1":5067,"start2":5067,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"   "],[-1," "],[0,"});\n"],[-1,"    "],[0,"            "]],"start1":5096,"start2":5096,"length1":36,"length2":28},{"diffs":[[0,"        break;\n\n"],[-1,"    "],[0,"                "]],"start1":5124,"start2":5124,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"if (!message.pat"]],"start1":5178,"start2":5178,"length1":36,"length2":32},{"diffs":[[0,"message.path) {\n"],[-1,"    "],[0,"                "]],"start1":5199,"start2":5199,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":5297,"start2":5297,"length1":34,"length2":26},{"diffs":[[0,"            "],[-1,"    "],[0,"case \"remove"]],"start1":5343,"start2":5343,"length1":28,"length2":24},{"diffs":[[0,"emoveRevision\":\n"],[-1,"    "],[0,"                "]],"start1":5362,"start2":5362,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"return _error(\"N"]],"start1":5427,"start2":5427,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"}\n\n             "]],"start1":5505,"start2":5505,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"var path = t"]],"start1":5532,"start2":5532,"length1":28,"length2":24},{"diffs":[[0,"                "],[-1,"    "],[0,"if (message.isFo"]],"start1":5596,"start2":5596,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"fs.rmdir(pat"]],"start1":5657,"start2":5657,"length1":28,"length2":24},{"diffs":[[0,"                "],[-1,"    "],[0,"}\n              "]],"start1":5725,"start2":5725,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"else {\n"],[-1,"    "],[0,"            "]],"start1":5751,"start2":5751,"length1":39,"length2":31},{"diffs":[[0,"            "],[-1," "],[-1,"   }\n    "],[1,"}\n"],[0,"            "]],"start1":5839,"start2":5839,"length1":34,"length2":26},{"diffs":[[0,"            "],[-1,"  "],[-1,"  "],[0,"case \"moveRe"]],"start1":5885,"start2":5885,"length1":28,"length2":24},{"diffs":[[0,"\"moveRevision\":\n"],[-1,"    "],[0,"                "]],"start1":5902,"start2":5902,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"  "],[-1,"  "],[0,"return _error(\"N"]],"start1":5987,"start2":5987,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"}\n\n             "]],"start1":6072,"start2":6072,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"  "],[-1,"  "],[0,"var fromPath"]],"start1":6099,"start2":6099,"length1":28,"length2":24},{"diffs":[[0,"(message.path);\n"],[-1,"    "],[0,"                "]],"start1":6147,"start2":6147,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"  "],[-1,"  "],[0,"if (message.isFo"]],"start1":6240,"start2":6240,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    "],[0,"fromPath += "]],"start1":6301,"start2":6301,"length1":28,"length2":24},{"diffs":[[0,"        "],[-1,"   "],[-1," "],[0,"toPath +"]],"start1":6360,"start2":6360,"length1":20,"length2":16},{"diffs":[[0,"            "],[-1,"    }\n\n   "],[1,"}\n\n"],[0,"            "]],"start1":6405,"start2":6405,"length1":34,"length2":27},{"diffs":[[0,"                "],[-1," "],[0,"fs.exists(fromPa"]],"start1":6424,"start2":6424,"length1":33,"length2":32},{"diffs":[[0,"            "],[-1,"    "],[0,"if (!fromPat"]],"start1":6499,"start2":6499,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"   "],[-1," "],[0,"return;\n    "]],"start1":6550,"start2":6550,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"    }\n   "],[1,"}\n"],[0,"            "]],"start1":6582,"start2":6582,"length1":33,"length2":26},{"diffs":[[0,"                "],[-1," "],[0,"fs.exists(Path.d"]],"start1":6604,"start2":6604,"length1":33,"length2":32},{"diffs":[[0,"            "],[-1,"    "],[0,"var renameFn"]],"start1":6693,"start2":6693,"length1":28,"length2":24},{"diffs":[[0," = function() {\n"],[-1,"    "],[0,"                "]],"start1":6717,"start2":6717,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"if (err) {\n     "]],"start1":6829,"start2":6829,"length1":36,"length2":32},{"diffs":[[0,"     if (err) {\n"],[-1,"    "],[0,"                "]],"start1":6840,"start2":6840,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":6987,"start2":6987,"length1":34,"length2":26},{"diffs":[[0,"            "],[-1,"    };\n\n    "],[1,"};\n\n"],[0,"            "]],"start1":7053,"start2":7053,"length1":36,"length2":28},{"diffs":[[0,"                "],[-1,"    "],[0,"renameFn();\n    "]],"start1":7133,"start2":7133,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"}\n              "]],"start1":7173,"start2":7173,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"else {\n"],[-1,"    "],[0,"            "]],"start1":7207,"start2":7207,"length1":39,"length2":31},{"diffs":[[0,"                "],[-1," "],[-1,"   "],[0,"if (!err) {\n    "]],"start1":7326,"start2":7326,"length1":36,"length2":32},{"diffs":[[0,"if (!err) {\n"],[-1,"    "],[0,"            "]],"start1":7342,"start2":7342,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":7430,"start2":7430,"length1":34,"length2":26},{"diffs":[[0,"    "],[-1," "],[-1,"   }\n                            });"],[1,"}"],[0,"\n   "]],"start1":7504,"start2":7504,"length1":45,"length2":9},{"diffs":[[0,"    "],[-1,"    break;\n                }"],[1,"});\n                    break;"],[0,"\n   "]],"start1":7554,"start2":7554,"length1":36,"length2":38}]],"length":19182,"saved":false}
{"ts":1349266811047,"patch":[[{"diffs":[[0,"his."],[-1,"command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\" || !message.subCommand) {\n                return false;\n            }\n\n            var self = this;\n            var _error = function(msg) {\n                self.broadcastError(message.subCommand, msg, user);\n            };\n\n            switch (message.subCommand) {\n                // Directly save a revision. The revision has been precomputed\n                // on the client as is merely passed to the server in order to\n                // save it.\n                case \"saveRevision\":\n        "],[1,"onSaveRevision = function(user, message, client) {\n"],[0,"    "]],"start1":1487,"start2":1487,"length1":618,"length2":59},{"diffs":[[0,"            "],[-1,"        "],[0,"return _erro"]],"start1":1579,"start2":1579,"length1":32,"length2":24},{"diffs":[[0,"        "],[-1,"        }\n\n     "],[1,"}\n\n"],[0,"        "]],"start1":1647,"start2":1647,"length1":32,"length2":19},{"diffs":[[0,"            "],[-1,"   "],[0,"this.savingQ"]],"start1":1658,"start2":1658,"length1":27,"length2":24},{"diffs":[[0,"            "],[-1,"       "],[-1," "],[0,"path: messag"]],"start1":1698,"start2":1698,"length1":32,"length2":24},{"diffs":[[0,"ssage.path,\n"],[-1,"        "],[0,"            "]],"start1":1718,"start2":1718,"length1":32,"length2":24},{"diffs":[[0,"        "],[-1," "],[-1,"       "],[0,"}, funct"]],"start1":1777,"start2":1777,"length1":24,"length2":16},{"diffs":[[0,"            "],[-1,"        "],[0,"if (err) {\n "]],"start1":1822,"start2":1822,"length1":32,"length2":24},{"diffs":[[0,"            "],[-1,"     "],[-1,"   "],[0,"return _erro"]],"start1":1853,"start2":1853,"length1":32,"length2":24},{"diffs":[[0,"        "],[-1,"        }\n\n        "],[1,"}\n\n"],[0,"        "]],"start1":1904,"start2":1904,"length1":35,"length2":19},{"diffs":[[0,"            "],[-1," "],[-1,"       "],[0,"if (message."]],"start1":1999,"start2":1999,"length1":32,"length2":24},{"diffs":[[0,"=== true) {\n"],[-1,"        "],[0,"            "]],"start1":2049,"start2":2049,"length1":32,"length2":24},{"diffs":[[0,"            "],[-1,"      "],[-1,"  "],[0,"if (_err) {\n"]],"start1":2161,"start2":2161,"length1":32,"length2":24},{"diffs":[[0,"if (_err) {\n"],[-1,"        "],[0,"            "]],"start1":2173,"start2":2173,"length1":32,"length2":24},{"diffs":[[0,"            "],[-1,"        "],[0,"}\n\n         "]],"start1":2303,"start2":2303,"length1":32,"length2":24},{"diffs":[[0,"            "],[-1,"  "],[-1,"      "],[0,"self.broadca"]],"start1":2330,"start2":2330,"length1":32,"length2":24},{"diffs":[[0,"            "],[-1,"        "],[0,"path: messag"]],"start1":2409,"start2":2409,"length1":32,"length2":24},{"diffs":[[0,"        "],[-1,"       "],[-1," "],[0,"});\n"],[-1,"        "],[0,"        "]],"start1":2456,"start2":2456,"length1":36,"length2":20},{"diffs":[[0,"            "],[-1,"        }\n   "],[1,"}\n"],[0,"            "]],"start1":2496,"start2":2496,"length1":37,"length2":26},{"diffs":[[0,"  }\n            "],[-1,"     "],[0,"});\n            "]],"start1":2506,"start2":2506,"length1":37,"length2":32},{"diffs":[[0,"    "],[-1,"            break;\n\n                // The client requests the history of revisions for a particular\n                // document (indicated by `path`). The client might also want the\n                // original contents of that file (the ones where diffs are applied\n                // in order to get the current file).\n                case \"getRevisionHistory\":\n        "],[1,"};\n\n        this.onGetRevisionHistory = function(user, message, client) {\n"],[0,"    "]],"start1":2530,"start2":2530,"length1":380,"length2":82},{"diffs":[[0,"            "],[-1," "],[-1,"       "],[0,"return _erro"]],"start1":2645,"start2":2645,"length1":32,"length2":24},{"diffs":[[0,"        "],[-1,"        }\n\n     "],[1,"}\n\n"],[0,"        "]],"start1":2705,"start2":2705,"length1":32,"length2":19},{"diffs":[[0," }\n\n            "],[-1,"   "],[0,"this.getRevision"]],"start1":2712,"start2":2712,"length1":35,"length2":32},{"diffs":[[0,", revObj) {\n"],[-1,"        "],[0,"            "]],"start1":2772,"start2":2772,"length1":32,"length2":24},{"diffs":[[0,"            "],[-1,"        "],[0,"return _erro"]],"start1":2819,"start2":2819,"length1":32,"length2":24},{"diffs":[[0,"        "],[-1,"  "],[-1,"      "],[0,"\" for th"]],"start1":2910,"start2":2910,"length1":24,"length2":16},{"diffs":[[0,"        "],[-1,"        }\n\n      "],[1,"}\n\n"],[0,"        "]],"start1":2974,"start2":2974,"length1":33,"length2":19},{"diffs":[[0,"                "],[-1,"  "],[0,"self.broadcastRe"]],"start1":2985,"start2":2985,"length1":34,"length2":32},{"diffs":[[0,"        "],[-1,"        "],[0,"id: mess"]],"start1":3064,"start2":3064,"length1":24,"length2":16},{"diffs":[[0,"            "],[-1," "],[-1,"       "],[0,"nextAction: "]],"start1":3104,"start2":3104,"length1":32,"length2":24},{"diffs":[[0,"            "],[-1,"   "],[-1,"     "],[0,"path: messag"]],"start1":3156,"start2":3156,"length1":32,"length2":24},{"diffs":[[0,"        "],[-1,"        });\n       "],[1,"});\n"],[0,"        "]],"start1":3195,"start2":3195,"length1":35,"length2":20},{"diffs":[[0,"});\n            "],[-1," "],[0,"});\n            "]],"start1":3203,"start2":3203,"length1":33,"length2":32},{"diffs":[[0,"    "],[-1,"            break;\n\n                case \"getRealFileContents\":\n        "],[1,"};\n\n        this.onGetRealFileContents = function(user, message, client) {\n"],[0,"    "]],"start1":3227,"start2":3227,"length1":80,"length2":83},{"diffs":[[0,"            "],[-1,"    "],[-1,"    "],[0,"if (err) {\n "]],"start1":3379,"start2":3379,"length1":32,"length2":24},{"diffs":[[0," if (err) {\n"],[-1,"        "],[0,"            "]],"start1":3390,"start2":3390,"length1":32,"length2":24},{"diffs":[[0,"he file \" +\n"],[-1,"        "],[0,"            "]],"start1":3483,"start2":3483,"length1":32,"length2":24},{"diffs":[[0,"        "],[-1,"        }\n\n        "],[1,"}\n\n"],[0,"        "]],"start1":3563,"start2":3563,"length1":35,"length2":19},{"diffs":[[0,"            "],[-1,"    "],[-1,"    "],[0,"type: \"revis"]],"start1":3634,"start2":3634,"length1":32,"length2":24},{"diffs":[[0,"\"revision\",\n"],[-1,"        "],[0,"            "]],"start1":3652,"start2":3652,"length1":32,"length2":24},{"diffs":[[0,"    "],[-1,"        path: message.path,\n                              nextAction: message.nextAction,"],[1,"path: message.path,\n                      nextAction: message.nextAction,\n                      contents: data\n                  }));\n            });\n        };\n\n        this.command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\" || !message.subCommand) {\n                return false;\n            }\n\n            var self = this;\n            var _error = function(msg) {\n                self.broadcastError(message.subCommand, msg, user);\n            };\n\n            switch (message.subCommand) {\n                // Directly save a revision. The revision has been precomputed\n                // on the client as is merely passed to the server in order to\n                // save it.\n                case \"saveRevision\":\n                    self.onSaveRevision.call(self, user, message, client);"],[0,"\n   "]],"start1":3736,"start2":3736,"length1":97,"length2":859},{"diffs":[[0,"                "],[1,"break;\n\n"],[0,"          conten"]],"start1":4596,"start2":4596,"length1":32,"length2":40},{"diffs":[[0,"    "],[-1,"contents: data\n                          }));\n                    }"],[1,"      // The client requests the history of revisions for a particular\n                // document (indicated by `path`). The client might also want the\n                // original contents of that file (the ones where diffs are applied\n                // in order to get the current file).\n                case \"getRevisionHistory\":\n                    self.onGetRevisionHistory.call(self, user, message, client);\n                    break;\n\n                case \"getRealFileContents\":\n                    self.onGetRealFileContents.call(self, user, message, client"],[0,");\n "]],"start1":4626,"start2":4626,"length1":75,"length2":574}]],"length":19269,"saved":false}
{"ts":1349267030228,"patch":[[{"diffs":[[0," message, client"],[1,", _error"],[0,") {\n"],[-1,""],[0,"            if ("]],"start1":1522,"start2":1522,"length1":36,"length2":44},{"diffs":[[0," message, client"],[1,", _error"],[0,") {\n            "]],"start1":2596,"start2":2596,"length1":32,"length2":40},{"diffs":[[0," message, client"],[1,", _error"],[0,") {\n            "]],"start1":3302,"start2":3302,"length1":32,"length2":40},{"diffs":[[0,"});\n        };\n\n"],[1,"        this.onRemoveRevision = function(user, message, client, _error) {\n            if (!message.path) {\n                return _error(\"No path sent for the file to be removed\");\n            }\n\n            var path = this.getRevisionsPath(message.path);\n            if (message.isFolder === true) {\n                fs.rmdir(path, { recursive: true }, function() {});\n            }\n            else {\n                fs.unlink(path + \".\" + FILE_SUFFIX);\n            }\n        }\n\n"],[0,"        this.com"]],"start1":3910,"start2":3910,"length1":32,"length2":512},{"diffs":[[0,"n\":\n"],[-1,"                    if (!message.path) {\n                        return _error(\"No path sent for the file to be removed\");\n                    }\n\n                    var path = this.getRevisionsPath(message.path);\n                    if (message.isFolder === true) {\n                        fs.rmdir(path, { recursive: true }, function() {});\n                    }\n                    else {\n                        fs.unlink(path + \".\" + FILE_SUFFIX);\n                    }"],[0,"\n   "]],"start1":5965,"start2":5965,"length1":482,"length2":8}]],"length":19299,"saved":false}
{"ts":1349267037840,"patch":[[{"diffs":[[0,"     }\n        }"],[1,";"],[0,"\n\n        this.c"]],"start1":4388,"start2":4388,"length1":32,"length2":33}]],"length":19300,"saved":false}
{"ts":1349267087429,"patch":[[{"diffs":[[0,"ision\":\n"],[1,"                    self.onRemoveRevision.call(self, user, message, client);"],[0,"\n       "]],"start1":5962,"start2":5962,"length1":16,"length2":92}]],"length":19376,"saved":false}
{"ts":1349267218988,"patch":[[{"diffs":[[0,"r, message, "],[-1,"client, "],[0,""],[1,""],[0,"_error) {\n  "]],"start1":1520,"start2":1520,"length1":32,"length2":24},{"diffs":[[0,"r, message, "],[-1,"client, "],[0,""],[1,""],[0,"_error) {\n  "]],"start1":2586,"start2":2586,"length1":32,"length2":24},{"diffs":[[0,"r, message, "],[-1,"client, "],[0,""],[1,""],[0,"_error) {\n  "]],"start1":3284,"start2":3284,"length1":32,"length2":24},{"diffs":[[0,"ge, "],[-1,"client, "],[0,""],[1,""],[0,"_err"]],"start1":3954,"start2":3954,"length1":16,"length2":8},{"diffs":[[0,"  }\n        };\n\n"],[1,"        this.onMoveRevision = function(user, message, _error) {\n            if (!message.path || !message.newPath) {\n                return _error(\"Not enough paths sent for the file to be moved\");\n            }\n\n            var fromPath = this.getRevisionsPath(message.path);\n            var toPath = this.getRevisionsPath(message.newPath);\n            if (message.isFolder !== true) {\n                fromPath += \".\" + FILE_SUFFIX;\n                toPath += \".\" + FILE_SUFFIX;\n            }\n\n            fs.exists(fromPath, function(fromPathExists) {\n                if (!fromPathExists) {\n                    return;\n                }\n                fs.exists(Path.dirname(toPath), function(toPathExists) {\n                    var renameFn = function() {\n                        fs.rename(fromPath, toPath, function(err) {\n                            if (err) {\n                                _error(\"There was an error moving \" + fromPath + \" to \" + toPath);\n                            }\n                        });\n                    };\n\n                    if (toPathExists) {\n                        renameFn();\n                    }\n                    else {\n                        fs.mkdirP(Path.dirname(toPath), function(err) {\n                            if (!err) {\n                                renameFn();\n                            }\n                        });\n                    }\n                });\n            });\n        };\n\n"],[0,"        this.com"]],"start1":4359,"start2":4359,"length1":32,"length2":1488},{"diffs":[[0," user, message, "],[-1,"client"],[1,"_error"],[0,");\n             "]],"start1":6496,"start2":6496,"length1":38,"length2":38},{"diffs":[[0," user, message, "],[-1,"client"],[1,"_error"],[0,");\n             "]],"start1":6949,"start2":6949,"length1":38,"length2":38},{"diffs":[[0," user, message, "],[-1,"client"],[1,"_error"],[0,");\n             "]],"start1":7103,"start2":7103,"length1":38,"length2":38},{"diffs":[[0,"essage, "],[-1,"client"],[1,"_error"],[0,");\n     "]],"start1":7454,"start2":7454,"length1":22,"length2":22},{"diffs":[[0,"    "],[-1,"if (!message.path || !message.newPath) {\n                        return _error(\"Not enough paths sent for the file to be moved\");\n                    }\n\n                    var fromPath = this.getRevisionsPath(message.path);\n                    var toPath = this.getRevisionsPath(message.newPath);\n                    if (message.isFolder !== true) {\n                        fromPath += \".\" + FILE_SUFFIX;\n                        toPath += \".\" + FILE_SUFFIX;\n                    }\n\n                    fs.exists(fromPath, function(fromPathExists) {\n                        if (!fromPathExists) {\n                            return;\n                        }\n                        fs.exists(Path.dirname(toPath), function(toPathExists) {\n                            var renameFn = function() {\n                                fs.rename(fromPath, toPath, function(err) {\n                                    if (err) {\n                                        _error(\"There was an error moving \" + fromPath + \" to \" + toPath);\n                                    }\n                                });\n                            };\n\n                            if (toPathExists) {\n                                renameFn();\n                            }\n                            else {\n                                fs.mkdirP(Path.dirname(toPath), function(err) {\n                                    if (!err) {\n                                        renameFn();\n                                    }\n                                });\n                            }\n                        });\n                    }"],[1,"self.onmoveRevision.call(self, user, message, _error"],[0,");\n "]],"start1":7552,"start2":7552,"length1":1629,"length2":60}]],"length":19231,"saved":false}
{"ts":1349267796226,"patch":[[{"diffs":[[0,"        if ("],[1,"!"],[0,"lines.length"]],"start1":8477,"start2":8477,"length1":24,"length2":25},{"diffs":[[0,".length)"],[-1," {"],[0,"\n    "],[1,"                return;\n\n"],[0,"        "]],"start1":8495,"start2":8495,"length1":23,"length2":46},{"diffs":[[0,"                "],[-1,"    "],[0,"function () {\n  "]],"start1":8567,"start2":8567,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"return lineC"]],"start1":8609,"start2":8609,"length1":28,"length2":24},{"diffs":[[0,"                "],[-1,"    "],[0,"},\n             "]],"start1":8668,"start2":8668,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1," "],[-1,"   "],[0,"function (next) "]],"start1":8691,"start2":8691,"length1":36,"length2":32},{"diffs":[[0,"nction (next) {\n"],[-1,"    "],[0,"                "]],"start1":8709,"start2":8709,"length1":36,"length2":32},{"diffs":[[0,"            "],[-1," "],[-1,"   "],[0,"if (line) {\n"]],"start1":8790,"start2":8790,"length1":28,"length2":24},{"diffs":[[0,"    "],[-1,"    "],[0,"try {\n"],[-1,"    "],[0,"    "]],"start1":8838,"start2":8838,"length1":22,"length2":14},{"diffs":[[0,"            "],[-1,"    "],[0,"revObj[revis"]],"start1":8933,"start2":8933,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1," "],[-1,"   }\n    "],[1,"}\n"],[0,"            "]],"start1":8993,"start2":8993,"length1":34,"length2":26},{"diffs":[[0," catch(e) {\n"],[-1,"    "],[0,"            "]],"start1":9034,"start2":9034,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"    }\n  "],[1,"}\n"],[0,"            "]],"start1":9105,"start2":9105,"length1":32,"length2":26},{"diffs":[[0,"            "],[-1,"  }\n    "],[1,"}\n"],[0,"            "]],"start1":9131,"start2":9131,"length1":32,"length2":26},{"diffs":[[0,"                "],[-1,"    "],[0,"next();\n        "]],"start1":9190,"start2":9190,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"    "],[0,"},\n             "]],"start1":9218,"start2":9218,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"  "],[-1,"  "],[0,"function (e) {\n "]],"start1":9241,"start2":9241,"length1":36,"length2":32},{"diffs":[[0,"ction (e) {\n"],[-1,"    "],[0,"            "]],"start1":9260,"start2":9260,"length1":28,"length2":24},{"diffs":[[0,"            "],[-1,"    }\n    "],[1,"}\n"],[0,"            "]],"start1":9329,"start2":9329,"length1":34,"length2":26},{"diffs":[[0,"     );\n"],[-1,"                }\n"],[0,"        "]],"start1":9354,"start2":9354,"length1":34,"length2":16},{"diffs":[[0,"UFFIX);\n"],[-1,"\n"],[0,"        "]],"start1":10701,"start2":10701,"length1":17,"length2":16},{"diffs":[[0,"function"],[-1," "],[0,"(exists)"]],"start1":10816,"start2":10816,"length1":17,"length2":16}]],"length":19151,"saved":false}
{"ts":1349267844370,"patch":[[{"diffs":[[0,"       }"],[1,"\n               "],[0," else {\n"]],"start1":17989,"start2":17989,"length1":16,"length2":32}]],"length":19167,"saved":false}
{"ts":1349269023820,"patch":[[{"diffs":[[0,"Info"],[-1,");\n            });\n        }, 1);"],[1,", data.user, data.message, data._error);\n            });\n        }, 1);\n\n        this.onRevisionSaved = function(err, revisionInfo, user, message, _error) {\n            if (err) {\n                return _error(err.toString());\n            }\n\n            self.broadcastConfirmSave(message.path, revisionInfo.revision);\n            if (message.forceRevisionListResponse === true) {\n                self.getAllRevisions(revisionInfo.absPath, function(_err, revObj) {\n                    if (_err) {\n                        return _error(\"Error retrieving revisions for file \" + revisionInfo.absPath);\n                    }\n\n                    self.broadcastRevisions.call(self, revObj, user, {\n                        path: message.path\n                    });\n                });\n            }\n        }"],[0,"\n\n  "]],"start1":1439,"start2":1439,"length1":41,"length2":810}]],"length":19936,"saved":false}
{"ts":1349269137470,"patch":[[{"diffs":[[0,"o, data."],[1,"_"],[0,"user, da"]],"start1":1442,"start2":1442,"length1":16,"length2":17},{"diffs":[[0,"r, data."],[1,"_"],[0,"message,"]],"start1":1454,"start2":1454,"length1":16,"length2":17},{"diffs":[[0,"message.revision"],[1,",\n                _user: user,\n                _message: message,\n                _error: _error"],[0,"\n            }, "]],"start1":2527,"start2":2527,"length1":32,"length2":128}]],"length":20034,"saved":false}
{"ts":1349269189668,"patch":[[{"diffs":[[0,"     }\n        }"],[1,";"],[0,"\n"],[-1,""],[0,"\n        this.on"]],"start1":2231,"start2":2231,"length1":33,"length2":34},{"diffs":[[0," }, "],[-1,"function(err, revisionInfo) {\n                if (err) {\n                    return _error(err.toString());\n                }\n\n                self.broadcastConfirmSave(message.path, revisionInfo.revision);\n                if (message.forceRevisionListResponse === true) {\n                    self.getAllRevisions(revisionInfo.absPath, function(_err, revObj) {\n                        if (_err) {\n                            return _error(\"Error retrieving revisions for file \" + revisionInfo.absPath);\n                        }\n\n                        self.broadcastRevisions.call(self, revObj, user, {\n                            path: message.path\n                        });\n                    });\n                }\n            }"],[1,"self.onRevisionSaved"],[0,");\n "]],"start1":2652,"start2":2652,"length1":743,"length2":28}]],"length":19320,"saved":false}
{"ts":1349269236602,"patch":[[{"diffs":[[0,"on(data."],[1,"message."],[0,"path, da"]],"start1":1342,"start2":1342,"length1":16,"length2":24},{"diffs":[[0,"h, data."],[1,"message"],[0,"revision"]],"start1":1361,"start2":1361,"length1":16,"length2":23},{"diffs":[[0,"    "],[-1," path:"],[0," message"],[-1,".path,\n                revision: message.revision,\n                _user: user,\n                _message: message"],[1,": message,\n                _user: user"],[0,",\n  "]],"start1":2492,"start2":2492,"length1":135,"length2":54}]],"length":19254,"saved":false}
{"ts":1349269424134,"patch":[[{"diffs":[[0,"    "],[-1,"self.saveSingleRevision(data.message.path, data.message"],[1,"var msg = data.message;\n            self.saveSingleRevision(msg.path, msg."],[0,"revi"]],"start1":1317,"start2":1317,"length1":63,"length2":82},{"diffs":[[0,"er, "],[-1,"data._message"],[1,"msg"],[0,", da"]],"start1":1487,"start2":1487,"length1":21,"length2":11},{"diffs":[[0,"esponse "],[-1,"="],[1,"!"],[0,"== true)"],[-1," {"],[0,"\n    "],[1,"            return;\n\n"],[0,"        "]],"start1":1829,"start2":1829,"length1":32,"length2":51},{"diffs":[[0,"            "],[-1,"  "],[-1,"  "],[0,"if (_err) {\n"]],"start1":1956,"start2":1956,"length1":28,"length2":24},{"diffs":[[0,"if (_err) {\n"],[-1,"    "],[0,"            "]],"start1":1968,"start2":1968,"length1":28,"length2":24},{"diffs":[[0,"file \" +"],[1,"\n                       "],[0," revisio"]],"start1":2046,"start2":2046,"length1":16,"length2":40},{"diffs":[[0,"Info.absPath"],[-1,");\n    "],[1," + \"\\n\" + _err);\n"],[0,"            "]],"start1":2087,"start2":2087,"length1":31,"length2":41},{"diffs":[[0,"             }\n\n"],[-1,"    "],[0,"                "]],"start1":2119,"start2":2119,"length1":36,"length2":32},{"diffs":[[0,"                "],[-1,"  "],[-1,"  "],[0,"path: message.pa"]],"start1":2206,"start2":2206,"length1":36,"length2":32},{"diffs":[[0,"ath\n"],[-1,"                    });\n"],[0,"    "]],"start1":2237,"start2":2237,"length1":32,"length2":8},{"diffs":[[0,");\n            }"],[-1,""],[0,""],[1,");"],[0,"\n        };\n\n   "]],"start1":2258,"start2":2258,"length1":32,"length2":34}]],"length":19278,"saved":false}
{"ts":1349269439325,"patch":[[{"diffs":[[0,"\\n\" + err);\n"],[-1,"\n"],[0,"            "]],"start1":3651,"start2":3651,"length1":25,"length2":24}]],"length":19277,"saved":false}
{"ts":1349269461836,"patch":[[{"diffs":[[0,"workspace);\n"],[1,"\n"],[0,"        var "]],"start1":1062,"start2":1062,"length1":24,"length2":25}]],"length":19278,"saved":false}
{"ts":1349269470171,"patch":[[{"diffs":[[0,"if (err)"],[1,"\n           "],[0," return "]],"start1":834,"start2":834,"length1":16,"length2":28}]],"length":19290,"saved":false}
{"contributors":[],"silentsave":false,"ts":1349270030859,"patch":[[{"diffs":[[0,"    "],[-1,"imports.sandbox.getProjectDir(function(err, projectDir) {\n        if (err)\n            return register(err);\n\n        fs = fsnode(imports.vfs, projectDir);\n        imports.ide.register(name, RevisionsPlugin, register);\n    });\n\n    "],[0,""],[1,""],[0,"func"]],"start1":764,"start2":764,"length1":240,"length2":8},{"diffs":[[0,"space);\n"],[-1,"\n"],[0,"        "]],"start1":846,"start2":846,"length1":17,"length2":16},{"diffs":[[0,") {\n"],[-1,"            var msg = data.message;\n"],[0,"    "]],"start1":1085,"start2":1085,"length1":44,"length2":8},{"diffs":[[0,"ion("],[-1,"msg"],[1,"data"],[0,".path, "],[-1,"msg"],[1,"data"],[0,".rev"]],"start1":1121,"start2":1121,"length1":21,"length2":23},{"diffs":[[0,"Info"],[-1,", data._user, msg, data._error);\n            });\n"],[1,");\n            });\n        }, 1);\n    }\n\n    require(\"util\").inherits(RevisionsPlugin, Plugin);\n\n    (function() {\n        this.command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\") {\n                return false;\n            }\n\n            var self = this;\n            if (message.subCommand) {\n                var _error = function(msg) {\n                    self.broadcastError(message.subCommand, msg, user);\n    "],[0,"        "],[-1,"}, 1)"],[1,"    }"],[0,";\n\n "]],"start1":1219,"start2":1219,"length1":70,"length2":497},{"diffs":[[0,"    "],[1," "],[-1,"this.onRevisionSaved = function(err, revisionInfo, user, message, _error) {\n"],[1,"       switch (message.subCommand) {\n                    // Directly save a revision. The revision has been precomputed\n                    // on the client as is merely passed to the server in order to\n                    // save it.\n                    case \"saveRevision\":\n                        if (!message.path) {\n                            return _error(\"No path sent for the file to save\");\n                        }\n\n                        this.savingQueue.push({\n                            path: message.path,\n                            revision: message.revision\n                        }, function(err, revisionInfo) {\n                "],[0,"    "]],"start1":1719,"start2":1719,"length1":84,"length2":661},{"diffs":[[0,"                "],[1," "],[1,"               "],[0,"return _error(er"]],"start1":2399,"start2":2399,"length1":32,"length2":48},{"diffs":[[0,"));\n            "],[-1,"}\n\n"],[1,"                }\n\n      "],[0,"            self"]],"start1":2458,"start2":2458,"length1":35,"length2":57},{"diffs":[[0,"                "],[1,"          "],[0,"self.broadcastCo"]],"start1":2495,"start2":2495,"length1":32,"length2":42},{"diffs":[[0,"n);\n            "],[1,"        "],[1,"        "],[0,"if (message.forc"]],"start1":2581,"start2":2581,"length1":32,"length2":48},{"diffs":[[0,"esponse "],[-1,"!"],[0,"=="],[1,"="],[0," true)"],[1," {"],[0,"\n       "]],"start1":2643,"start2":2643,"length1":25,"length2":27},{"diffs":[[0,"            "],[-1,"return;\n\n"],[1,"    "],[0,"            "]],"start1":2667,"start2":2667,"length1":33,"length2":28},{"diffs":[[0,"_err, revObj) {\n"],[1,"                    "],[0,"                "]],"start1":2747,"start2":2747,"length1":32,"length2":52},{"diffs":[[0,"                "],[1,"          "],[1,"          "],[0,"return _error(\"E"]],"start1":2815,"start2":2815,"length1":32,"length2":52},{"diffs":[[0,"ons for file \" +"],[1," revisionInfo.absPath);"],[0,"\n               "]],"start1":2889,"start2":2889,"length1":32,"length2":55},{"diffs":[[0,"    "],[-1,"revisionInfo.absPath + \"\\n\" + _err);"],[1,"            }\n"],[0,"\n   "]],"start1":2949,"start2":2949,"length1":44,"length2":22},{"diffs":[[0,"                "],[-1,"}\n\n"],[1,"    "],[0,"                "]],"start1":2968,"start2":2968,"length1":35,"length2":36},{"diffs":[[0,"revObj, user, {\n"],[1,"                    "],[0,"                "]],"start1":3039,"start2":3039,"length1":32,"length2":52},{"diffs":[[0,"                "],[1,"         "],[-1,"});\n"],[1,"           });\n                    "],[0,"            });\n"]],"start1":3114,"start2":3114,"length1":36,"length2":76},{"diffs":[[0,"    "],[-1,"};\n\n"],[0,"        "],[-1,"this.onSaveRevision = function(user, message, _error) {\n            if (!message.path) {\n                return _error(\"No path sent for the file to save\");"],[1,"            }\n                        });\n                        break;\n"],[0,"\n   "]],"start1":3194,"start2":3194,"length1":176,"length2":89},{"diffs":[[0,"    "],[-1,"}\n\n"],[0,"        "],[-1,"    this.savingQueue.push({\n                message: message,\n                _user: user,\n                _error: _error\n            }, self.onRevisionSaved);"],[1,"// The client requests the history of revisions for a particular\n                    // document (indicated by `path`). The client might also want the\n                    // original contents of that file (the ones where diffs are applied\n                    // in order to get the current file)."],[0,"\n   "]],"start1":3288,"start2":3288,"length1":178,"length2":312},{"diffs":[[0,"        "],[-1,"};\n\n"],[1,"    "],[0,"        "],[-1,"this.onG"],[1,"case \"g"],[0,"etRevisi"]],"start1":3597,"start2":3597,"length1":36,"length2":35},{"diffs":[[0,"tory"],[-1," = function(user, message, _error) {\n"],[1,"\":\n            "],[0,"    "]],"start1":3637,"start2":3637,"length1":45,"length2":23},{"diffs":[[0,"message.path) {\n"],[1,"            "],[0,"                "]],"start1":3673,"start2":3673,"length1":32,"length2":44},{"diffs":[[0,"\");\n            "],[1,"    "],[-1,"}\n\n"],[1,"        }\n\n            "],[0,"            this"]],"start1":3757,"start2":3757,"length1":35,"length2":59},{"diffs":[[0,"                "],[1,"            "],[0,"if (err) {\n     "]],"start1":3868,"start2":3868,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"     "],[1,"       "],[0,"return _error(\"T"]],"start1":3911,"start2":3911,"length1":32,"length2":44},{"diffs":[[0,"        "],[1,"           "],[1," "],[0,"\" for th"]],"start1":4018,"start2":4018,"length1":16,"length2":28},{"diffs":[[0,"                "],[-1,"}\n\n"],[1,"            }\n\n     "],[0,"                "]],"start1":4086,"start2":4086,"length1":35,"length2":52},{"diffs":[[0,"                "],[1,"       "],[0,"self.broadcastRe"]],"start1":4122,"start2":4122,"length1":32,"length2":39},{"diffs":[[0,"revObj, user, {\n"],[1,"            "],[0,"                "]],"start1":4180,"start2":4180,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"            "],[0,"nextAction: mess"]],"start1":4256,"start2":4256,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"      "],[1,"      "],[0,"path: message.pa"]],"start1":4320,"start2":4320,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"            "],[0,"});\n            "]],"start1":4367,"start2":4367,"length1":32,"length2":44},{"diffs":[[0,"    "],[1," "],[-1,"});\n        };\n\n        this.onGetRealFileContents = function(user, message, _error) {\n"],[1,"           });\n                        break;\n\n                    case \"getRealFileContents\":\n            "],[0,"    "]],"start1":4407,"start2":4407,"length1":95,"length2":116},{"diffs":[[0,"                "],[1,"          "],[1,"  "],[0,"if (err) {\n     "]],"start1":4588,"start2":4588,"length1":32,"length2":44},{"diffs":[[0,"     if (err) {\n"],[1,"            "],[0,"                "]],"start1":4611,"start2":4611,"length1":32,"length2":44},{"diffs":[[0,"        "],[1,"    "],[1,"        "],[0,"message."]],"start1":4752,"start2":4752,"length1":16,"length2":28},{"diffs":[[0,"+ \":\\n\" + err);\n"],[1,"\n          "],[0,"                "]],"start1":4785,"start2":4785,"length1":32,"length2":43},{"diffs":[[0,"                "],[1,"  "],[0,"}\n\n"],[1,"            "],[0,"                "]],"start1":4814,"start2":4814,"length1":35,"length2":49},{"diffs":[[0,"                "],[1,"    "],[1,"        "],[0,"type: \"revision\""]],"start1":4903,"start2":4903,"length1":32,"length2":44},{"diffs":[[0,"pe: \"revision\",\n"],[1,"            "],[0,"                "]],"start1":4933,"start2":4933,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"            "],[0,"path: message.pa"]],"start1":5021,"start2":5021,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"     "],[1,"       "],[0,"nextAction: mess"]],"start1":5075,"start2":5075,"length1":32,"length2":44},{"diffs":[[0,"            "],[1,"           "],[1," "],[0,"contents: da"]],"start1":5145,"start2":5145,"length1":24,"length2":36},{"diffs":[[0,"                "],[-1,"}));\n"],[1,"            }));\n     "],[0,"            });\n"]],"start1":5186,"start2":5186,"length1":37,"length2":54},{"diffs":[[0,"                "],[1,"       "],[0,"});\n        };\n\n"]],"start1":5220,"start2":5220,"length1":32,"length2":39},{"diffs":[[0,"    "],[-1,"};\n\n        this.onRemoveRevision = function(user, message, _error) {\n"],[1,"                break;\n\n                    case \"closeFile\":\n                        if (!message.path) {\n                            _error(\"No path sent for the file to be closed\");\n                        }\n                        break;\n\n                    case \"removeRevision\":\n            "],[0,"    "]],"start1":5251,"start2":5251,"length1":78,"length2":306},{"diffs":[[0,"message.path) {\n"],[1,"            "],[0,"                "]],"start1":5570,"start2":5570,"length1":32,"length2":44},{"diffs":[[0,"\");\n            "],[-1,"}\n\n"],[1,"            }\n\n       "],[0,"            var "]],"start1":5668,"start2":5668,"length1":35,"length2":54},{"diffs":[[0,"            "],[1,"     "],[0,"var path = t"]],"start1":5706,"start2":5706,"length1":24,"length2":29},{"diffs":[[0,"(message.path);\n"],[1,"            "],[0,"            if ("]],"start1":5755,"start2":5755,"length1":32,"length2":44},{"diffs":[[0,"            "],[1,"  "],[1,"          "],[0,"fs.rmdir(pat"]],"start1":5832,"start2":5832,"length1":24,"length2":36},{"diffs":[[0,"});\n            "],[1,"        "],[-1,"}\n"],[1,"    }\n      "],[0,"            else"]],"start1":5904,"start2":5904,"length1":34,"length2":52},{"diffs":[[0,"                "],[1,"      "],[0,"else {\n         "]],"start1":5936,"start2":5936,"length1":32,"length2":38},{"diffs":[[0,"        "],[1,"   "],[1,"         "],[0,"fs.unlin"]],"start1":5973,"start2":5973,"length1":16,"length2":28},{"diffs":[[0,"X);\n            "],[1,"         "],[1,"   "],[0,"}\n        };\n\n  "]],"start1":6026,"start2":6026,"length1":32,"length2":44},{"diffs":[[0,"    "],[-1,"};\n\n        this.onMoveRevision = function(user, message, _error) {\n"],[1,"                break;\n\n                    case \"moveRevision\":\n            "],[0,"    "]],"start1":6060,"start2":6060,"length1":76,"length2":85},{"diffs":[[0,"sage.newPath) {\n"],[1,"            "],[0,"                "]],"start1":6178,"start2":6178,"length1":32,"length2":44},{"diffs":[[0,"\");\n            "],[1,"      "],[-1,"}\n\n"],[1,"      }\n\n            "],[0,"            var "]],"start1":6283,"start2":6283,"length1":35,"length2":59},{"diffs":[[0,"            "],[1," "],[1,"           "],[0,"var toPath ="]],"start1":6390,"start2":6390,"length1":24,"length2":36},{"diffs":[[0,"h);\n            "],[1,"       "],[1,"     "],[0,"if (message.isFo"]],"start1":6463,"start2":6463,"length1":32,"length2":44},{"diffs":[[0,"            "],[1,"            "],[0,"fromPath += "]],"start1":6528,"start2":6528,"length1":24,"length2":36},{"diffs":[[0,"        "],[1," "],[1,"           "],[0,"toPath +"]],"start1":6591,"start2":6591,"length1":16,"length2":28},{"diffs":[[0,"IX;\n            "],[1,"       "],[-1,"}\n\n"],[1,"     }\n\n            "],[0,"            fs.e"]],"start1":6636,"start2":6636,"length1":35,"length2":59},{"diffs":[[0,"            "],[1,"            "],[0,"if (!fromPat"]],"start1":6742,"start2":6742,"length1":24,"length2":36},{"diffs":[[0,"                "],[1,"        "],[1,"    "],[0,"return;\n        "]],"start1":6793,"start2":6793,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"          "],[-1,"}\n"],[1,"  }\n            "],[0,"                "]],"start1":6829,"start2":6829,"length1":34,"length2":58},{"diffs":[[0,"            "],[1,"         "],[1,"   "],[0,"var renameFn"]],"start1":6952,"start2":6952,"length1":24,"length2":36},{"diffs":[[0," = function() {\n"],[1,"            "],[0,"                "]],"start1":6988,"start2":6988,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"            "],[0,"if (err) {\n     "]],"start1":7096,"start2":7096,"length1":32,"length2":44},{"diffs":[[0,"                "],[1,"          "],[1,"  "],[0,"_error(\"There wa"]],"start1":7151,"start2":7151,"length1":32,"length2":44},{"diffs":[[0,"            "],[-1,"       }\n"],[0,"            "]],"start1":7255,"start2":7255,"length1":33,"length2":24},{"diffs":[[0,"            "],[-1,"     });"],[1,"}"],[0,"\n           "]],"start1":7274,"start2":7274,"length1":32,"length2":25},{"diffs":[[0,"                "],[-1,"};\n\n"],[0,"                "]],"start1":7292,"start2":7292,"length1":36,"length2":32},{"diffs":[[0,"    "],[-1,"    if (toPathExists) {"],[1,"});"],[0,"\n   "]],"start1":7320,"start2":7320,"length1":31,"length2":11},{"diffs":[[0,"    "],[-1,"renameFn();\n                    }\n                    else {\n                        fs.mkdirP(Path.dirname(toPath), function(err) {\n                            if (!err) {\n"],[1,"        };\n\n                                if (toPathExists) {\n    "],[0,"    "]],"start1":7348,"start2":7348,"length1":181,"length2":76},{"diffs":[[0,"            "],[-1,"             }\n"],[0,"            "]],"start1":7467,"start2":7467,"length1":39,"length2":24},{"diffs":[[0,"            "],[-1,"       });"],[1,"}"],[0,"\n           "]],"start1":7484,"start2":7484,"length1":34,"length2":25},{"diffs":[[0,"                "],[-1,"}\n"],[0,"                "]],"start1":7502,"start2":7502,"length1":34,"length2":32},{"diffs":[[0,"    "],[-1,"    });\n            });\n        };\n\n        this.command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\" || !message.subCommand) {\n                return false;\n            }\n\n            var self = this;\n            var _error = function(msg) {\n                self.broadcastError(message.subCommand, msg, user);\n            };\n\n            switch (message.subCommand) {\n                // Directly save a revision. The revision has been precomputed\n                // on the client as is merely passed to the server in order to\n                // save it.\n                case \"saveRevision\":\n                    self.onSaveRevision.call(self, user, message, _error);"],[1,"else {\n                                    fs.mkdirP(Path.dirname(toPath), function(err) {"],[0,"\n   "]],"start1":7526,"start2":7526,"length1":733,"length2":98},{"diffs":[[0,"            "],[-1,"break;\n\n"],[0,"            "]],"start1":7629,"start2":7629,"length1":32,"length2":24},{"diffs":[[0,"    "],[-1,"// The client requests the history of revisions for a particular\n                // document (indicated by `path`). The client might also want the\n                // original contents of that file (the ones where diffs are applied\n                // in order to get the current file).\n                case \"getRevisionHistory\":\n                    self.onGetRevisionHistory.call(self, user, message, _error"],[1,"    if (!err) {\n                                            renameFn("],[0,");\n "]],"start1":7653,"start2":7653,"length1":414,"length2":77},{"diffs":[[0,"            "],[-1,"break;\n\n"],[0,"            "]],"start1":7737,"start2":7737,"length1":32,"length2":24},{"diffs":[[0,"    "],[-1,"case \"getRealFileContents\":\n"],[1," "],[0,"   "],[1,"}\n"],[0,"    "]],"start1":7761,"start2":7761,"length1":39,"length2":14},{"diffs":[[0,"    "],[-1,"self.onGetRealFileContents.call(self, user, message, _error);\n"],[1,"   "],[0,"    "]],"start1":7784,"start2":7784,"length1":70,"length2":11},{"diffs":[[0,"            "],[-1,"    break;\n"],[1,"});"],[0,"\n           "]],"start1":7795,"start2":7795,"length1":35,"length2":27},{"diffs":[[0,"    "],[-1,"case \"closeFile\":\n                    if (!message.path) {\n                        _error(\"No path sent for the file to be closed\""],[1,"                }\n                            }"],[0,");\n "]],"start1":7823,"start2":7823,"length1":138,"length2":55},{"diffs":[[0,"    "],[-1,"}\n"],[0,"    "],[-1,"                break"],[1,"})"],[0,";\n"],[-1,"\n"],[0,"    "]],"start1":7893,"start2":7893,"length1":38,"length2":16},{"diffs":[[0,"    "],[-1,"case \"removeRevision\":\n                    self.onRemoveRevision.call(self, user, message, _error);\n                    break;\n\n                case \"moveRevision\":\n                    self.onmoveRevision.call(self, user, message, _error);\n                    break;"],[1,"        break;\n                }"],[0,"\n   "]],"start1":7917,"start2":7917,"length1":274,"length2":40},{"diffs":[[0,"    if ("],[-1,"!"],[0,"lines.le"]],"start1":8797,"start2":8797,"length1":17,"length2":16},{"diffs":[[0,"gth)"],[-1,"\n   "],[1," {\n"],[0,"    "],[-1,"             return;\n\n"],[0,"    "]],"start1":8814,"start2":8814,"length1":38,"length2":15},{"diffs":[[0,"                "],[1," "],[1,"   "],[0,"function () {\n  "]],"start1":8859,"start2":8859,"length1":32,"length2":36},{"diffs":[[0,"nction () {\n"],[1,"    "],[0,"            "]],"start1":8881,"start2":8881,"length1":24,"length2":28},{"diffs":[[0,"                "],[-1,"},\n"],[1,"    },\n   "],[0,"                "]],"start1":8968,"start2":8968,"length1":35,"length2":42},{"diffs":[[0,"                "],[1," "],[0,"function (next) "]],"start1":8998,"start2":8998,"length1":32,"length2":33},{"diffs":[[0,"nction (next) {\n"],[1,"    "],[0,"                "]],"start1":9017,"start2":9017,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"  "],[1,"  "],[0,"if (line) {\n    "]],"start1":9098,"start2":9098,"length1":32,"length2":36},{"diffs":[[0,"        "],[1,"    "],[0,"try {\n  "]],"start1":9150,"start2":9150,"length1":16,"length2":20},{"diffs":[[0,"                "],[1," "],[1,"   "],[0,"var revision = J"]],"start1":9184,"start2":9184,"length1":32,"length2":36},{"diffs":[[0,"            "],[1,"    "],[0,"revObj[revis"]],"start1":9257,"start2":9257,"length1":24,"length2":28},{"diffs":[[0,"                "],[1,"   "],[1," "],[0,"}\n"],[1,"    "],[0,"                "]],"start1":9317,"start2":9317,"length1":34,"length2":42},{"diffs":[[0," catch(e) {\n"],[1,"    "],[0,"            "]],"start1":9370,"start2":9370,"length1":24,"length2":28},{"diffs":[[0,"                "],[-1,"}\n"],[1,"    }\n    "],[0,"                "]],"start1":9441,"start2":9441,"length1":34,"length2":42},{"diffs":[[0,"              }\n"],[1,"    "],[0,"                "]],"start1":9477,"start2":9477,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"    "],[0,"next();\n        "]],"start1":9542,"start2":9542,"length1":32,"length2":36},{"diffs":[[0,"                "],[1,"  "],[1,"  "],[0,"},\n"],[1,"    "],[0,"                "]],"start1":9574,"start2":9574,"length1":35,"length2":43},{"diffs":[[0,"ction (e) {\n"],[1,"    "],[0,"            "]],"start1":9624,"start2":9624,"length1":24,"length2":28},{"diffs":[[0,"                "],[-1,"}\n"],[1,"    }\n    "],[0,"                "]],"start1":9693,"start2":9693,"length1":34,"length2":42},{"diffs":[[0,"     );\n"],[1,"                }\n"],[0,"        "]],"start1":9730,"start2":9730,"length1":16,"length2":34},{"diffs":[[0,"+ FILE_SUFFIX);\n"],[1,"\n"],[0,"            var "]],"start1":11087,"start2":11087,"length1":32,"length2":33},{"diffs":[[0,"bsPath, function"],[-1,""],[0,""],[1," "],[0,"(exists) {\n     "]],"start1":11203,"start2":11203,"length1":32,"length2":33},{"diffs":[[0,"       }"],[-1,"\n               "],[0,""],[1,""],[0," else {\n"]],"start1":18385,"start2":18385,"length1":32,"length2":16},{"diffs":[[0,"   }"],[-1,"\n    require(\"util\").inherits("],[1,").call(RevisionsPlugin.prototype);\n\n    imports.sandbox.getProjectDir(function(err, projectDir) {\n        if (err) return register(err);\n\n        fs = fsnode(imports.vfs, projectDir);\n        imports.ide.register(name, "],[0,"Revi"]],"start1":19484,"start2":19484,"length1":38,"length2":227},{"diffs":[[0,"Plugin, "],[-1,"Plugin"],[1,"register);\n    }"],[0,");\n};\n"]],"start1":19716,"start2":19716,"length1":20,"length2":30}]],"length":19746,"saved":false}
{"contributors":[],"silentsave":false,"ts":1349375191791,"patch":[[{"diffs":[[0,"ar fs;\n\n    "],[-1,""],[0,""],[1,"imports.sandbox.getProjectDir(function(err, projectDir) {\n        if (err)\n            return register(err);\n\n        fs = fsnode(imports.vfs, projectDir);\n        imports.ide.register(name, RevisionsPlugin, register);\n    });\n\n    "],[0,"function Rev"]],"start1":756,"start2":756,"length1":24,"length2":256},{"diffs":[[0,"workspace);\n"],[1,"\n"],[0,"        var "]],"start1":1074,"start2":1074,"length1":24,"length2":25},{"diffs":[[0,"ta, callback) {\n"],[1,"            var msg = data.message;\n"],[0,"            self"]],"start1":1306,"start2":1306,"length1":32,"length2":68},{"diffs":[[0,"ion("],[-1,"data"],[1,"msg"],[0,".path, "],[-1,"data"],[1,"msg"],[0,".rev"]],"start1":1390,"start2":1390,"length1":23,"length2":21},{"diffs":[[0,"Info"],[-1,");\n            });\n        }, 1);\n    }\n\n    require(\"util\").inherits(RevisionsPlugin, Plugin);\n\n    (function() {\n        this.command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\") {\n                return false;\n            }\n\n            var self = this;\n            if (message.subCommand) {\n                var _error = function(msg) {\n                    self.broadcastError(message.subCommand, msg, user);\n                };\n\n                switch (message.subCommand) {\n                    // Directly save a revision. The revision has been precomputed\n                    // on the client as is merely passed to the server in order to\n                    // save it.\n                    case \"saveRevision\":\n                        if (!message.path) {\n                            return _error(\"No path sent for the file to save\");\n                        }\n\n                        this.savingQueue.push({\n                            path: message.path,\n                            revision: message.revision\n                        }, function(err, revisionInfo) {\n                "],[1,", data._user, msg, data._error);\n            });\n        }, 1);\n\n        this.onRevisionSaved = function(err, revisionInfo, user, message, _error) {\n"],[0,"    "]],"start1":1486,"start2":1486,"length1":1161,"length2":157},{"diffs":[[0,"        "],[-1,"      "],[-1,"          "],[0,"return _"]],"start1":1670,"start2":1670,"length1":32,"length2":16},{"diffs":[[0,"    "],[-1,"                }\n\n           "],[1,"}\n\n"],[0,"    "]],"start1":1717,"start2":1717,"length1":38,"length2":11},{"diffs":[[0," }\n\n            "],[-1,"     "],[0,"self.broadcastCo"]],"start1":1720,"start2":1720,"length1":37,"length2":32},{"diffs":[[0,"ision);\n"],[-1,"                "],[0,"        "]],"start1":1792,"start2":1792,"length1":32,"length2":16},{"diffs":[[0,"esponse "],[-1,"="],[1,"!"],[0,"== true)"],[-1," {"],[0,"\n       "]],"start1":1842,"start2":1842,"length1":27,"length2":25},{"diffs":[[0,"                "],[-1,"   "],[1,"return;\n\n"],[0,"             sel"]],"start1":1860,"start2":1860,"length1":35,"length2":41},{"diffs":[[0,"n;\n\n            "],[-1," "],[0,"self.getAllRevis"]],"start1":1881,"start2":1881,"length1":33,"length2":32},{"diffs":[[0,"    "],[-1,"                    if (_err) {\n                "],[1,"if (_err) {\n"],[0,"    "]],"start1":1977,"start2":1977,"length1":56,"length2":20},{"diffs":[[0,"                "],[-1,"    "],[0,"return _error(\"E"]],"start1":1997,"start2":1997,"length1":36,"length2":32},{"diffs":[[0," \" +"],[-1," revisionInfo.absPath);"],[0,"\n   "]],"start1":2063,"start2":2063,"length1":31,"length2":8},{"diffs":[[0,"            "],[-1,"            }\n"],[1,"revisionInfo.absPath + \"\\n\" + _err);"],[0,"\n           "]],"start1":2080,"start2":2080,"length1":38,"length2":60},{"diffs":[[0,"                "],[-1,"    "],[1,"}\n\n"],[0,"                "]],"start1":2129,"start2":2129,"length1":36,"length2":35},{"diffs":[[0,"user, {\n"],[-1,"                    "],[0,"        "]],"start1":2207,"start2":2207,"length1":36,"length2":16},{"diffs":[[0,"    "],[-1,"               "],[-1,"     "],[0,"});\n"],[-1,"                    "],[0,"    "]],"start1":2266,"start2":2266,"length1":52,"length2":12},{"diffs":[[0,"    "],[-1,"   "],[1,"};\n\n"],[0,"        "],[-1,"         }\n                        });\n                        break;\n"],[1,"this.onSaveRevision = function(user, message, _error) {\n            if (!message.path) {\n                return _error(\"No path sent for the file to save\");"],[0,"\n   "]],"start1":2294,"start2":2294,"length1":89,"length2":176},{"diffs":[[0,"    "],[1,"}\n\n"],[0,"        "],[-1,"// The client requests the history of revisions for a particular\n                    // document (indicated by `path`). The client might also want the\n                    // original contents of that file (the ones where diffs are applied\n                    // in order to get the current file)."],[1,"    this.savingQueue.push({\n                message: message,\n                _user: user,\n                _error: _error\n            }, self.onRevisionSaved);"],[0,"\n   "]],"start1":2475,"start2":2475,"length1":312,"length2":178},{"diffs":[[0,"        "],[-1,"    "],[1,"};\n\n"],[0,"        "],[-1,"case \"g"],[1,"this.onG"],[0,"etRevisi"]],"start1":2650,"start2":2650,"length1":35,"length2":36},{"diffs":[[0,"nHistory"],[-1,"\":\n            "],[1," = function(user, message, _error) {\n"],[0,"        "]],"start1":2687,"start2":2687,"length1":31,"length2":53},{"diffs":[[0,"age.path) {\n"],[-1,"            "],[0,"            "]],"start1":2753,"start2":2753,"length1":36,"length2":24},{"diffs":[[0,"the file\");\n"],[-1,"            "],[0,"            "]],"start1":2813,"start2":2813,"length1":36,"length2":24},{"diffs":[[0,"        "],[-1," "],[-1,"           "],[0,"this.get"]],"start1":2844,"start2":2844,"length1":28,"length2":16},{"diffs":[[0,"            "],[-1,"        "],[-1,"    "],[0,"if (err) {\n "]],"start1":2912,"start2":2912,"length1":36,"length2":24},{"diffs":[[0," if (err) {\n"],[-1,"            "],[0,"            "]],"start1":2923,"start2":2923,"length1":36,"length2":24},{"diffs":[[0,"        "],[-1,"  "],[-1,"          "],[0,"\" for th"]],"start1":3034,"start2":3034,"length1":28,"length2":16},{"diffs":[[0,"    "],[-1,"         "],[-1,"   }\n\n            "],[1,"}\n\n"],[0,"    "]],"start1":3102,"start2":3102,"length1":35,"length2":11},{"diffs":[[0,"        "],[-1,"   "],[-1,"         "],[0,"id: mess"]],"start1":3188,"start2":3188,"length1":28,"length2":16},{"diffs":[[0,"            "],[-1,"          "],[-1,"  "],[0,"nextAction: "]],"start1":3228,"start2":3228,"length1":36,"length2":24},{"diffs":[[0,"            "],[-1,"            "],[0,"path: messag"]],"start1":3280,"start2":3280,"length1":36,"length2":24},{"diffs":[[0,"    "],[-1,"    "],[-1,"        });\n           "],[1,"});\n"],[0,"    "]],"start1":3323,"start2":3323,"length1":35,"length2":12},{"diffs":[[0,"});\n            "],[-1," "],[0,"});\n            "]],"start1":3327,"start2":3327,"length1":33,"length2":32},{"diffs":[[0,"    "],[-1,"                break;\n\n                    case \"getRealFileContents\":\n            "],[1,"};\n\n        this.onGetRealFileContents = function(user, message, _error) {\n"],[0,"    "]],"start1":3351,"start2":3351,"length1":92,"length2":83},{"diffs":[[0,"            "],[-1,"  "],[-1,"          "],[0,"if (err) {\n "]],"start1":3503,"start2":3503,"length1":36,"length2":24},{"diffs":[[0," if (err) {\n"],[-1,"            "],[0,"            "]],"start1":3514,"start2":3514,"length1":36,"length2":24},{"diffs":[[0,"            "],[-1,"            "],[0,"message.path"]],"start1":3635,"start2":3635,"length1":36,"length2":24},{"diffs":[[0,"\\n\" + err);\n"],[-1,"\n  "],[0,"            "]],"start1":3664,"start2":3664,"length1":27,"length2":24},{"diffs":[[0,"    "],[-1,"          }\n\n            "],[1,"}\n\n"],[0,"    "]],"start1":3690,"start2":3690,"length1":33,"length2":11},{"diffs":[[0,"            "],[-1,"            "],[0,"type: \"revis"]],"start1":3757,"start2":3757,"length1":36,"length2":24},{"diffs":[[0,"            "],[-1,"   "],[-1,"         "],[0,"subtype: \"ge"]],"start1":3797,"start2":3797,"length1":36,"length2":24},{"diffs":[[0,"            "],[-1,"          "],[-1,"  "],[0,"path: messag"]],"start1":3851,"start2":3851,"length1":36,"length2":24},{"diffs":[[0,"ssage.path,\n"],[-1,"            "],[0,"            "]],"start1":3871,"start2":3871,"length1":36,"length2":24},{"diffs":[[0,"            "],[-1,"    "],[-1,"        "],[0,"contents: da"]],"start1":3947,"start2":3947,"length1":36,"length2":24},{"diffs":[[0,"    "],[-1,"           "],[-1," "],[0,"}));\n"],[-1,"            "],[0,"    "]],"start1":3988,"start2":3988,"length1":37,"length2":13},{"diffs":[[0,"    "],[-1,"                break;\n\n                    case \"closeFile\":\n                        if (!message.path) {\n                            _error(\"No path sent for the file to be closed\");\n                        }\n                        break;\n\n                    case \"removeRevision\":\n                        if (!message.path) {\n                            return _error(\"No path sent for the file to be removed\");\n                        }\n\n                        var path = this.getRevisionsPath(message.path);\n                        if (message.isFolder === true) {\n                            fs.rmdir(path, { recursive: true }, function() {});\n                        }\n                        else {\n                            fs.unlink(path + \".\" + FILE_SUFFIX);\n                        }\n                        break;\n\n                    case \"moveRevision\":\n                        if (!message.path || !message.newPath) {\n                            return _error(\"Not enough paths sent for the file to be moved\");\n                        }\n\n                        var fromPath = this.getRevisionsPath(message.path);\n                        var toPath = this.getRevisionsPath(message.newPath);\n                        if (message.isFolder !== true) {\n                            fromPath += \".\" + FILE_SUFFIX;\n                            toPath += \".\" + FILE_SUFFIX;\n                        }\n\n                        fs.exists(fromPath, function(fromPathExists) {\n                            if (!fromPathExists) {\n                                return;\n                            }\n                            fs.exists(Path.dirname(toPath), function(toPathExists) {\n                                var renameFn = function() {\n                                    fs.rename(fromPath, toPath, function(err) {\n                                        if (err) {\n                                            _error(\"There was an error moving \" + fromPath + \" to \" + toPath);\n                                        }\n                                    });\n                                };\n\n                                if (toPathExists) {\n                                    renameFn();\n                                }\n                                else {\n                                    fs.mkdirP(Path.dirname(toPath), function(err) {\n                                        if (!err) {\n                                            renameFn();\n                                        }\n                                    });\n                                }\n                            });\n                        });\n                        break;\n                }\n            }\n            return true;\n        };\n\n        /**\n         * RevisionsPlugin#createEmptyStack(path) -> Object\n         * - path (String): relative path of the file to create revisions for\n         *\n         * Creates an empty revisions object. This function is usually called when\n         * a backup file is not found for the file in the `path`.\n         **/\n        this.createEmptyStack = function() {\n            return { \"revisions\": {} };\n        };\n\n        this.getAllRevisions = function(absPath, callback) {\n            var revObj = {};\n            fs.readFile(absPath, \"utf8\", function(err, data) {\n                if (err) {\n                    return callback(err);\n                }\n\n                var error;\n                var lineCount = 0;\n                var lines = data.toString().split(\"\\n\");\n                if (lines.length) {\n                    Async.whilst(\n                        function () {\n                            return lineCount < lines.length && !error;\n                        },\n                        function (next) {\n                            var line = lines[lineCount];\n                            if (line) {\n                                try {\n                                    var revision = JSON.parse(line);\n                                    revObj[revision.ts] = revision;\n                                }\n                                catch(e) {\n                                    error = e;\n                                }\n                            }\n                            lineCount++;\n                            next();\n                        },\n                        function (e) {\n                            callback(error, revObj);\n                        }\n                    );\n                }"],[1,"};\n\n        this.onRemoveRevision = function(user, message, _error) {\n            if (!message.path) {\n                return _error(\"No path sent for the file to be removed\");\n            }\n\n            var path = this.getRevisionsPath(message.path);\n            if (message.isFolder === true) {\n                fs.rmdir(path, { recursive: true }, function() {});\n            }\n            else {\n                fs.unlink(path + \".\" + FILE_SUFFIX);\n            }\n        };\n\n        this.onMoveRevision = function(user, message, _error) {\n            if (!message.path || !message.newPath) {\n                return _error(\"Not enough paths sent for the file to be moved\");\n            }\n\n            var fromPath = this.getRevisionsPath(message.path);\n            var toPath = this.getRevisionsPath(message.newPath);\n            if (message.isFolder !== true) {\n                fromPath += \".\" + FILE_SUFFIX;\n                toPath += \".\" + FILE_SUFFIX;\n            }\n\n            fs.exists(fromPath, function(fromPathExists) {\n                if (!fromPathExists) {\n                    return;\n                }\n                fs.exists(Path.dirname(toPath), function(toPathExists) {\n                    var renameFn = function() {\n                        fs.rename(fromPath, toPath, function(err) {\n                            if (err) {\n                                _error(\"There was an error moving \" + fromPath + \" to \" + toPath);\n                            }\n                        });\n                    };\n\n                    if (toPathExists) {\n                        renameFn();\n                    }\n                    else {\n                        fs.mkdirP(Path.dirname(toPath), function(err) {\n                            if (!err) {\n                                renameFn();\n                            }\n                        });\n                    }\n                });\n            });\n        };\n\n        this.command = function(user, message, client) {\n            if (!message.command || message.command !== \"revisions\" || !message.subCommand) {\n                return false;\n            }\n\n            var self = this;\n            var _error = function(msg) {\n                self.broadcastError(message.subCommand, msg, user);\n            };\n\n            switch (message.subCommand) {\n                // Directly save a revision. The revision has been precomputed\n                // on the client as is merely passed to the server in order to\n                // save it.\n                case \"saveRevision\":\n                    self.onSaveRevision.call(self, user, message, _error);\n                    break;\n\n                // The client requests the history of revisions for a particular\n                // document (indicated by `path`). The client might also want the\n                // original contents of that file (the ones where diffs are applied\n                // in order to get the current file).\n                case \"getRevisionHistory\":\n                    self.onGetRevisionHistory.call(self, user, message, _error);\n                    break;\n\n                case \"getRealFileContents\":\n                    self.onGetRealFileContents.call(self, user, message, _error);\n                    break;\n\n                case \"closeFile\":\n                    if (!message.path) {\n                        _error(\"No path sent for the file to be closed\");\n                    }\n                    break;\n\n                case \"removeRevision\":\n                    self.onRemoveRevision.call(self, user, message, _error);\n                    break;\n\n                case \"moveRevision\":\n                    self.onmoveRevision.call(self, user, message, _error);\n                    break;\n            }\n            return true;\n        };\n\n        /**\n         * RevisionsPlugin#createEmptyStack(path) -> Object\n         * - path (String): relative path of the file to create revisions for\n         *\n         * Creates an empty revisions object. This function is usually called when\n         * a backup file is not found for the file in the `path`.\n         **/\n        this.createEmptyStack = function() {\n            return { \"revisions\": {} };\n        };\n\n        this.getAllRevisions = function(absPath, callback) {\n            var revObj = {};\n            fs.readFile(absPath, \"utf8\", function(err, data) {\n                if (err) {\n                    return callback(err);\n                }\n\n                var error;\n                var lineCount = 0;\n                var lines = data.toString().split(\"\\n\");\n                if (!lines.length)\n                    return callback(null, revObj);\n\n                Async.whilst(\n                    function () {\n                        return lineCount < lines.length && !error;\n                    },\n                    function (next) {\n                        var line = lines[lineCount];\n                        if (line) {\n                            try {\n                                var revision = JSON.parse(line);\n                                revObj[revision.ts] = revision;\n                            }\n                            catch(e) {\n                                error = e;\n                            }\n                        }\n                        lineCount++;\n                        next();\n                    },\n                    function (e) {\n                        callback(error, revObj);\n                    }\n                );"],[0,"\n   "]],"start1":4017,"start2":4017,"length1":4508,"length2":5494},{"diffs":[[0,"UFFIX);\n"],[-1,"\n"],[0,"        "]],"start1":10847,"start2":10847,"length1":17,"length2":16},{"diffs":[[0,"function"],[-1," "],[0,"(exists)"]],"start1":10962,"start2":10962,"length1":17,"length2":16},{"diffs":[[0,"     if (exists)"],[-1," {"],[0,"\n               "]],"start1":10992,"start2":10992,"length1":34,"length2":32},{"diffs":[[0,"lback);\n"],[-1,"                }\n"],[0,"        "]],"start1":11062,"start2":11062,"length1":34,"length2":16},{"diffs":[[0,"            else"],[-1," {"],[0,"\n               "]],"start1":11074,"start2":11074,"length1":34,"length2":32},{"diffs":[[0,"lback);\n"],[-1,"                }\n"],[0,"        "]],"start1":11193,"start2":11193,"length1":34,"length2":16},{"diffs":[[0,"       }"],[-1,""],[0,""],[1,"\n               "],[0," else {\n"]],"start1":18095,"start2":18095,"length1":16,"length2":32},{"diffs":[[0,"   }"],[-1,").call(RevisionsPlugin.prototype);\n\n    imports.sandbox.getProjectDir(function(err, projectDir) {\n        if (err) return register(err);\n\n        fs = fsnode(imports.vfs, projectDir);\n        imports.ide.register(name, RevisionsPlugin, register);\n    }"],[1,"\n    require(\"util\").inherits(RevisionsPlugin, Plugin"],[0,");\n}"]],"start1":19210,"start2":19210,"length1":260,"length2":61}]],"length":19273,"saved":false}
{"ts":1349375723605,"patch":[[{"diffs":[[0,"+ FILE_SUFFIX);\n"],[1,"            console.log(absPath)\n"],[0,"            var "]],"start1":10839,"start2":10839,"length1":32,"length2":65}]],"length":19306,"saved":false}
{"contributors":[],"silentsave":false,"ts":1349375855459,"patch":[[{"diffs":[[0,"ction(exists) {\n"],[1,"                console.log(\"EX\", exists);\n"],[0,"                "]],"start1":10998,"start2":10998,"length1":32,"length2":75}]],"length":19349,"saved":false}
{"ts":1349375873273,"patch":[[{"diffs":[[0,"ole.log("],[1,"__dirname, "],[0,"absPath)"]],"start1":10871,"start2":10871,"length1":16,"length2":27}]],"length":19360,"saved":false}
{"ts":1349376244013,"patch":[[{"diffs":[[0,"log("],[-1,"__dirname, "],[0,"absP"]],"start1":10875,"start2":10875,"length1":19,"length2":8}]],"length":19349,"saved":false}

{"ts":1349376453420,"patch":[[{"diffs":[[0,";\n            }\n"],[1,"console.log(\"F\", filePath)"],[0,"\n            // "]],"start1":10693,"start2":10693,"length1":32,"length2":58}]],"length":19375,"saved":false}
{"contributors":[],"silentsave":false,"ts":1349376607792,"patch":[[{"diffs":[[0,"  }\n"],[-1,"console.log(\"F\", filePath)\n"],[0,"    "]],"start1":10705,"start2":10705,"length1":35,"length2":8},{"diffs":[[0,"X);\n"],[-1,"            console.log(absPath)\n"],[0,"    "]],"start1":10850,"start2":10850,"length1":41,"length2":8},{"diffs":[[0,"exists?\n"],[1,""],[0,"        "]],"start1":10922,"start2":10922,"length1":16,"length2":16},{"diffs":[[0,") {\n"],[-1,"                console.log(\"EX\", exists);\n"],[0,"    "]],"start1":10976,"start2":10976,"length1":51,"length2":8}]],"length":19272,"saved":false}
{"ts":1349376657775,"patch":[[{"diffs":[[0,"on(err, data) {\n"],[1,"                console.log(\"uh\")\n"],[0,"                "]],"start1":8369,"start2":8369,"length1":32,"length2":66}]],"length":19306,"saved":false}
{"ts":1349376669359,"patch":[[{"diffs":[[0,"log(\"uh\""],[1,", err"],[0,")\n      "]],"start1":8409,"start2":8409,"length1":16,"length2":21}]],"length":19311,"saved":false}
{"ts":1349376889076,"patch":[[{"diffs":[[0,") {\n"],[-1,"                console.log(\"uh\", err)\n"],[0,"    "]],"start1":8381,"start2":8381,"length1":47,"length2":8}]],"length":19272,"saved":false}
{"ts":1349383030234,"patch":[[{"diffs":[[0,"ata."],[-1,"toString()."],[0,"spli"]],"start1":8564,"start2":8564,"length1":19,"length2":8}]],"length":19261,"saved":false}
{"ts":1349383072017,"patch":[[{"diffs":[[0,"split(\"\\n\");"],[1," // Could be made into a stream for speed"],[0,"\n           "]],"start1":8568,"start2":8568,"length1":24,"length2":65}]],"length":19302,"saved":false}
{"ts":1349383633644,"patch":[[{"diffs":[[0,"  try {\n"],[1,"                                // This is blocking. Perhaps we should look into\n                                // JSONStream\n"],[0,"        "]],"start1":9016,"start2":9016,"length1":16,"length2":143},{"diffs":[[0,"\n            }\n\n"],[1,"            // This is blocking. It could be made non-blocking with JSONStreams\n"],[0,"            rece"]],"start1":15996,"start2":15996,"length1":32,"length2":112}]],"length":19509,"saved":false}
