"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const syntax_1 = require("@glimmer/syntax");
const template_compiler_1 = require("./template-compiler");
const defaultId = (() => {
    let idFn;
    return () => {
        if (!idFn) {
            if (typeof require === 'function') {
                try {
                    /* tslint:disable:no-require-imports */
                    const crypto = require('crypto');
                    /* tslint:enable:no-require-imports */
                    idFn = src => {
                        let hash = crypto.createHash('sha1');
                        hash.update(src, 'utf8');
                        // trim to 6 bytes of data (2^48 - 1)
                        return hash.digest('base64').substring(0, 8);
                    };
                    idFn("test");
                }
                catch (e) {
                    idFn = null;
                }
            }
            if (!idFn) {
                idFn = () => null;
            }
        }
        return idFn;
    };
})();
function precompile(string, options) {
    let opts = options || {
        id: defaultId(),
        meta: {}
    };
    let ast = syntax_1.preprocess(string, opts);
    let { block, meta } = template_compiler_1.default.compile(opts, ast);
    let idFn = opts.id || defaultId();
    let blockJSON = JSON.stringify(block.toJSON());
    let templateJSONObject = {
        id: idFn(JSON.stringify(meta) + blockJSON),
        block: blockJSON,
        meta
    };
    // JSON is javascript
    return JSON.stringify(templateJSONObject);
}
exports.precompile = precompile;
//# sourceMappingURL=data:application/json;base64,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