import { preprocess } from "@glimmer/syntax";
import TemplateCompiler from "./template-compiler";
const defaultId = (() => {
    let idFn;
    return () => {
        if (!idFn) {
            if (typeof require === 'function') {
                try {
                    /* tslint:disable:no-require-imports */
                    const crypto = require('crypto');
                    /* tslint:enable:no-require-imports */
                    idFn = src => {
                        let hash = crypto.createHash('sha1');
                        hash.update(src, 'utf8');
                        // trim to 6 bytes of data (2^48 - 1)
                        return hash.digest('base64').substring(0, 8);
                    };
                    idFn("test");
                }
                catch (e) {
                    idFn = null;
                }
            }
            if (!idFn) {
                idFn = () => null;
            }
        }
        return idFn;
    };
})();
export function precompile(string, options) {
    let opts = options || {
        id: defaultId(),
        meta: {}
    };
    let ast = preprocess(string, opts);
    let { block, meta } = TemplateCompiler.compile(opts, ast);
    let idFn = opts.id || defaultId();
    let blockJSON = JSON.stringify(block.toJSON());
    let templateJSONObject = {
        id: idFn(JSON.stringify(meta) + blockJSON),
        block: blockJSON,
        meta
    };
    // JSON is javascript
    return JSON.stringify(templateJSONObject);
}
//# sourceMappingURL=data:application/json;base64,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