import { DictSet } from "@glimmer/util";
import { TemplateMeta, SerializedBlock, SerializedTemplateBlock, SerializedTemplate, SerializedComponent, Core, Statement, Statements, Expression, Expressions } from '@glimmer/wire-format';
export declare type str = string;
export declare type Params = Core.Params;
export declare type Hash = Core.Hash;
export declare type Path = Core.Path;
export declare type StackValue = Expression | Params | Hash | str;
export declare class Block {
    type: string;
    statements: Statement[];
    positionals: string[];
    toJSON(): SerializedBlock;
    push(statement: Statement): void;
}
export declare class TemplateBlock extends Block {
    type: string;
    yields: DictSet<string>;
    named: DictSet<string>;
    blocks: SerializedBlock[];
    hasPartials: boolean;
    toJSON(): SerializedTemplateBlock;
}
export declare class ComponentBlock extends Block {
    type: string;
    attributes: Statements.Attribute[];
    arguments: Statements.Argument[];
    private inParams;
    push(statement: Statement): void;
    toJSON(): SerializedComponent;
}
export declare class Template<T extends TemplateMeta> {
    meta: T;
    block: TemplateBlock;
    constructor(meta: T);
    toJSON(): SerializedTemplate<T>;
}
export default class JavaScriptCompiler<T extends TemplateMeta> {
    static process<T extends TemplateMeta>(opcodes: any, meta: any): Template<T>;
    private template;
    private blocks;
    private opcodes;
    private values;
    constructor(opcodes: any, meta: T);
    process(): Template<T>;
    startBlock([program]: [any]): void;
    endBlock(): void;
    startProgram(): void;
    endProgram(): void;
    text(content: string): void;
    append(trusted: boolean): void;
    comment(value: string): void;
    modifier(path: Path): void;
    block(path: Path, template: number, inverse: number): void;
    openElement(tag: str, blockParams: string[]): void;
    flushElement(): void;
    closeElement(tag: str): void;
    staticAttr(name: str, namespace: str): void;
    dynamicAttr(name: str, namespace: str): void;
    trustingAttr(name: str, namespace: str): void;
    staticArg(name: str): void;
    dynamicArg(name: str): void;
    yield(to: string): void;
    debugger(): void;
    hasBlock(name: string): void;
    hasBlockParams(name: string): void;
    partial(): void;
    literal(value: Expressions.Value | undefined): void;
    unknown(path: string[]): void;
    arg(path: string[]): void;
    get(path: string[]): void;
    concat(): void;
    helper(path: string[]): void;
    startComponent(blockParams: string[]): void;
    endComponent(): SerializedComponent;
    prepareArray(size: number): void;
    prepareObject(size: number): void;
    push(args: Statement): void;
    pushValue<S extends Expression | Params | Hash>(val: S): void;
    popValue<T extends StackValue>(): T;
}
