import { Template } from "./javascript-compiler";
import { TemplateMeta } from "@glimmer/wire-format";
export interface CompileOptions<T extends TemplateMeta> {
    meta?: T;
}
export default class TemplateCompiler<T extends TemplateMeta> {
    static compile<T>(options: CompileOptions<T>, ast: any): Template<T>;
    private options;
    private templateId;
    private templateIds;
    private symbols;
    private opcodes;
    private includeMeta;
    constructor(options: CompileOptions<T>);
    process(actions: any): any[];
    startProgram(program: any): void;
    endProgram(): void;
    startBlock(program: any): void;
    endBlock(): void;
    text([action]: [any]): void;
    comment([action]: [any]): void;
    openElement([action]: [any]): void;
    closeElement([action]: [any]): void;
    attribute([action]: [any]): void;
    modifier([action]: [any]): void;
    mustache([action]: [any]): void;
    block([action]: [any]): void;
    arg([path]: [any]): void;
    mustacheExpression(expr: any): void;
    yield(to: string, action: any): void;
    debugger(name: any, action: any): void;
    hasBlock(name: string, action: any): void;
    hasBlockParams(name: string, action: any): void;
    partial(params: any, action: any): void;
    builtInHelper(expr: any): void;
    SubExpression(expr: any): void;
    PathExpression(expr: any): void;
    StringLiteral(action: any): void;
    BooleanLiteral(action: any): void;
    NumberLiteral(action: any): void;
    NullLiteral(action: any): void;
    UndefinedLiteral(action: any): void;
    opcode(name: any, action: any, ...args: any[]): void;
    prepareHelper(expr: any): void;
    preparePath(path: any): void;
    prepareParams(params: any): void;
    prepareHash(hash: any): void;
    prepareAttributeValue(value: any): boolean;
    prepareConcatParts(parts: any): void;
    attributeMustache([action]: [any]): void;
    meta(node: any): (string | any[])[];
}
