'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isSpecifierStringAbsolute = isSpecifierStringAbsolute;
exports.isSpecifierObjectAbsolute = isSpecifierObjectAbsolute;
exports.serializeSpecifier = serializeSpecifier;
exports.serializeSpecifierPath = serializeSpecifierPath;
exports.deserializeSpecifier = deserializeSpecifier;
function isSpecifierStringAbsolute(specifier) {
    let [type, path] = specifier.split(':');
    return !!(type && path && path.indexOf('/') === 0 && path.split('/').length > 3);
}
function isSpecifierObjectAbsolute(specifier) {
    return specifier.rootName !== undefined && specifier.collection !== undefined && specifier.name !== undefined && specifier.type !== undefined;
}
function serializeSpecifier(specifier) {
    let type = specifier.type;
    let path = serializeSpecifierPath(specifier);
    if (path) {
        return type + ':' + path;
    } else {
        return type;
    }
}
function serializeSpecifierPath(specifier) {
    let path = [];
    if (specifier.rootName) {
        path.push(specifier.rootName);
    }
    if (specifier.collection) {
        path.push(specifier.collection);
    }
    if (specifier.namespace) {
        path.push(specifier.namespace);
    }
    if (specifier.name) {
        path.push(specifier.name);
    }
    if (path.length > 0) {
        let fullPath = path.join('/');
        if (isSpecifierObjectAbsolute(specifier)) {
            fullPath = '/' + fullPath;
        }
        return fullPath;
    }
}
function deserializeSpecifier(specifier) {
    let obj = {};
    if (specifier.indexOf(':') > -1) {
        let [type, path] = specifier.split(':');
        obj.type = type;
        let pathSegments;
        if (path.indexOf('/') === 0) {
            pathSegments = path.substr(1).split('/');
            obj.rootName = pathSegments.shift();
            obj.collection = pathSegments.shift();
        } else {
            pathSegments = path.split('/');
        }
        if (pathSegments.length > 0) {
            obj.name = pathSegments.pop();
            if (pathSegments.length > 0) {
                obj.namespace = pathSegments.join('/');
            }
        }
    } else {
        obj.type = specifier;
    }
    return obj;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3BlY2lmaWVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3JjL3NwZWNpZmllci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O21DQVEwQyxBQUFpQjtBQUN6RCxRQUFJLENBQUMsQUFBSSxNQUFFLEFBQUksQUFBQyxRQUFHLEFBQVMsVUFBQyxBQUFLLE1BQUMsQUFBRyxBQUFDLEFBQUM7QUFDeEMsQUFBTSxXQUFDLENBQUMsQUFBQyxFQUFDLEFBQUksUUFBSSxBQUFJLFFBQUksQUFBSSxLQUFDLEFBQU8sUUFBQyxBQUFHLEFBQUMsU0FBSyxBQUFDLEtBQUksQUFBSSxLQUFDLEFBQUssTUFBQyxBQUFHLEFBQUMsS0FBQyxBQUFNLFNBQUcsQUFBQyxBQUFDLEFBQUMsQUFDbkY7QUFBQyxBQUVELEFBQU07bUNBQW9DLEFBQW9CO0FBQzVELEFBQU0sV0FBQyxBQUFTLFVBQUMsQUFBUSxhQUFLLEFBQVMsYUFDaEMsQUFBUyxVQUFDLEFBQVUsZUFBSyxBQUFTLGFBQ2xDLEFBQVMsVUFBQyxBQUFJLFNBQUssQUFBUyxhQUM1QixBQUFTLFVBQUMsQUFBSSxTQUFLLEFBQVMsQUFBQyxBQUN0QztBQUFDLEFBRUQsQUFBTTs0QkFBNkIsQUFBb0I7QUFDckQsUUFBSSxBQUFJLE9BQUcsQUFBUyxVQUFDLEFBQUksQUFBQztBQUMxQixRQUFJLEFBQUksT0FBRyxBQUFzQix1QkFBQyxBQUFTLEFBQUMsQUFBQztBQUU3QyxBQUFFLEFBQUMsUUFBQyxBQUFJLEFBQUMsTUFBQyxBQUFDO0FBQ1QsQUFBTSxlQUFDLEFBQUksT0FBRyxBQUFHLE1BQUcsQUFBSSxBQUFDLEFBQzNCO0FBQUMsQUFBQyxBQUFJLFdBQUMsQUFBQztBQUNOLEFBQU0sZUFBQyxBQUFJLEFBQUMsQUFDZDtBQUFDLEFBQ0g7QUFBQyxBQUVELEFBQU07Z0NBQWlDLEFBQW9CO0FBQ3pELFFBQUksQUFBSSxPQUFHLEFBQUUsQUFBQztBQUNkLEFBQUUsQUFBQyxRQUFDLEFBQVMsVUFBQyxBQUFRLEFBQUMsVUFBQyxBQUFDO0FBQ3ZCLEFBQUksYUFBQyxBQUFJLEtBQUMsQUFBUyxVQUFDLEFBQVEsQUFBQyxBQUFDLEFBQ2hDO0FBQUM7QUFDRCxBQUFFLEFBQUMsUUFBQyxBQUFTLFVBQUMsQUFBVSxBQUFDLFlBQUMsQUFBQztBQUN6QixBQUFJLGFBQUMsQUFBSSxLQUFDLEFBQVMsVUFBQyxBQUFVLEFBQUMsQUFBQyxBQUNsQztBQUFDO0FBQ0QsQUFBRSxBQUFDLFFBQUMsQUFBUyxVQUFDLEFBQVMsQUFBQyxXQUFDLEFBQUM7QUFDeEIsQUFBSSxhQUFDLEFBQUksS0FBQyxBQUFTLFVBQUMsQUFBUyxBQUFDLEFBQUMsQUFDakM7QUFBQztBQUNELEFBQUUsQUFBQyxRQUFDLEFBQVMsVUFBQyxBQUFJLEFBQUMsTUFBQyxBQUFDO0FBQ25CLEFBQUksYUFBQyxBQUFJLEtBQUMsQUFBUyxVQUFDLEFBQUksQUFBQyxBQUFDLEFBQzVCO0FBQUM7QUFFRCxBQUFFLEFBQUMsUUFBQyxBQUFJLEtBQUMsQUFBTSxTQUFHLEFBQUMsQUFBQyxHQUFDLEFBQUM7QUFDcEIsWUFBSSxBQUFRLFdBQUcsQUFBSSxLQUFDLEFBQUksS0FBQyxBQUFHLEFBQUMsQUFBQztBQUM5QixBQUFFLEFBQUMsWUFBQyxBQUF5QiwwQkFBQyxBQUFTLEFBQUMsQUFBQyxZQUFDLEFBQUM7QUFDekMsQUFBUSx1QkFBRyxBQUFHLE1BQUcsQUFBUSxBQUFDLEFBQzVCO0FBQUM7QUFDRCxBQUFNLGVBQUMsQUFBUSxBQUFDLEFBQ2xCO0FBQUMsQUFDSDtBQUFDLEFBRUQsQUFBTTs4QkFBK0IsQUFBaUI7QUFDcEQsUUFBSSxBQUFHLE1BQWMsQUFBRSxBQUFDO0FBRXhCLEFBQUUsQUFBQyxRQUFDLEFBQVMsVUFBQyxBQUFPLFFBQUMsQUFBRyxBQUFDLE9BQUcsQ0FBQyxBQUFDLEFBQUMsR0FBQyxBQUFDO0FBQ2hDLFlBQUksQ0FBQyxBQUFJLE1BQUUsQUFBSSxBQUFDLFFBQUcsQUFBUyxVQUFDLEFBQUssTUFBQyxBQUFHLEFBQUMsQUFBQztBQUN4QyxBQUFHLFlBQUMsQUFBSSxPQUFHLEFBQUksQUFBQztBQUVoQixZQUFJLEFBQVksQUFBQztBQUVqQixBQUFFLEFBQUMsWUFBQyxBQUFJLEtBQUMsQUFBTyxRQUFDLEFBQUcsQUFBQyxTQUFLLEFBQUMsQUFBQyxHQUFDLEFBQUM7QUFDNUIsQUFBWSwyQkFBRyxBQUFJLEtBQUMsQUFBTSxPQUFDLEFBQUMsQUFBQyxHQUFDLEFBQUssTUFBQyxBQUFHLEFBQUMsQUFBQztBQUN6QyxBQUFHLGdCQUFDLEFBQVEsV0FBRyxBQUFZLGFBQUMsQUFBSyxBQUFFLEFBQUM7QUFDcEMsQUFBRyxnQkFBQyxBQUFVLGFBQUcsQUFBWSxhQUFDLEFBQUssQUFBRSxBQUFDLEFBQ3hDO0FBQUMsQUFBQyxBQUFJLGVBQUMsQUFBQztBQUNOLEFBQVksMkJBQUcsQUFBSSxLQUFDLEFBQUssTUFBQyxBQUFHLEFBQUMsQUFBQyxBQUNqQztBQUFDO0FBRUQsQUFBRSxBQUFDLFlBQUMsQUFBWSxhQUFDLEFBQU0sU0FBRyxBQUFDLEFBQUMsR0FBQyxBQUFDO0FBQzVCLEFBQUcsZ0JBQUMsQUFBSSxPQUFHLEFBQVksYUFBQyxBQUFHLEFBQUUsQUFBQztBQUU5QixBQUFFLEFBQUMsZ0JBQUMsQUFBWSxhQUFDLEFBQU0sU0FBRyxBQUFDLEFBQUMsR0FBQyxBQUFDO0FBQzVCLEFBQUcsb0JBQUMsQUFBUyxZQUFHLEFBQVksYUFBQyxBQUFJLEtBQUMsQUFBRyxBQUFDLEFBQUMsQUFDekM7QUFBQyxBQUNIO0FBQUMsQUFFSDtBQUFDLEFBQUMsQUFBSSxXQUFDLEFBQUM7QUFDTixBQUFHLFlBQUMsQUFBSSxPQUFHLEFBQVMsQUFBQyxBQUN2QjtBQUFDO0FBRUQsQUFBTSxXQUFDLEFBQUcsQUFBQyxBQUNiO0FBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgaW50ZXJmYWNlIFNwZWNpZmllciB7XG4gIHJvb3ROYW1lPzogc3RyaW5nO1xuICBjb2xsZWN0aW9uPzogc3RyaW5nO1xuICBuYW1lc3BhY2U/OiBzdHJpbmc7XG4gIG5hbWU/OiBzdHJpbmc7XG4gIHR5cGU/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1NwZWNpZmllclN0cmluZ0Fic29sdXRlKHNwZWNpZmllcjogc3RyaW5nKTogYm9vbGVhbiB7XG4gIGxldCBbdHlwZSwgcGF0aF0gPSBzcGVjaWZpZXIuc3BsaXQoJzonKTtcbiAgcmV0dXJuICEhKHR5cGUgJiYgcGF0aCAmJiBwYXRoLmluZGV4T2YoJy8nKSA9PT0gMCAmJiBwYXRoLnNwbGl0KCcvJykubGVuZ3RoID4gMyk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1NwZWNpZmllck9iamVjdEFic29sdXRlKHNwZWNpZmllcjogU3BlY2lmaWVyKTogYm9vbGVhbiB7XG4gIHJldHVybiBzcGVjaWZpZXIucm9vdE5hbWUgIT09IHVuZGVmaW5lZCAmJlxuICAgICAgICAgc3BlY2lmaWVyLmNvbGxlY3Rpb24gIT09IHVuZGVmaW5lZCAmJlxuICAgICAgICAgc3BlY2lmaWVyLm5hbWUgIT09IHVuZGVmaW5lZCAmJlxuICAgICAgICAgc3BlY2lmaWVyLnR5cGUgIT09IHVuZGVmaW5lZDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHNlcmlhbGl6ZVNwZWNpZmllcihzcGVjaWZpZXI6IFNwZWNpZmllcik6IHN0cmluZyB7XG4gIGxldCB0eXBlID0gc3BlY2lmaWVyLnR5cGU7XG4gIGxldCBwYXRoID0gc2VyaWFsaXplU3BlY2lmaWVyUGF0aChzcGVjaWZpZXIpO1xuXG4gIGlmIChwYXRoKSB7XG4gICAgcmV0dXJuIHR5cGUgKyAnOicgKyBwYXRoO1xuICB9IGVsc2Uge1xuICAgIHJldHVybiB0eXBlO1xuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzZXJpYWxpemVTcGVjaWZpZXJQYXRoKHNwZWNpZmllcjogU3BlY2lmaWVyKTogc3RyaW5nIHtcbiAgbGV0IHBhdGggPSBbXTtcbiAgaWYgKHNwZWNpZmllci5yb290TmFtZSkge1xuICAgIHBhdGgucHVzaChzcGVjaWZpZXIucm9vdE5hbWUpO1xuICB9XG4gIGlmIChzcGVjaWZpZXIuY29sbGVjdGlvbikge1xuICAgIHBhdGgucHVzaChzcGVjaWZpZXIuY29sbGVjdGlvbik7XG4gIH1cbiAgaWYgKHNwZWNpZmllci5uYW1lc3BhY2UpIHtcbiAgICBwYXRoLnB1c2goc3BlY2lmaWVyLm5hbWVzcGFjZSk7XG4gIH1cbiAgaWYgKHNwZWNpZmllci5uYW1lKSB7XG4gICAgcGF0aC5wdXNoKHNwZWNpZmllci5uYW1lKTtcbiAgfVxuXG4gIGlmIChwYXRoLmxlbmd0aCA+IDApIHtcbiAgICBsZXQgZnVsbFBhdGggPSBwYXRoLmpvaW4oJy8nKTtcbiAgICBpZiAoaXNTcGVjaWZpZXJPYmplY3RBYnNvbHV0ZShzcGVjaWZpZXIpKSB7XG4gICAgICBmdWxsUGF0aCA9ICcvJyArIGZ1bGxQYXRoO1xuICAgIH1cbiAgICByZXR1cm4gZnVsbFBhdGg7XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGRlc2VyaWFsaXplU3BlY2lmaWVyKHNwZWNpZmllcjogc3RyaW5nKTogU3BlY2lmaWVyIHtcbiAgbGV0IG9iajogU3BlY2lmaWVyID0ge307XG5cbiAgaWYgKHNwZWNpZmllci5pbmRleE9mKCc6JykgPiAtMSkge1xuICAgIGxldCBbdHlwZSwgcGF0aF0gPSBzcGVjaWZpZXIuc3BsaXQoJzonKTtcbiAgICBvYmoudHlwZSA9IHR5cGU7XG5cbiAgICBsZXQgcGF0aFNlZ21lbnRzO1xuXG4gICAgaWYgKHBhdGguaW5kZXhPZignLycpID09PSAwKSB7XG4gICAgICBwYXRoU2VnbWVudHMgPSBwYXRoLnN1YnN0cigxKS5zcGxpdCgnLycpO1xuICAgICAgb2JqLnJvb3ROYW1lID0gcGF0aFNlZ21lbnRzLnNoaWZ0KCk7XG4gICAgICBvYmouY29sbGVjdGlvbiA9IHBhdGhTZWdtZW50cy5zaGlmdCgpO1xuICAgIH0gZWxzZSB7XG4gICAgICBwYXRoU2VnbWVudHMgPSBwYXRoLnNwbGl0KCcvJyk7XG4gICAgfVxuXG4gICAgaWYgKHBhdGhTZWdtZW50cy5sZW5ndGggPiAwKSB7XG4gICAgICBvYmoubmFtZSA9IHBhdGhTZWdtZW50cy5wb3AoKTtcblxuICAgICAgaWYgKHBhdGhTZWdtZW50cy5sZW5ndGggPiAwKSB7XG4gICAgICAgIG9iai5uYW1lc3BhY2UgPSBwYXRoU2VnbWVudHMuam9pbignLycpO1xuICAgICAgfVxuICAgIH1cblxuICB9IGVsc2Uge1xuICAgIG9iai50eXBlID0gc3BlY2lmaWVyO1xuICB9XG5cbiAgcmV0dXJuIG9iajtcbn1cbiJdfQ==