'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.isSpecifierStringAbsolute = isSpecifierStringAbsolute;
exports.isSpecifierObjectAbsolute = isSpecifierObjectAbsolute;
exports.serializeSpecifier = serializeSpecifier;
exports.serializeSpecifierPath = serializeSpecifierPath;
exports.deserializeSpecifier = deserializeSpecifier;
function isSpecifierStringAbsolute(specifier) {
    var _specifier$split = specifier.split(':'),
        type = _specifier$split[0],
        path = _specifier$split[1];

    return !!(type && path && path.indexOf('/') === 0 && path.split('/').length > 3);
}
function isSpecifierObjectAbsolute(specifier) {
    return specifier.rootName !== undefined && specifier.collection !== undefined && specifier.name !== undefined && specifier.type !== undefined;
}
function serializeSpecifier(specifier) {
    var type = specifier.type;
    var path = serializeSpecifierPath(specifier);
    if (path) {
        return type + ':' + path;
    } else {
        return type;
    }
}
function serializeSpecifierPath(specifier) {
    var path = [];
    if (specifier.rootName) {
        path.push(specifier.rootName);
    }
    if (specifier.collection) {
        path.push(specifier.collection);
    }
    if (specifier.namespace) {
        path.push(specifier.namespace);
    }
    if (specifier.name) {
        path.push(specifier.name);
    }
    if (path.length > 0) {
        var fullPath = path.join('/');
        if (isSpecifierObjectAbsolute(specifier)) {
            fullPath = '/' + fullPath;
        }
        return fullPath;
    }
}
function deserializeSpecifier(specifier) {
    var obj = {};
    if (specifier.indexOf(':') > -1) {
        var _specifier$split2 = specifier.split(':'),
            type = _specifier$split2[0],
            path = _specifier$split2[1];

        obj.type = type;
        var pathSegments = void 0;
        if (path.indexOf('/') === 0) {
            pathSegments = path.substr(1).split('/');
            obj.rootName = pathSegments.shift();
            obj.collection = pathSegments.shift();
        } else {
            pathSegments = path.split('/');
        }
        if (pathSegments.length > 0) {
            obj.name = pathSegments.pop();
            if (pathSegments.length > 0) {
                obj.namespace = pathSegments.join('/');
            }
        }
    } else {
        obj.type = specifier;
    }
    return obj;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3BlY2lmaWVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3JjL3NwZWNpZmllci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O21DQVEwQyxBQUFpQixXQUN6RCxBQUFJOzJCQUFlLEFBQVMsVUFBQyxBQUFLLE1BQUMsQUFBRyxBQUFDLEFBQUM7UUFBbkMsQUFBSTtRQUFFLEFBQUksQUFBQyx3QkFDaEIsQUFBTTs7V0FBQyxDQUFDLEFBQUMsRUFBQyxBQUFJLFFBQUksQUFBSSxRQUFJLEFBQUksS0FBQyxBQUFPLFFBQUMsQUFBRyxBQUFDLFNBQUssQUFBQyxLQUFJLEFBQUksS0FBQyxBQUFLLE1BQUMsQUFBRyxBQUFDLEtBQUMsQUFBTSxTQUFHLEFBQUMsQUFBQyxBQUFDLEFBQ25GLEFBQUM7QUFFRCxBQUFNO21DQUFvQyxBQUFvQixXQUM1RCxBQUFNO1dBQUMsQUFBUyxVQUFDLEFBQVEsYUFBSyxBQUFTLGFBQ2hDLEFBQVMsVUFBQyxBQUFVLGVBQUssQUFBUyxhQUNsQyxBQUFTLFVBQUMsQUFBSSxTQUFLLEFBQVMsYUFDNUIsQUFBUyxVQUFDLEFBQUksU0FBSyxBQUFTLEFBQUMsQUFDdEMsQUFBQztBQUVELEFBQU07NEJBQTZCLEFBQW9CLFdBQ3JEO1FBQUksQUFBSSxPQUFHLEFBQVMsVUFBQyxBQUFJLEFBQUMsQUFDMUI7UUFBSSxBQUFJLE9BQUcsQUFBc0IsdUJBQUMsQUFBUyxBQUFDLEFBQUMsQUFFN0MsQUFBRSxBQUFDO1FBQUMsQUFBSSxBQUFDLE1BQUMsQUFBQyxBQUNULEFBQU07ZUFBQyxBQUFJLE9BQUcsQUFBRyxNQUFHLEFBQUksQUFBQyxBQUMzQixBQUFDLEFBQUMsQUFBSTtXQUFDLEFBQUMsQUFDTixBQUFNO2VBQUMsQUFBSSxBQUFDLEFBQ2QsQUFBQyxBQUNIO0FBQUM7QUFFRCxBQUFNO2dDQUFpQyxBQUFvQixXQUN6RDtRQUFJLEFBQUksT0FBRyxBQUFFLEFBQUMsQUFDZCxBQUFFLEFBQUM7UUFBQyxBQUFTLFVBQUMsQUFBUSxBQUFDLFVBQUMsQUFBQyxBQUN2QixBQUFJO2FBQUMsQUFBSSxLQUFDLEFBQVMsVUFBQyxBQUFRLEFBQUMsQUFBQyxBQUNoQyxBQUFDO0FBQ0QsQUFBRSxBQUFDO1FBQUMsQUFBUyxVQUFDLEFBQVUsQUFBQyxZQUFDLEFBQUMsQUFDekIsQUFBSTthQUFDLEFBQUksS0FBQyxBQUFTLFVBQUMsQUFBVSxBQUFDLEFBQUMsQUFDbEMsQUFBQztBQUNELEFBQUUsQUFBQztRQUFDLEFBQVMsVUFBQyxBQUFTLEFBQUMsV0FBQyxBQUFDLEFBQ3hCLEFBQUk7YUFBQyxBQUFJLEtBQUMsQUFBUyxVQUFDLEFBQVMsQUFBQyxBQUFDLEFBQ2pDLEFBQUM7QUFDRCxBQUFFLEFBQUM7UUFBQyxBQUFTLFVBQUMsQUFBSSxBQUFDLE1BQUMsQUFBQyxBQUNuQixBQUFJO2FBQUMsQUFBSSxLQUFDLEFBQVMsVUFBQyxBQUFJLEFBQUMsQUFBQyxBQUM1QixBQUFDO0FBRUQsQUFBRSxBQUFDO1FBQUMsQUFBSSxLQUFDLEFBQU0sU0FBRyxBQUFDLEFBQUMsR0FBQyxBQUFDLEFBQ3BCO1lBQUksQUFBUSxXQUFHLEFBQUksS0FBQyxBQUFJLEtBQUMsQUFBRyxBQUFDLEFBQUMsQUFDOUIsQUFBRSxBQUFDO1lBQUMsQUFBeUIsMEJBQUMsQUFBUyxBQUFDLEFBQUMsWUFBQyxBQUFDLEFBQ3pDLEFBQVE7dUJBQUcsQUFBRyxNQUFHLEFBQVEsQUFBQyxBQUM1QixBQUFDO0FBQ0QsQUFBTTtlQUFDLEFBQVEsQUFBQyxBQUNsQixBQUFDLEFBQ0g7QUFBQztBQUVELEFBQU07OEJBQStCLEFBQWlCLFdBQ3BEO1FBQUksQUFBRyxNQUFjLEFBQUUsQUFBQyxBQUV4QixBQUFFLEFBQUM7UUFBQyxBQUFTLFVBQUMsQUFBTyxRQUFDLEFBQUcsQUFBQyxPQUFHLENBQUMsQUFBQyxBQUFDLEdBQUMsQUFBQyxBQUNoQyxBQUFJO2dDQUFlLEFBQVMsVUFBQyxBQUFLLE1BQUMsQUFBRyxBQUFDLEFBQUM7WUFBbkMsQUFBSTtZQUFFLEFBQUksQUFBQyx5QkFDaEIsQUFBRzs7WUFBQyxBQUFJLE9BQUcsQUFBSSxBQUFDLEFBRWhCO1lBQUksQUFBWSxBQUFDLG9CQUVqQixBQUFFLEFBQUM7WUFBQyxBQUFJLEtBQUMsQUFBTyxRQUFDLEFBQUcsQUFBQyxTQUFLLEFBQUMsQUFBQyxHQUFDLEFBQUMsQUFDNUIsQUFBWTsyQkFBRyxBQUFJLEtBQUMsQUFBTSxPQUFDLEFBQUMsQUFBQyxHQUFDLEFBQUssTUFBQyxBQUFHLEFBQUMsQUFBQyxBQUN6QyxBQUFHO2dCQUFDLEFBQVEsV0FBRyxBQUFZLGFBQUMsQUFBSyxBQUFFLEFBQUMsQUFDcEMsQUFBRztnQkFBQyxBQUFVLGFBQUcsQUFBWSxhQUFDLEFBQUssQUFBRSxBQUFDLEFBQ3hDLEFBQUMsQUFBQyxBQUFJO2VBQUMsQUFBQyxBQUNOLEFBQVk7MkJBQUcsQUFBSSxLQUFDLEFBQUssTUFBQyxBQUFHLEFBQUMsQUFBQyxBQUNqQyxBQUFDO0FBRUQsQUFBRSxBQUFDO1lBQUMsQUFBWSxhQUFDLEFBQU0sU0FBRyxBQUFDLEFBQUMsR0FBQyxBQUFDLEFBQzVCLEFBQUc7Z0JBQUMsQUFBSSxPQUFHLEFBQVksYUFBQyxBQUFHLEFBQUUsQUFBQyxBQUU5QixBQUFFLEFBQUM7Z0JBQUMsQUFBWSxhQUFDLEFBQU0sU0FBRyxBQUFDLEFBQUMsR0FBQyxBQUFDLEFBQzVCLEFBQUc7b0JBQUMsQUFBUyxZQUFHLEFBQVksYUFBQyxBQUFJLEtBQUMsQUFBRyxBQUFDLEFBQUMsQUFDekMsQUFBQyxBQUNIO0FBQUMsQUFFSDtBQUFDLEFBQUMsQUFBSTtXQUFDLEFBQUMsQUFDTixBQUFHO1lBQUMsQUFBSSxPQUFHLEFBQVMsQUFBQyxBQUN2QixBQUFDO0FBRUQsQUFBTTtXQUFDLEFBQUcsQUFBQyxBQUNiLEFBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgaW50ZXJmYWNlIFNwZWNpZmllciB7XG4gIHJvb3ROYW1lPzogc3RyaW5nO1xuICBjb2xsZWN0aW9uPzogc3RyaW5nO1xuICBuYW1lc3BhY2U/OiBzdHJpbmc7XG4gIG5hbWU/OiBzdHJpbmc7XG4gIHR5cGU/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1NwZWNpZmllclN0cmluZ0Fic29sdXRlKHNwZWNpZmllcjogc3RyaW5nKTogYm9vbGVhbiB7XG4gIGxldCBbdHlwZSwgcGF0aF0gPSBzcGVjaWZpZXIuc3BsaXQoJzonKTtcbiAgcmV0dXJuICEhKHR5cGUgJiYgcGF0aCAmJiBwYXRoLmluZGV4T2YoJy8nKSA9PT0gMCAmJiBwYXRoLnNwbGl0KCcvJykubGVuZ3RoID4gMyk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1NwZWNpZmllck9iamVjdEFic29sdXRlKHNwZWNpZmllcjogU3BlY2lmaWVyKTogYm9vbGVhbiB7XG4gIHJldHVybiBzcGVjaWZpZXIucm9vdE5hbWUgIT09IHVuZGVmaW5lZCAmJlxuICAgICAgICAgc3BlY2lmaWVyLmNvbGxlY3Rpb24gIT09IHVuZGVmaW5lZCAmJlxuICAgICAgICAgc3BlY2lmaWVyLm5hbWUgIT09IHVuZGVmaW5lZCAmJlxuICAgICAgICAgc3BlY2lmaWVyLnR5cGUgIT09IHVuZGVmaW5lZDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHNlcmlhbGl6ZVNwZWNpZmllcihzcGVjaWZpZXI6IFNwZWNpZmllcik6IHN0cmluZyB7XG4gIGxldCB0eXBlID0gc3BlY2lmaWVyLnR5cGU7XG4gIGxldCBwYXRoID0gc2VyaWFsaXplU3BlY2lmaWVyUGF0aChzcGVjaWZpZXIpO1xuXG4gIGlmIChwYXRoKSB7XG4gICAgcmV0dXJuIHR5cGUgKyAnOicgKyBwYXRoO1xuICB9IGVsc2Uge1xuICAgIHJldHVybiB0eXBlO1xuICB9XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzZXJpYWxpemVTcGVjaWZpZXJQYXRoKHNwZWNpZmllcjogU3BlY2lmaWVyKTogc3RyaW5nIHtcbiAgbGV0IHBhdGggPSBbXTtcbiAgaWYgKHNwZWNpZmllci5yb290TmFtZSkge1xuICAgIHBhdGgucHVzaChzcGVjaWZpZXIucm9vdE5hbWUpO1xuICB9XG4gIGlmIChzcGVjaWZpZXIuY29sbGVjdGlvbikge1xuICAgIHBhdGgucHVzaChzcGVjaWZpZXIuY29sbGVjdGlvbik7XG4gIH1cbiAgaWYgKHNwZWNpZmllci5uYW1lc3BhY2UpIHtcbiAgICBwYXRoLnB1c2goc3BlY2lmaWVyLm5hbWVzcGFjZSk7XG4gIH1cbiAgaWYgKHNwZWNpZmllci5uYW1lKSB7XG4gICAgcGF0aC5wdXNoKHNwZWNpZmllci5uYW1lKTtcbiAgfVxuXG4gIGlmIChwYXRoLmxlbmd0aCA+IDApIHtcbiAgICBsZXQgZnVsbFBhdGggPSBwYXRoLmpvaW4oJy8nKTtcbiAgICBpZiAoaXNTcGVjaWZpZXJPYmplY3RBYnNvbHV0ZShzcGVjaWZpZXIpKSB7XG4gICAgICBmdWxsUGF0aCA9ICcvJyArIGZ1bGxQYXRoO1xuICAgIH1cbiAgICByZXR1cm4gZnVsbFBhdGg7XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGRlc2VyaWFsaXplU3BlY2lmaWVyKHNwZWNpZmllcjogc3RyaW5nKTogU3BlY2lmaWVyIHtcbiAgbGV0IG9iajogU3BlY2lmaWVyID0ge307XG5cbiAgaWYgKHNwZWNpZmllci5pbmRleE9mKCc6JykgPiAtMSkge1xuICAgIGxldCBbdHlwZSwgcGF0aF0gPSBzcGVjaWZpZXIuc3BsaXQoJzonKTtcbiAgICBvYmoudHlwZSA9IHR5cGU7XG5cbiAgICBsZXQgcGF0aFNlZ21lbnRzO1xuXG4gICAgaWYgKHBhdGguaW5kZXhPZignLycpID09PSAwKSB7XG4gICAgICBwYXRoU2VnbWVudHMgPSBwYXRoLnN1YnN0cigxKS5zcGxpdCgnLycpO1xuICAgICAgb2JqLnJvb3ROYW1lID0gcGF0aFNlZ21lbnRzLnNoaWZ0KCk7XG4gICAgICBvYmouY29sbGVjdGlvbiA9IHBhdGhTZWdtZW50cy5zaGlmdCgpO1xuICAgIH0gZWxzZSB7XG4gICAgICBwYXRoU2VnbWVudHMgPSBwYXRoLnNwbGl0KCcvJyk7XG4gICAgfVxuXG4gICAgaWYgKHBhdGhTZWdtZW50cy5sZW5ndGggPiAwKSB7XG4gICAgICBvYmoubmFtZSA9IHBhdGhTZWdtZW50cy5wb3AoKTtcblxuICAgICAgaWYgKHBhdGhTZWdtZW50cy5sZW5ndGggPiAwKSB7XG4gICAgICAgIG9iai5uYW1lc3BhY2UgPSBwYXRoU2VnbWVudHMuam9pbignLycpO1xuICAgICAgfVxuICAgIH1cblxuICB9IGVsc2Uge1xuICAgIG9iai50eXBlID0gc3BlY2lmaWVyO1xuICB9XG5cbiAgcmV0dXJuIG9iajtcbn1cbiJdfQ==