function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Container = function () {
    function Container(registry) {
        var resolver = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

        _classCallCheck(this, Container);

        this._registry = registry;
        this._resolver = resolver;
        this._lookups = {};
        this._factoryDefinitionLookups = {};
    }

    Container.prototype.factoryFor = function factoryFor(specifier) {
        var factoryDefinition = this._factoryDefinitionLookups[specifier];
        if (!factoryDefinition) {
            if (this._resolver) {
                factoryDefinition = this._resolver.retrieve(specifier);
            }
            if (!factoryDefinition) {
                factoryDefinition = this._registry.registration(specifier);
            }
            if (factoryDefinition) {
                this._factoryDefinitionLookups[specifier] = factoryDefinition;
            }
        }
        if (!factoryDefinition) {
            return;
        }
        return this.buildFactory(specifier, factoryDefinition);
    };

    Container.prototype.lookup = function lookup(specifier) {
        var singleton = this._registry.registeredOption(specifier, 'singleton') !== false;
        if (singleton) {
            var lookup = this._lookups[specifier];
            if (lookup) {
                return lookup.instance;
            }
        }
        var factory = this.factoryFor(specifier);
        if (!factory) {
            return;
        }
        if (this._registry.registeredOption(specifier, 'instantiate') === false) {
            return factory.class;
        }
        var instance = factory.create();
        if (singleton && instance) {
            this._lookups[specifier] = { factory: factory, instance: instance };
        }
        return instance;
    };

    Container.prototype.defaultInjections = function defaultInjections(specifier) {
        return {};
    };

    Container.prototype.teardown = function teardown() {
        var specifiers = Object.keys(this._lookups);
        for (var i = 0; i < specifiers.length; i++) {
            var specifier = specifiers[i];
            var _lookups$specifier = this._lookups[specifier],
                factory = _lookups$specifier.factory,
                instance = _lookups$specifier.instance;

            factory.teardown(instance);
        }
    };

    Container.prototype.defaultTeardown = function defaultTeardown(instance) {};

    Container.prototype.buildInjections = function buildInjections(specifier) {
        var hash = this.defaultInjections(specifier);
        var injections = this._registry.registeredInjections(specifier);
        var injection = void 0;
        for (var i = 0; i < injections.length; i++) {
            injection = injections[i];
            hash[injection.property] = this.lookup(injection.source);
        }
        return hash;
    };

    Container.prototype.buildFactory = function buildFactory(specifier, factoryDefinition) {
        var _this = this;

        var injections = this.buildInjections(specifier);
        return {
            class: factoryDefinition,
            teardown: function (instance) {
                if (factoryDefinition.teardown) {
                    factoryDefinition.teardown(instance);
                } else {
                    _this.defaultTeardown(instance);
                }
            },
            create: function (options) {
                var mergedOptions = Object.assign({}, injections, options);
                return factoryDefinition.create(mergedOptions);
            }
        };
    };

    return Container;
}();

export default Container;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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