"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const runtime_1 = require("@glimmer/runtime");
class NodeDOMTreeConstruction extends runtime_1.DOMTreeConstruction {
    constructor(doc) {
        super(doc);
    }
    // override to prevent usage of `this.document` until after the constructor
    setupUselessElement() { }
    insertHTMLBefore(parent, html, reference) {
        let prev = reference ? reference.previousSibling : parent.lastChild;
        let raw = this.document.createRawHTMLSection(html);
        parent.insertBefore(raw, reference);
        let first = prev ? prev.nextSibling : parent.firstChild;
        let last = reference ? reference.previousSibling : parent.lastChild;
        return new runtime_1.ConcreteBounds(parent, first, last);
    }
    // override to avoid SVG detection/work when in node (this is not needed in SSR)
    createElement(tag) {
        return this.document.createElement(tag);
    }
    // override to avoid namespace shenanigans when in node (this is not needed in SSR)
    setAttribute(element, name, value) {
        element.setAttribute(name, value);
    }
}
exports.default = NodeDOMTreeConstruction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm9kZS1kb20taGVscGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vbGliL25vZGUtZG9tLWhlbHBlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUNBLDhDQUF1RjtBQUV2Riw2QkFBNkMsU0FBUSw2QkFBbUI7SUFFdEUsWUFBWSxHQUFvQjtRQUM5QixLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDYixDQUFDO0lBRUQsMkVBQTJFO0lBQ2pFLG1CQUFtQixLQUFLLENBQUM7SUFFbkMsZ0JBQWdCLENBQUMsTUFBc0IsRUFBRSxJQUFZLEVBQUUsU0FBc0I7UUFDM0UsSUFBSSxJQUFJLEdBQUcsU0FBUyxHQUFHLFNBQVMsQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUVwRSxJQUFJLEdBQUcsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ25ELE1BQU0sQ0FBQyxZQUFZLENBQUMsR0FBRyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBRXBDLElBQUksS0FBSyxHQUFHLElBQUksR0FBRyxJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDeEQsSUFBSSxJQUFJLEdBQUcsU0FBUyxHQUFHLFNBQVMsQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLFNBQVMsQ0FBQztRQUVwRSxNQUFNLENBQUMsSUFBSSx3QkFBYyxDQUFDLE1BQU0sRUFBRSxLQUFLLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFDakQsQ0FBQztJQUVELGdGQUFnRjtJQUNoRixhQUFhLENBQUMsR0FBVztRQUN2QixNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDMUMsQ0FBQztJQUVELG1GQUFtRjtJQUNuRixZQUFZLENBQUMsT0FBZ0IsRUFBRSxJQUFZLEVBQUUsS0FBYTtRQUN4RCxPQUFPLENBQUMsWUFBWSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsQ0FBQztJQUNwQyxDQUFDO0NBQ0Y7QUE5QkQsMENBOEJDIn0=