import { DOMTreeConstruction, ConcreteBounds } from '@glimmer/runtime';
export default class NodeDOMTreeConstruction extends DOMTreeConstruction {
    constructor(doc) {
        super(doc);
    }
    // override to prevent usage of `this.document` until after the constructor
    setupUselessElement() { }
    insertHTMLBefore(parent, html, reference) {
        let prev = reference ? reference.previousSibling : parent.lastChild;
        let raw = this.document.createRawHTMLSection(html);
        parent.insertBefore(raw, reference);
        let first = prev ? prev.nextSibling : parent.firstChild;
        let last = reference ? reference.previousSibling : parent.lastChild;
        return new ConcreteBounds(parent, first, last);
    }
    // override to avoid SVG detection/work when in node (this is not needed in SSR)
    createElement(tag) {
        return this.document.createElement(tag);
    }
    // override to avoid namespace shenanigans when in node (this is not needed in SSR)
    setAttribute(element, name, value) {
        element.setAttribute(name, value);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm9kZS1kb20taGVscGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vbGliL25vZGUtZG9tLWhlbHBlci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDQSxPQUFPLEVBQUUsbUJBQW1CLEVBQWtCLGNBQWMsRUFBRSxNQUFNLGtCQUFrQixDQUFDO0FBRXZGLE1BQU0sQ0FBQyxPQUFPLDhCQUErQixTQUFRLG1CQUFtQjtJQUV0RSxZQUFZLEdBQW9CO1FBQzlCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUNiLENBQUM7SUFFRCwyRUFBMkU7SUFDakUsbUJBQW1CLEtBQUssQ0FBQztJQUVuQyxnQkFBZ0IsQ0FBQyxNQUFzQixFQUFFLElBQVksRUFBRSxTQUFzQjtRQUMzRSxJQUFJLElBQUksR0FBRyxTQUFTLEdBQUcsU0FBUyxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBRXBFLElBQUksR0FBRyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsb0JBQW9CLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDbkQsTUFBTSxDQUFDLFlBQVksQ0FBQyxHQUFHLEVBQUUsU0FBUyxDQUFDLENBQUM7UUFFcEMsSUFBSSxLQUFLLEdBQUcsSUFBSSxHQUFHLElBQUksQ0FBQyxXQUFXLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQztRQUN4RCxJQUFJLElBQUksR0FBRyxTQUFTLEdBQUcsU0FBUyxDQUFDLGVBQWUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBRXBFLE1BQU0sQ0FBQyxJQUFJLGNBQWMsQ0FBQyxNQUFNLEVBQUUsS0FBSyxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQ2pELENBQUM7SUFFRCxnRkFBZ0Y7SUFDaEYsYUFBYSxDQUFDLEdBQVc7UUFDdkIsTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQzFDLENBQUM7SUFFRCxtRkFBbUY7SUFDbkYsWUFBWSxDQUFDLE9BQWdCLEVBQUUsSUFBWSxFQUFFLEtBQWE7UUFDeEQsT0FBTyxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDcEMsQ0FBQztDQUNGIn0=