"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const descriptors_1 = require("./references/descriptors");
const root_1 = require("./references/root");
const util_1 = require("@glimmer/util");
const reference_1 = require("@glimmer/reference");
const NOOP_DESTROY = { destroy() { } };
class ConstPath {
    constructor(parent, property) {
        this.tag = reference_1.VOLATILE_TAG;
        this.parent = parent;
    }
    chain() { return NOOP_DESTROY; }
    notify() { }
    value() {
        return this.parent[this.property];
    }
    get(prop) {
        return new ConstPath(this.parent[this.property], prop);
    }
}
class ConstRoot {
    constructor(value) {
        this.tag = reference_1.VOLATILE_TAG;
        this.inner = value;
    }
    update(inner) {
        this.inner = inner;
    }
    chain() { return NOOP_DESTROY; }
    notify() { }
    value() {
        return this.inner;
    }
    referenceFromParts(parts) {
        throw new Error("Not implemented");
    }
    chainFor(prop) {
        throw new Error("Not implemented");
    }
    get(prop) {
        return new ConstPath(this.inner, prop);
    }
}
class ConstMeta /*implements IMeta*/ {
    constructor(object) {
        this.object = object;
    }
    root() {
        return new ConstRoot(this.object);
    }
}
exports.CLASS_META = "df8be4c8-4e89-44e2-a8f9-550c8dacdca7";
const hasOwnProperty = Object.hasOwnProperty;
class Meta {
    constructor(object, { RootReferenceFactory, DefaultPathReferenceFactory }) {
        this.references = null;
        this.slots = null;
        this.referenceTypes = null;
        this.propertyMetadata = null;
        this.object = object;
        this.RootReferenceFactory = RootReferenceFactory || root_1.default;
        this.DefaultPathReferenceFactory = DefaultPathReferenceFactory || descriptors_1.PropertyReference;
    }
    static for(obj) {
        if (obj === null || obj === undefined)
            return new Meta(obj, {});
        if (hasOwnProperty.call(obj, '_meta') && obj._meta)
            return obj._meta;
        if (!Object.isExtensible(obj))
            return new ConstMeta(obj);
        let MetaToUse = Meta;
        if (obj.constructor && obj.constructor[exports.CLASS_META]) {
            let classMeta = obj.constructor[exports.CLASS_META];
            MetaToUse = classMeta.InstanceMetaConstructor;
        }
        else if (obj[exports.CLASS_META]) {
            MetaToUse = obj[exports.CLASS_META].InstanceMetaConstructor;
        }
        return (obj._meta = new MetaToUse(obj, {}));
    }
    static exists(obj) {
        return typeof obj === 'object' && obj._meta;
    }
    static metadataForProperty(key) {
        return null;
    }
    addReference(property, reference) {
        let refs = this.references = this.references || util_1.dict();
        let set = refs[property] = refs[property] || new util_1.DictSet();
        set.add(reference);
    }
    addReferenceTypeFor(property, type) {
        this.referenceTypes = this.referenceTypes || util_1.dict();
        this.referenceTypes[property] = type;
    }
    referenceTypeFor(property) {
        if (!this.referenceTypes)
            return descriptors_1.PropertyReference;
        return this.referenceTypes[property] || descriptors_1.PropertyReference;
    }
    removeReference(property, reference) {
        if (!this.references)
            return;
        let set = this.references[property];
        set.delete(reference);
    }
    getReferenceTypes() {
        this.referenceTypes = this.referenceTypes || util_1.dict();
        return this.referenceTypes;
    }
    referencesFor(property) {
        if (!this.references)
            return;
        return this.references[property];
    }
    getSlots() {
        return (this.slots = this.slots || util_1.dict());
    }
    root() {
        return (this.rootCache = this.rootCache || new this.RootReferenceFactory(this.object));
    }
}
exports.default = Meta;
function metaFor(obj) {
    return Meta.for(obj);
}
exports.metaFor = metaFor;
//# sourceMappingURL=data:application/json;base64,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