"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const meta_1 = require("../meta");
const reference_1 = require("@glimmer/reference");
class PropertyReference {
    constructor(object, property, outer) {
        this.tag = reference_1.VOLATILE_TAG;
        this.object = object;
        this.property = property;
    }
    value() { return this.object[this.property]; }
    label() {
        return '[reference Property]';
    }
}
exports.PropertyReference = PropertyReference;
function ComputedReferenceBlueprint(property, dependencies) {
    return class ComputedReference {
        constructor(object, property, outer) {
            this.installed = false;
            this.tag = reference_1.VOLATILE_TAG;
            this.object = object;
            this.property = property;
            this.dependencies = dependencies;
            this.outer = outer;
        }
        value() {
            if (!this.installed) {
                let root = meta_1.default.for(this.object).root();
                this.dependencies.forEach(dep => {
                    let ref = root.referenceFromParts(dep);
                    ref.value();
                });
                this.installed = true;
            }
            return this.object[this.property];
        }
        label() {
            return '[reference Computed]';
        }
    };
}
exports.ComputedReferenceBlueprint = ComputedReferenceBlueprint;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVzY3JpcHRvcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9saWIvcmVmZXJlbmNlcy9kZXNjcmlwdG9ycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGtDQUEyQjtBQUMzQixrREFBMEU7QUFPMUU7SUFLRSxZQUFZLE1BQVcsRUFBRSxRQUFnQixFQUFFLEtBQTZCO1FBRmpFLFFBQUcsR0FBZ0Isd0JBQVksQ0FBQztRQUdyQyxJQUFJLENBQUMsTUFBTSxHQUFHLE1BQU0sQ0FBQztRQUNyQixJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQztJQUMzQixDQUFDO0lBRUQsS0FBSyxLQUFLLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFOUMsS0FBSztRQUNILE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQztJQUNoQyxDQUFDO0NBQ0Y7QUFmRCw4Q0FlQztBQUVELG9DQUE4QyxRQUFRLEVBQUUsWUFBWTtJQUNsRSxNQUFNLENBQUM7UUFRTCxZQUFZLE1BQVcsRUFBRSxRQUFnQixFQUFFLEtBQTZCO1lBSGhFLGNBQVMsR0FBRyxLQUFLLENBQUM7WUFDbkIsUUFBRyxHQUFnQix3QkFBWSxDQUFDO1lBR3JDLElBQUksQ0FBQyxNQUFNLEdBQUcsTUFBTSxDQUFDO1lBQ3JCLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDO1lBQ3pCLElBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFDO1lBQ2pDLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ3JCLENBQUM7UUFFRCxLQUFLO1lBQ0gsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztnQkFDcEIsSUFBSSxJQUFJLEdBQUcsY0FBSSxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLENBQUMsSUFBSSxFQUFFLENBQUM7Z0JBRXhDLElBQUksQ0FBQyxZQUFZLENBQUMsT0FBTyxDQUFDLEdBQUc7b0JBQzNCLElBQUksR0FBRyxHQUFHLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxHQUFHLENBQUMsQ0FBQztvQkFDdkMsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO2dCQUNkLENBQUMsQ0FBQyxDQUFDO2dCQUVILElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDO1lBQ3hCLENBQUM7WUFFRCxNQUFNLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDcEMsQ0FBQztRQUVELEtBQUs7WUFDSCxNQUFNLENBQUMsc0JBQXNCLENBQUM7UUFDaEMsQ0FBQztLQUNGLENBQUM7QUFDSixDQUFDO0FBbkNELGdFQW1DQyJ9