"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("../utils");
const util_1 = require("@glimmer/util");
const meta_1 = require("../meta");
const descriptors_1 = require("./descriptors");
const reference_1 = require("@glimmer/reference");
class PathReference {
    constructor(parent, property) {
        this.cache = utils_1.EMPTY_CACHE;
        this.inner = null;
        this.chains = null;
        this.lastParentValue = utils_1.EMPTY_CACHE;
        this._guid = null;
        this.tag = reference_1.VOLATILE_TAG;
        this.parent = parent;
        this.property = property;
    }
    value() {
        let { lastParentValue, property, inner } = this;
        let parentValue = this._parentValue();
        if (parentValue === null || parentValue === undefined) {
            return (this.cache = undefined);
        }
        if (lastParentValue === parentValue) {
            inner = this.inner;
        }
        else {
            let ReferenceType = typeof parentValue === 'object' ? meta_1.default.for(parentValue).referenceTypeFor(property) : descriptors_1.PropertyReference;
            inner = this.inner = new ReferenceType(parentValue, property, this);
        }
        // if (typeof parentValue === 'object') {
        //   Meta.for(parentValue).addReference(property, this);
        // }
        return (this.cache = inner.value());
    }
    get(prop) {
        let chains = this._getChains();
        if (prop in chains)
            return chains[prop];
        return (chains[prop] = new PathReference(this, prop));
    }
    label() {
        return '[reference Direct]';
    }
    _getChains() {
        if (this.chains)
            return this.chains;
        return (this.chains = util_1.dict());
    }
    _parentValue() {
        let parent = this.parent.value();
        this.lastParentValue = parent;
        return parent;
    }
}
exports.default = PathReference;
exports.PathReference = PathReference;
//# sourceMappingURL=data:application/json;base64,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